/*
 * epwm1cfg.h
 */

#ifndef _EPWM1CFG_H_
#define _EPWM1CFG_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Count Up, 1KHz, 50% duty cycle.
 *
 * TBCTR[15:0]    ↑
 *                |
 * TBPRD          |
 * (10,000) -----►|------|------|----
 *                |     /|     /|
 *                |    / |    / |
 *                |   /  |   /  |
 *                |  /   |  /   |  /
 *                | /    | /    | /
 *           0000 |/_____|/_____|/
 *                |      |      |
 *                |      |      |
 *                |      |_     |_
 * CTR = zero ---►|______| |____| |__
 *                |      |      |
 *                |      |_     |_
 * CTR = PRD ----►|______| |____| |__
 *
 */

/*
 * UP Count Mode
 * SHADOW Load Mode
 * CNTR = 0 SYNC Output Select
 * 1,000Hz Period
 *     SYSCLK = 200,000,000 Hz
 *     EPWMCLK Prescale = 2 -> ePWMCLK = 100,000,000 Hz
 *     1,000 = 100,000,000 Hz ÷ (HSPCLKDIV x CLKDIV x TPRD)
 *     (HSPCLKDIV x CLKDIV x [TPRD + 1]) = 100,000
 *     HSPCLKDIV = 10, CLKDIV = 1, TPRD = 10,000 - 1
 */



#ifdef __cplusplus
}
#endif

#endif /* _EPWM1CFG_H_ */
