/*
 * epwmxcfg.h
 */

#ifndef _EPWMXCFG_H_
#define _EPWMXCFG_H_


#ifdef __cplusplus
extern "C" {
#endif

/*
 *             __________             __________
 *            |          |           |          |
 *  SYSCLK    |          | EPWMCLK   |          | TBCLK
 *  ---------►| EPWMCLK  | ---------►|  Clock   | ------►
 *            | Prescale |           | Prescale |
 *            |__________|           |__________|
 */

#define eWPMxSYSCLK_PRESCALE_1                      ( 0 )
#define eWPMxSYSCLK_PRESCALE_2                      ( 1 )
/*
 * PERCLKDIVSEL Register, Page 313 TRM
 * -----------------------------------------------------------------------------
 * | 31    07 |      06     |    05    |      04     | 03    02 | 01     00  |
 * | RESERVED | EMIF2CLKDIV | RESERVED | EMIF1CLKDIV | RESERVED | EPWMCLKDIV |
 * -----------------------------------------------------------------------------
 * EPWMCLKDIV   :   EPWM Clock Divide Select: This bit selects whether the EPWM
 *                  modules run with a /1 or /2 clock. This divider sits in
 *                  front of the PLLSYSCLK
 *                  x0 = /1 of PLLSYSCLK
 *                  x1 = /2 of PLLSYSLCK (default on reset)
 */
#define ePWMxSYSCLK_PRESCALE_VALUE              ( eWPMxSYSCLK_PRESCALE_2 )

/*                    ___________              __
 *  EPWMxSYNCI       |           | CTR = PRD _|  |_
 *  ----------------►|           |-----------------►  (Alt 16)
 *                   |           |             __
 *  EPWMxSYNCO       |           | CTR = 0   _|  |_
 *  ◄----------------| Time-Base |-----------------►
 *                   |    (TB)   |             __
 *  Digital Compare  |           | CTR_Dir   _|  |_
 *     Signals       |           |-----------------►
 *  ----------------►|___________|
 */

#define ePWMx_CLK_PRESCALE_1                    ( 0 << 10 )
#define ePWMx_CLK_PRESCALE_2                    ( 1 << 10 )
#define ePWMx_CLK_PRESCALE_4                    ( 2 << 10 )
#define ePWMX_CLK_PRESCALE_8                    ( 3 << 10 )
#define ePWMX_CLK_PRESCALE_16                   ( 4 << 10 )
#define ePWMX_CLK_PRESCALE_32                   ( 5 << 10 )
#define ePWMX_CLK_PRESCALE_64                   ( 6 << 10 )
#define ePWMX_CLK_PRESCALE_128                  ( 7 << 10 )

#define ePWMx_HSPCLK_PRESCALE_1                 ( 0 << 7 )
#define ePWMx_HSPCLK_PRESCALE_2                 ( 1 << 7 )
#define ePWMx_HSPCLK_PRESCALE_4                 ( 2 << 7 )
#define ePWMx_HSPCLK_PRESCALE_6                 ( 3 << 7 )
#define ePWMx_HSPCLK_PRESCALE_8                 ( 4 << 7 )
#define ePWMx_HSPCLK_PRESCALE_10                ( 5 << 7 )
#define ePWMx_HSPCLK_PRESCALE_12                ( 6 << 7 )
#define ePWMx_HSPCLK_PRESCALE_14                ( 7 << 7 )

#define ePWMx_SYNCOUT_ON_SOFT_TRIG              ( 0 << 4 )
#define ePWMx_SYNCOUT_ON_CTR_EQ_ZERO_TRIG       ( 1 << 4 )
#define ePWMx_SYNCOUT_ON_CTR_EQ_CMPB_TRIG       ( 2 << 4 )
#define ePWMx_SYNCOUT_TBCTL2_SYNCOSEL_TRIG      ( 3 << 4 )

#define ePWMx_SHADOW_PERIOD_LOAD                ( 0 << 3 )
#define ePWMx_IMMEDIATE_PERIOD_LOAD             ( 1 << 3 )

#define ePWMx_LOAD_PRD_CNTR_FROM_PHASE_REG      ( 1 << 2 )

#define ePWMx_COUNT_UP_MODE                     ( 0 )
#define ePWMx_COUNT_DOWN_MODE                   ( 1 )
#define ePWMx_COUNT_UP_DWON_MODE                ( 2 )
/*
 * TBCTL Register, Page 1857 TRM
 * -----------------------------------------------------------------------------
 * | 15     14 |   13    | 12  10 | 09     08 |
 * | FREE_SOFT | PHSDIR  | CLKDIV | HSPCLKDIV |
 * |----------------------------------------------------------|
 * |----------------------------------------------------------|
 * |     07    |    06   |    05    |   03  |   02  | 01   00 |
 * | HSPCLKDIV | SWFSYNC | SYNCOSEL | PRDLD | PHSEN | CTRMODE |
 * -----------------------------------------------------------------------------
 */
/*
 * PHSDIR   :   This bit is only used when the time-base counter is configured
 *              in the up-down-count mode. The PHSDIR bit indicates the
 *              direction the time-base counter will count after a
 *              synchronization event occurs and a new phase value is loaded
 *              from the phase register. This is irrespective of the direction
 *              of the counter before the synchronization event.
 *              In the up-count and down-count modes this bit is ignored.
 *              0: Count down after the synchronization event.
 *              1: Count up after the synchronization event.
 */
/*
 * CLKDIV   :   These bits select the time base clock pre-scale value.
 *              000: /1 (default on reset)
 *              001: /2
 *              010: /4
 *              011: /8
 *              100: /16
 *              101: /32
 *              110: /64
 *              111: /128
 */
/*
 * HSPCLKDIV:   These bits determine part of the time-base clock prescale value.
 *              TBCLK = EPWMCLK / (HSPCLKDIV x CLKDIV).
 *              000: /1
 *              001: /2 (default on reset)
 *              010: /4
 *              011: /6
 *              100: /8
 *              101: /10
 *              110: /12
 *              111: /114
 */
/*
 * SWFSYNC  :   Software Forced Sync Pulse
 *              0: Writing a 0 has no effect and reads always return a 0.
 *              1: Writing a 1 forces a one-time synchronization pulse to be
 *                 generated.
 *              SWFSYNC affects EPWMxSYNCO only when SYNCOSEL = 00.
 */
/*
 * SYNCOSEL :   Sync Output Select
 *              00: EPWMxSYNCI / SWFSYNC
 *              01: CTR = zero: Time-base counter equal to zero (TBCTR = 0x00)
 *              10: CTR = CMPB : Time-base counter equal to counter-compare B
 *                  (TBCTR = CMPB)
 *              11: EPWMXSYNCO is defined by TBCTL2[SYNCOSELX]
 */
/*
 * PRDLD    :   Active Period Register Load from Shadow Select
 *              0: The period register (TBPRD) is loaded from its shadow
 *                 register when the time-base counter, TBCTR, is equal to zero
 *                 and/or a sync event as determined by the TBCTL2[PRDLDSYNC]
 *                 bit.
 *              1: Immediate Mode (Shadow register bypassed): A write or read to
 *                 the TBPRD register accesses the active register.
 */
/*
 * PHSEN    :   Counter Register Load from Phase Register Enable
 *              0: Do not load the time-base counter (TBCTR) from the time-base
 *                 phase register (TBPHS).
 *              1: Allow Counter to be loaded from the Phase register (TBPHS)
 *                 and shadow to active load events when an EPWMxSYNCI input
 *                 signal occurs or a software-forced sync signal, see bit 6.
 */
/*
 * CTRMODE  :   Counter Mode
 *              00: Up-count mode
 *              01: Down-count mode
 *              10: Up-down count mode
 *              11: Freeze counter operation (default on reset)
 */

#define eWPM1_SHADOW_TO_ACIVE_LOAD_ON_TBCTR_EQ_ZERO             ( 0 << 14 )
#define eWPM1_SHADOW_TO_ACIVE_LOAD_ON_TBCTR_EQ_ZERO_OR_ON_SYNC  ( 1 << 14 )
#define eWPM1_SHADOW_TO_ACIVE_LOAD_ON_TBCTR_ON_SYNC             ( 2 << 14 )

#define ePWM1_SYNCOUT_DISABLED                                  ( 0 << 12 )
#define ePWM1_SYNCOUT_ON_CTR_EQ_CMPC_TRIG                       ( 1 << 12 )
#define ePWM1_SYNCOUT_ON_CTR_EQ_CMPD_TRIG                       ( 2 << 12 )
/*
 *  * TBCTL2 Register, Page 1860 TRM
 * -----------------------------------------------------------------------------
 * | 15     14 | 13     12 | 11    08 |    07    |      06      | 04    00 |
 * | PRDLDSYNC | SYNCOSELX | RESERVED | OSHTSYNC | OSHTSYNCMODE | RESERVED |
 * -----------------------------------------------------------------------------
 */
/*
 * PRDLDSYNC    :   Shadow to Active Period Register Load on SYNC event
 *                  00: Shadow to Active Load of TBPRD occurs only when
 *                      TBCTR = 0
 *                  01: Shadow to Active Load of TBPRD occurs both when
 *                      TBCTR = 0 and when SYNC occurs.
 *                  10: Shadow to Active Load of TBPRD occurs only when a SYNC
 *                      is received.
 *                  11: Reserved.
 */
/*
 * SYNCOSELX    :   Extended selection bits for SYNCOUT
 *                  00: Disabled EPWMxSYNCO sync signal
 *                  01: EPWMxSYNCO = CMPC
 *                  10: EPWMxSYNCO = CMPD
 *                  11: Reserved
 */
/*
 * OSHTSYNC     :   Oneshot sync bit
 *                  0: Writing a '0' has no effect.
 *                  1: Allow one sync pulse to propogate.
 */
/*
 * OSHTSYNCMODE :   Oneshot sync enable bit
 *                  0: Oneshot sync mode disabled
 *                  1: Oneshot sync mode enabled
 */

#define CFG_EPWM1                       ( 1 )

#if( CFG_EPWM1 )
#include "epwm1cfg.h"
#endif

#ifdef __cplusplus
}
#endif

#endif /* _EPWMXCFG_H_ */
