/*
 * gpiocfg.h
 */

#ifndef _GPIOCFG_H_
#define _GPIOCFG_H_


#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#define CFG_PORTA                   ( 1 )
#define CFG_PORTB                   ( 0 )
#define CFG_PORTC                   ( 0 )
#define CFG_PORTD                   ( 0 )
#define CFG_PORTE                   ( 0 )
#define CFG_PORTF                   ( 0 )

#define CFG_PORTs                   ( ( CFG_PORTA ) |   \
                                      ( CFG_PORTB ) |   \
                                      ( CFG_PORTC ) |   \
                                      ( CFG_PORTD ) |   \
                                      ( CFG_PORTE ) |   \
                                      ( CFG_PORTF )     \
                                    )

#if( CFG_PORTA )

/*
 * GPACTRL Register, Page 846 TRM
 * =============================================
 * | 31    24 | 23    16 | 15    08 | 07    00 |
 * | QUALPRD3 | QUALPRD2 | QUALPRD1 | QUALPRD0 |
 * ---------------------------------------------
 * Sampling Period
 * If GPxCTRL[QUALPRDn] = 0 1 × TSYSCLKOUT
 * If GPxCTRL[QUALPRDn] ≠ 0 2 × GPxCTRL[QUALPRDn] × TSYSCLKOUT
 *                        Where TSYSCLKOUT is the period in time of SYSCLKOUT
 */
#define GPACTRL_REG_VALUE               ( 0x00000000 )

/*
 * GPAQSEL1 Register, Page 847 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO15 | GPIO14 | GPIO13 | GPIO12 | GPIO11 | GPIO10 | GPIO09 | GPIO08 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO07 | GPIO06 | GPIO05 | GPIO04 | GPIO03 | GPIO02 | GPIO01 | GPIO00 |
 * -------------------------------------------------------------------------
 * Input qualification type:
 * 0,0 Sync
 * 0,1 Qualification (3 samples)
 * 1,0 Qualification (6 samples)
 * 1,1 Async (no Sync or Qualification)
 */
#define GPAQSEL1_REG_VALUE              ( 0x00000000 )

/*
 * GPAQSEL2 Register, Page 849 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO31 | GPIO30 | GPIO29 | GPIO28 | GPIO27 | GPIO26 | GPIO25 | GPIO24 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO23 | GPIO22 | GPIO21 | GPIO20 | GPIO19 | GPIO18 | GPIO17 | GPIO16 |
 * -------------------------------------------------------------------------
 * Input qualification type:
 * 0,0 Sync
 * 0,1 Qualification (3 samples)
 * 1,0 Qualification (6 samples)
 * 1,1 Async (no Sync or Qualification)
 */
#define GPAQSEL2_REG_VALUE              ( 0x00000000 )

/*
 * GPAMUX1 Register, Page 849 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO15 | GPIO14 | GPIO13 | GPIO12 | GPIO11 | GPIO10 | GPIO09 | GPIO08 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO07 | GPIO06 | GPIO05 | GPIO05 | GPIO03 | GPIO02 | GPIO01 | GPIO00 |
 * -------------------------------------------------------------------------
 * Clear the bits which corresponds to GPIO input/output
 * For example to configure GPIO12 as a GPIO output pin set bits 25:24.
 */
#define GPAMUX1_REG_VALUE              ( ~( ( ( uint32_t )( 3 ) ) << 24 ) )

/*
 * GPAMUX2 Register, Page 853 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO31 | GPIO30 | GPIO29 | GPIO28 | GPIO27 | GPIO26 | GPIO25 | GPIO24 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO23 | GPIO22 | GPIO21 | GPIO20 | GPIO19 | GPIO18 | GPIO17 | GPIO16 |
 * -------------------------------------------------------------------------
 * Clear the bits which corresponds to GPIO input/output
 * For example to configure GPIO28 as a GPIO output pin set bits 25:24.
 */
#define GPAMUX2_REG_VALUE              ( ~( ( ( uint32_t )( 3 ) ) << 24 ) )

/*
 * GPADIR Register, Page 855
 * GPIO A Direction Register (GPIO0 to 31)
 * 0: Configures pin as input.
 * 1: Configures pin as output.
 * Clear the bits in the Mask to configure the GPIOs direction
 */
#define GPADIR_REG_MASK_VALUE           ( ~( ( ( uint32_t )( 1 ) ) << 12 ) )
#define GPADIR_REG_VALUE                ( ( ( uint32_t )( 1 ) ) << 12 )

/*
 * GPAPUD Register, Page 857
 * GPIO A Pull Up Disable Register (GPIO0 to 31)
 * 0: Enables the Pull-Up.
 * 1: Disables the Pull-Up.
 * Clear the Mask bits to configure the GPIOs pull-up
 */
#define GPAPUD_REG_MASK_VALUE           ( ~( ( ( uint32_t )( 1 ) ) << 12 ) )
#define GPAPUD_REG_VALUE                ( ( ( uint32_t )( 1 ) ) << 12 )

#define GPAODR_REG_VALUE                ( 0x00000000 )

/*
 * GPAMGUX1 Register, Page 863 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO15 | GPIO14 | GPIO13 | GPIO12 | GPIO11 | GPIO10 | GPIO09 | GPIO08 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO07 | GPIO06 | GPIO05 | GPIO05 | GPIO03 | GPIO02 | GPIO01 | GPIO00 |
 * -------------------------------------------------------------------------
 * Clear the bits which corresponds to GPIO input/output
 * For example to configure GPIO12 as a GPIO output pin set bits 25:24.
 */
#define GPAGMUX1_REG_VALUE              ( ~( ( ( uint32_t )( 3 ) ) << 24 ) )

/*
 * GPAGMUX2 Register, Page 864 TRM
 * =========================================================================
 * | 31  30 | 29  28 | 27  26 | 25  24 | 23  22 | 21  20 | 19  18 | 17  16 |
 * | GPIO31 | GPIO30 | GPIO29 | GPIO28 | GPIO27 | GPIO26 | GPIO25 | GPIO24 |
 * -------------------------------------------------------------------------
 * | 15  14 | 13  12 | 11  10 | 09  08 | 07  06 | 05  05 | 03  02 | 01  00 |
 * | GPIO23 | GPIO22 | GPIO21 | GPIO20 | GPIO19 | GPIO18 | GPIO17 | GPIO16 |
 * -------------------------------------------------------------------------
 * Set the bits which corresponds to GPIO input/output
 * For example to configure GPIO28 as a GPIO output pin set bits 25:24.
 */
#define GPAGMUX2_REG_VALUE              ( ~( 0x00000000 ) )

/*
 * GPACSEL1 Register, Page 865
 * GPIO A Core Select Register (GPIO0 to 7)
 * xx00: CPU1 selected
 * xx01: CPU1.CLA1 selected
 * xx1x: Reserved
 * =========================================================================
 * | 31  28 | 27  24 | 23  20 | 19  16 | 17  12 | 11  08 | 07  04 | 03   00|
 * | GPIO07 | GPIO06 | GPIO05 | GPIO04 | GPIO03 | GPIO02 | GPIO01 | GPIO00 |
 * -------------------------------------------------------------------------
 * Clear the Mask bits to configure ownerships of the GPIO pins
 */
#define GPACSEL1_REG_MASK_VALUE         ( 0xFFFFFFFF )
#define GPACSEL1_REG_VALUE              ( 0x00000000 )

/*
 * GPACSEL2 Register, Page 866
 * GPIO A Core Select Register (GPIO8 to 15)
 * xx00: CPU1 selected
 * xx01: CPU1.CLA1 selected
 * xx1x: Reserved
 * =========================================================================
 * | 31  28 | 27  24 | 23  20 | 19  16 | 17  12 | 11  08 | 07  04 | 03   00|
 * | GPIO15 | GPIO14 | GPIO13 | GPIO12 | GPIO11 | GPIO10 | GPIO09 | GPIO08 |
 * -------------------------------------------------------------------------
 * Clear the Mask bits to configure ownerships of the GPIO pins
 */
#define GPACSEL2_REG_MASK_VALUE         ( ~( ( ( uint32_t )( 3 ) ) << 16 ) )
#define GPACSEL2_REG_VALUE              ( ( ( uint32_t )( 1 ) ) << 16 )

/*
 * GPACSEL3 Register, Page 867
 * GPIO A Core Select Register (GPIO16 to 23)
 * xx00: CPU1 selected
 * xx01: CPU1.CLA1 selected
 * xx1x: Reserved
 * =========================================================================
 * | 31  28 | 27  24 | 23  20 | 19  16 | 17  12 | 11  08 | 07  04 | 03   00|
 * | GPIO23 | GPIO22 | GPIO21 | GPIO20 | GPIO19 | GPIO18 | GPIO17 | GPIO16 |
 * -------------------------------------------------------------------------
 * Clear the Mask bits to configure ownerships of the GPIO pins
 */
#define GPACSEL3_REG_MASK_VALUE         ( 0xFFFFFFFF )
#define GPACSEL3_REG_VALUE              ( 0x00000000 )

/*
 * GPACSEL4 Register, Page 868
 * GPIO A Core Select Register (GPIO24 to 31)
 * xx00: CPU1 selected
 * xx01: CPU1.CLA1 selected
 * xx1x: Reserved
 * =========================================================================
 * | 31  28 | 27  24 | 23  20 | 19  16 | 17  12 | 11  08 | 07  04 | 03   00|
 * | GPIO31 | GPIO30 | GPIO29 | GPIO28 | GPIO27 | GPIO26 | GPIO25 | GPIO24 |
 * -------------------------------------------------------------------------
 * Clear the Mask bits to configure ownerships of the GPIO pins
 */
#define GPACSEL4_REG_MASK_VALUE         ( 0xFFFFFFFF )
#define GPACSEL4_REG_VALUE              ( 0x00000000 )


/*
 * GPADAT Register, Page 1009
 * GPIO A Data Register (GPIO0 to 31)
 * Clear the Mask bits to configure the initial values of the gpios.
 */
#define GPADAT_REG_MASK_VALUE           ( ~( ( ( uint32_t )( 1 ) ) << 12 ) )
#define GPADAT_REG_VALUE                ( 0x00000000 )

#endif  /* CFG_PORTA */

#if( CFG_PORTB )

#endif  /* CFG_PORTB */

#if( CFG_PORTC )

#endif  /* CFG_PORTC */

#if( CFG_PORTC )

#endif  /* CFG_PORTC */


#if( CFG_PORTD )

#endif  /* CFG_PORTD */
#if( CFG_PORTE )

#endif  /* CFG_PORTE */

#if( CFG_PORTF )

#endif  /* CFG_PORTF */

#if( CFG_PORTs )
void gpiocfg( void );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _GPIOCFG_H_ */
