/*
 * cla1cfg.c
 */

#include "../../inc/F2837xS_device.h"
#include "../inc/cla1cfg.h"

#if( CFG_CLA1 )

#include <string.h>

/*
 * These are created by the Linker.
 */
extern uint32_t Cla1ProgRunStart, Cla1ProgLoadStart, Cla1ProgLoadSize;
extern uint32_t Cla1ConstRunStart, Cla1ConstLoadStart, Cla1ConstLoadSize;

#if( CFG_CLA1_TO_CPU_INIT )
static void CLA1_Taskx_ISR( cla1isr isr, uint16_t MICLROVFValue )
{
    if( isr != NULL )
        isr();

    EALLOW;
    Cla1Regs.MICLROVF.all   = MICLROVFValue;               // Clear all overflow flags
    PieCtrlRegs.PIEACK.all  = PIEACK_GROUP11;
    EDIS;
}
#endif

#if( CFG_CLA1_TASK1_CPU_INIT_EN )
cla1isr CAL1_Task1_ISR = NULL;
__interrupt void CLA1_TASK1_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task1_ISR, 0x0001 );
}
#endif

#if( CFG_CLA1_TASK2_CPU_INIT_EN )
cla1isr CAL1_Task2_ISR = NULL;
__interrupt void CLA1_TASK2_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task2_ISR, 0x0002 );
}
#endif

#if( CFG_CLA1_TASK3_CPU_INIT_EN )
cla1isr CAL1_Task3_ISR = NULL;
__interrupt void CLA1_TASK3_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task3_ISR, 0x0004 );
}
#endif

#if( CFG_CLA1_TASK4_CPU_INIT_EN )
cla1isr CAL1_Task4_ISR = NULL;
__interrupt void CLA1_TASK4_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task4_ISR, 0x0008 );
}
#endif

#if( CFG_CLA1_TASK5_CPU_INIT_EN )
cla1isr CAL1_Task5_ISR = NULL;
__interrupt void CLA1_TASK5_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task5_ISR, 0x0010 );
}
#endif

#if( CFG_CLA1_TASK6_CPU_INIT_EN )
cla1isr CAL1_Task6_ISR = NULL;
__interrupt void CLA1_TASK6_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task6_ISR, 0x0020 );
}
#endif

#if( CFG_CLA1_TASK7_CPU_INIT_EN )
cla1isr CAL1_Task7_ISR = NULL;
__interrupt void CLA1_TASK7_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task7_ISR, 0x0040 );
}
#endif

#if( CFG_CLA1_TASK8_CPU_INIT_EN )
cla1isr CAL1_Task8_ISR = NULL;
__interrupt void CLA1_TASK8_INTI( void )
{
    CLA1_Taskx_ISR( CAL1_Task8_ISR, 0x0080 );
}
#endif

static void mapLSRAMToCLA( uint16_t memorySpaceType )
{
#if( CFG_LS0_MEMORY_SHARE )
    if( CFG_LS0_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS0 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS0 = CFG_LS0_MEMORY_SHARE_TYPE;
    }
#endif

#if( CFG_LS1_MEMORY_SHARE )
    if( CFG_LS1_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS1 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS1 = CFG_LS1_MEMORY_SHARE_TYPE;
    }
#endif

#if( CFG_LS2_MEMORY_SHARE )
    if( CFG_LS2_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS2 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS2 = CFG_LS2_MEMORY_SHARE_TYPE;
    }
#endif

#if( CFG_LS3_MEMORY_SHARE )
    if( CFG_LS2_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS3 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS3 = CFG_LS3_MEMORY_SHARE_TYPE;
    }
#endif

#if( CFG_LS4_MEMORY_SHARE )
    if( CFG_LS4_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS4 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS4 = CFG_LS4_MEMORY_SHARE_TYPE;
    }
#endif

#if( CFG_LS5_MEMORY_SHARE )
    if( CFG_LS5_MEMORY_SHARE_TYPE == memorySpaceType)
    {
        MemCfgRegs.LSxMSEL.bit.MSEL_LS5 = 1;
        MemCfgRegs.LSxCLAPGM.bit.CLAPGM_LS5 = CFG_LS5_MEMORY_SHARE_TYPE;
    }
#endif
}

void cla1cfg( void )
{
    /*
     * See Page 657 of the TRM.
     */

    /*
     * 1. Copy CLA code into the CLA program RAM.
     *    use void * memcpy ( void * destination, const void * source, size_t num )
     *    to copy over the "Cla1Prog" and ".const_cla" sections from Flash to RAM
     */
    memcpy( ( ( uint32_t* )( &Cla1ProgRunStart ) ),
            ( ( uint32_t* )( &Cla1ProgLoadStart ) ),
            ( ( size_t )( &Cla1ProgLoadSize ) )
          );

     /*
      * 2. Initialize CLA data RAM, if necessary.
      *    Populate the CLA data RAM with any required data coefficients or
      *    constants.
      */
    if( Cla1ConstLoadSize > 0 )
    {
        memcpy( ( ( uint32_t*)( &Cla1ConstRunStart ) ),
                ( ( uint32_t* )( &Cla1ConstLoadStart ) ),
                ( ( size_t )( &Cla1ConstLoadSize ) )
              );
    }

    EALLOW;

    /*
     * 3. Configure the CLA registers
     *    Configure the CLA registers, but keep interrupts disabled until later
     *    (leave MIER = 0):
     * Initialize and wait for CLA1ToCPUMsgRAM
     */

    /***************************************************************************
     * MSGxINIT Register - page 465 TRM
     * -------------------------------------------------------------------------
     * | 31    03 |       02       |        01     |      00       |
     * | RESERVED | INIT_CAL1TOCPU | INIT_CPUTOCAL1| INIT_CPUTOCPU |
     * -------------------------------------------------------------
     * INIT_CLA1TOCPU : RAM Initialization control for CLA1TOCPU MSG RAM:
     *                  0: None
     *                  1: Start RAM Initialization.
     *
     * INIT_CPUTOCLA1 : RAM Initialization control for CPUTOCLA1 MSG RAM:
     *                  0: None
     *                  1: Start RAM Initialization.
     * INIT_CPUTOCLA1 : RAM Initialization control for CPUTOCPU MSG RAM:
     *                  0: None
     *                  1: Start RAM Initialization.
     */

    MemCfgRegs.MSGxINIT.bit.INIT_CLA1TOCPU = 1;
    while( MemCfgRegs.MSGxINITDONE.bit.INITDONE_CLA1TOCPU != 1 ){};

    /*
     * Initialize and wait for CPUToCLA1MsgRAM
     */
    MemCfgRegs.MSGxINIT.bit.INIT_CPUTOCLA1 = 1;
    while(MemCfgRegs.MSGxINITDONE.bit.INITDONE_CPUTOCLA1 != 1){};

    /*
     * Enable the CLA peripheral clock using the assigned PCLKCRn register
     */
#pragma  diag_suppress 770

    CpuSysRegs.PCLKCR0.bit.CLA1         = 1;
    CpuSysRegs.PCLKCR0.bit.DMA          = 1;
    __asm(" RPT #255 || NOP");

    /*
     * Populate the CLA task interrupt vectors
     */

#if( CFG_CLA1_TASK1 )
    Cla1Regs.MVECT1 = CLA1_TASK1_MVECT;
#if( CFG_CLA1_TASK1_CPU_INIT_EN )
    PieVectTable.CLA1_1_INT             = CLA1_TASK1_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_1     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK2 )
    Cla1Regs.MVECT2 = CLA1_TASK2_MVECT;
#if( CFG_CLA1_TASK2_CPU_INIT_EN )
    PieVectTable.CLA1_2_INT             = CLA1_TASK2_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_2     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK3 )
    Cla1Regs.MVECT3 = CLA1_TASK3_MVECT;
#if( CFG_CLA1_TASK3_CPU_INIT_EN )
    PieVectTable.CLA1_3_INT             = CLA1_TASK3_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_3     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK4 )
    Cla1Regs.MVECT4 = CLA1_TASK4_MVECT;
#if( CFG_CLA1_TASK4_CPU_INIT_EN )
    PieVectTable.CLA1_4_INT             = CLA1_TASK4_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_4     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK5 )
    Cla1Regs.MVECT5 = CLA1_TASK5_MVECT;
#if( CFG_CLA1_TASK5_CPU_INIT_EN )
    PieVectTable.CLA1_5_INT             = CLA1_TASK5_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_5     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK6 )
    Cla1Regs.MVECT6 = CLA1_TASK6_MVECT;
#if( CFG_CLA1_TASK6_CPU_INIT_EN )
    PieVectTable.CLA1_6_INT             = CLA1_TASK6_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_6     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK7 )
    Cla1Regs.MVECT7 = CLA1_TASK7_MVECT;
#if( CFG_CLA1_TASK7_CPU_INIT_EN )
    PieVectTable.CLA1_7_INT             = CLA1_TASK7_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_7     = 0x01;
#endif
#endif

#if( CFG_CLA1_TASK8 )
    Cla1Regs.MVECT8                     = CLA1_TASK8_MVECT;
#if( CFG_CLA1_TASK8_CPU_INIT_EN )
    PieVectTable.CLA1_8_INT             = CLA1_TASK8_INTI;
    PieCtrlRegs.PIEIER11.bit.CLA1_8     = 0x01;
#endif
#endif

    /*
     * Select the task interrupt sources.
     * For each task select the interrupt source in the CLA1TASKSRCSELx
     * register. If a task is software triggered, select no interrupt.
     */

#if( CFG_CLA1_TASK1 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK1  = CFG_CAL1_TASK1_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT1                      = 1;
#endif

#if( CFG_CLA1_TASK2 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK2  = CFG_CAL1_TASK2_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT2                      = 1;
#endif

#if( CFG_CLA1_TASK3 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK3  = CFG_CAL1_TASK3_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT3                      = 1;
#endif

#if( CFG_CLA1_TASK4 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL1.bit.TASK4  = CFG_CAL1_TASK4_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT4                      = 1;
#endif

#if( CFG_CLA1_TASK5 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL2.bit.TASK5  = CFG_CAL1_TASK5_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT5                      = 1;
#endif

#if( CFG_CLA1_TASK6 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL2.bit.TASK6  = CFG_CAL1_TASK6_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT6                      = 1;
#endif

#if( CFG_CLA1_TASK7 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL2.bit.TASK7  = CFG_CAL1_TASK7_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT7                      = 1;
#endif

#if( CFG_CLA1_TASK8 )
    DmaClaSrcSelRegs.CLA1TASKSRCSEL2.bit.TASK8  = CFG_CAL1_TASK8_TRIGGER_SRC;
    Cla1Regs.MIER.bit.INT8                      = 1;
#endif

    /*
     * Enable IACK to start a task from software, if desired
     */
    Cla1Regs.MCTL.bit.IACKE             = 1;

    /*
     * Map CLA data RAM to CLA space, if necessary.
     * Map the data RAM to the CLA space by first, assigning ownership of the
     * memory block to the CLA by writing a 1 to the memory blocks
     * MemCfgRegs.LSxMSEL[MSEL_LSx] bit, and then specifying the memory block
     * as a CLA data block by writing a 0 to the
     * MemCfgRegs.LSxCLAPGM[CLAPGM_LSx] bit.
     * When an LSx memory is configured as a CLA data memory, the CLA
     * read/write accesses are arbitrated along with CPU accesses.
     */
    mapLSRAMToCLA( CFG_LSx_AS_DATA_MEMORY );

    /*
     * Map CLA program RAM to CLA space.
     * Map the CLA program RAM to CLA space by first assigning ownership of the
     * memory block to the CLA by writing a 1 to the memory blocks
     * MemCfgRegs.LSxMSEL[MSEL_LSx] bit, and then specifying the memory block as
     * CLA code memory by writing a 1 to the MemCfgRegs.LSxCLAPGM[CLAPGM_LSx]
     * bit.
     */
    mapLSRAMToCLA( CFG_LSx_AS_PROGRAM_MEMORY );

    /*
     * 4. Initialize the PIE vector table and registers.
     *    When a CLA task completes, the associated interrupt in the PIE will be
     *    flagged. The CLA overflow and underflow flags also have associated
     *    interrupts within the PIE.
     */
#if( CFG_CLA1_TO_CPU_INIT )
    /*
     * <Step 7> :
     * - Enable the PIE group and subgroup for CLA1 interrupt
     */
    IER                                |=  M_INT11;
#endif

    /*
     * 5. Enable CLA tasks/interrupts.
     * Set appropriate bits in the interrupt enable register (MIER) to allow the
     * CLA to service interrupts.
     */

    // This is done in the appstart function.
    //Cla1Regs.MICLR.all      = 0x00FF;               // Clear all interrupt flags
    //Cla1Regs.MICLROVF.all   = 0x00FF;               // Clear all overflow flags
    //Cla1Regs.MIER.all       = CLA1_MIER_REG_VALUE;

    /*
     * 6. Initialize other peripherals.
     *    Initialize any peripherals (such as ePWM, ADC, and others) that will
     *    generate interrupt triggers for enabled CLA tasks.
     */
    EDIS;
}
#endif      /* CFG_CLA1 */
