/*
 * cputmrcfg.c
 */
#include "../../inc/F2837xS_device.h"
#include "../inc/cputmrcfg.h"

#define CPUTMRxTIE_BIT              ( 1 << 14 )

#if(CFG_CPUTMR0)

cuptmrisr CPUTMR00isr = NULL;
uint32_t u32CPUTMR0Cnts = 0;

uint32_t cputmr0value( void )
{
    return u32CPUTMR0Cnts;
}

#if( CPUTMR0_TCR_REG_VALUE & CPUTMRxTIE_BIT )
interrupt void CPUTMR0_ISR( void )
{
    u32CPUTMR0Cnts += CPUTMR0_PERI0D_US;

    if( CPUTMR00isr != NULL )
        CPUTMR00isr();

    EALLOW;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    EDIS;
}
#endif

static void cputmr0cfg( void )
{
    // Enable the CPUTIMER0 Clock, Page 326 TRM
    CpuSysRegs.PCLKCR0.bit.CPUTIMER0  = 1;
    asm(" RPT #50 || NOP");

    // Stop timer.
    CpuTimer0Regs.TCR.bit.TSS = 1;

    EALLOW;

    CpuTimer0Regs.TPR.bit.TDDR   = ( CPUTMR0_TPR_REG_VALUE  & 0xFF );
    CpuTimer0Regs.TPRH.bit.TDDRH = ( CPUTMR0_TPRH_REG_VALUE & 0xFF );
    CpuTimer0Regs.PRD.all        = CPUTMR0_PRD_REG_VALUE;

    if( CPUTMR0_TCR_REG_VALUE & CPUTMRxTIE_BIT )
    {
        PieVectTable.TIMER0_INT         = CPUTMR0_ISR;
        CpuTimer0Regs.TCR.bit.TIF       = 0;
        CpuTimer0Regs.TCR.bit.TIE       = 1;
        PieCtrlRegs.PIEIFR1.bit.TIMER0  = 0;
        PieCtrlRegs.PIEIER1.bit.TIMER0  = 1;
        IER                            |=  M_INT1;
    }

    EDIS;

    // Remember to start the time at the appropriate time
}
#endif


#if(CFG_CPUTMR1)

#endif


#if(CFG_CPUTMR2)

#endif


void cputmrcfg( void )
{
#if(CFG_CPUTMR0)
    cputmr0cfg();
#endif


#if(CFG_CPUTMR1)

#endif


#if(CFG_CPUTMR2)

#endif
}

