/*
 * gpiocfg.c
 */

#include "../../inc/F2837xS_device.h"
#include "../inc/gpiocfg.h"

#if( CFG_PORTs )

/*
 * When changing the GPyGMUX value for a pin, always set the corresponding
 * GPyMUX bits to zero first to avoid glitching in the muxes.
 */

#if( CFG_PORTA )
static void gpioacfg( void )
{

    GpioCtrlRegs.GPACTRL.all     = GPACTRL_REG_VALUE;
    GpioCtrlRegs.GPAQSEL1.all    = GPAQSEL1_REG_VALUE;
    GpioCtrlRegs.GPAQSEL2.all    = GPAQSEL2_REG_VALUE;
    GpioCtrlRegs.GPAMUX1.all    &= GPAMUX1_REG_VALUE;
    GpioCtrlRegs.GPAMUX2.all    &= GPAMUX2_REG_VALUE;
    GpioCtrlRegs.GPAGMUX1.all   &= GPAGMUX1_REG_VALUE;
    GpioCtrlRegs.GPAGMUX2.all   &= GPAGMUX2_REG_VALUE;
    GpioCtrlRegs.GPACSEL1.all   &= GPACSEL1_REG_MASK_VALUE;
    GpioCtrlRegs.GPACSEL1.all   |= GPACSEL1_REG_VALUE;
    GpioCtrlRegs.GPACSEL2.all   &= GPACSEL2_REG_MASK_VALUE;
    GpioCtrlRegs.GPACSEL2.all   |= GPACSEL2_REG_VALUE;
    GpioCtrlRegs.GPACSEL3.all   &= GPACSEL3_REG_MASK_VALUE;
    GpioCtrlRegs.GPACSEL3.all   |= GPACSEL3_REG_VALUE;
    GpioCtrlRegs.GPACSEL4.all   &= GPACSEL4_REG_MASK_VALUE;
    GpioCtrlRegs.GPACSEL4.all   |= GPACSEL4_REG_VALUE;

    GpioCtrlRegs.GPAPUD.all     &= GPAPUD_REG_MASK_VALUE;
    GpioCtrlRegs.GPAPUD.all     |= GPAPUD_REG_VALUE;
    //GpioCtrlRegs.GPAODR.all      = GPAODR_REG_VALUE;

    GpioDataRegs.GPADAT.all     &= GPADAT_REG_MASK_VALUE;
    GpioDataRegs.GPADAT.all     |= GPADAT_REG_VALUE;

    GpioCtrlRegs.GPADIR.all     &= GPADIR_REG_MASK_VALUE;
    GpioCtrlRegs.GPADIR.all     |= GPADIR_REG_VALUE;
}
#endif

#if( CFG_PORTB )
static void gpiobcfg( void )
{

}
#endif

#if( CFG_PORTC )
static void gpioccfg( void )
{

}
#endif

#if( CFG_PORTD )
static void gpiodcfg( void )
{

}
#endif

#if( CFG_PORTE )
static void gpioecfg( void )
{

}
#endif

#if( CFG_PORTF )
static void gpiofcfg( void )
{

}
#endif


void gpiocfg( void )
{
    EALLOW;
#if( CFG_PORTA )
    gpioacfg();
#endif
#if( CFG_PORTB )
    gpiobcfg();
#endif
#if( CFG_PORTC )
    gpioccfg();
#endif
#if( CFG_PORTD )
    gpiodcfg();
#endif
#if( CFG_PORTE )
    gpioecfg();
#endif
#if( CFG_PORTF )
    gpiofcfg();
#endif
    EDIS;
}

#endif /* CFG_PORTs */
