/*
 * sysclkcfg.c
 */
#include "../../inc/F2837xS_device.h"
#include "../inc/sysclkcfg.h"

void sysclkcfg( void )
{
    int loopCounter;

    EALLOW;

    /*
     * 1. Select the reference clock source (OSCCLK) by writing to
     *    CLKSRCCTL1.OSCCLKSRCSEL. See page 100 of the TMS320F2837xS Delfino
     *    Micro-controllers Reference Manual.
     */
    ClkCfgRegs.CLKSRCCTL1.all = CLKSRCCTL1_REG_VALUE;

    /*
     * 2. Set up the system PLL
     * (a) Bypass the PLL by clearing SYSPLLCTL1[PLLCLKEN]
     */
    ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 0;
    asm(" RPT #20 || NOP");

    /*
     * (b) Set the system clock divider to /1 to ensure the fastest PLL
     *     configuration by clearing SYSCLKDIVSEL[ PLLSYSCLKDIV]
     */
    ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 0;

    /*
     * (c) Set the integral and fractional multipliers by simultaneously
     *     writing them both to SYSPLLMULT. This will automatically enable the
     *     PLL.
     */
    //ClkCfgRegs.SYSPLLMULT.all = SYSPLLMULT_REG_VALUE;

    /*
     * (d) Lock the PLL five times.
     */
    for( loopCounter = 0; loopCounter < 5; loopCounter++ )
    {
        /*
         * Turn off PLL
         */
        ClkCfgRegs.SYSPLLCTL1.bit.PLLEN = 0;
        asm(" RPT #20 || NOP");

        /*
         * Write multiplier, which automatically turns on the PLL
         */
        ClkCfgRegs.SYSPLLMULT.all = SYSPLLMULT_REG_VALUE;

        /*
         * Wait for the SYSPLL lock counter
         */
        while( ClkCfgRegs.SYSPLLSTS.bit.LOCKS != 1 )
        {
            /*
             * Uncomment to service the watchdog
             */
            // ServiceDog();
        }
    }

    /*
     * (e) Set the system clock divider one setting higher than the final
     *     desired value. For example ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV
     *     = divsel + 1. This limits the current increase when switching to the
     *     PLL.
     */
    ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = ( ( union SYSCLKDIVSEL_REG )( SYSCLKDIVSEL_REG_VALUE ) ).bit.PLLSYSCLKDIV + 1;

    /*
     * (f) Set up the watchdog to reset the device. Note that the
     *     SCRS[WDOVERRIDE] bit should not be cleared prior to locking the PLL.
     */
    WdRegs.WDWCR.all        = 0x0;
    WdRegs.WDKEY.bit.WDKEY  = 0x55;
    WdRegs.WDKEY.bit.WDKEY  = 0xAA;

    /*
     * Configure for watchdog reset and to run at max frequency
     */
    WdRegs.SCSR.all = 0x0;
    WdRegs.WDCR.all = WDCR_WDCHK;

    /*
     * (g) Set the SYSDBGCTL[BIT_0] bit. This bit is only reset by a POR reset.
     *     If the watchdog has to reset the device due to an issue with
     *     switching to the PLL, this bit can be checked in the reset handler
     *     to determine the reset was caused by a PLL error.
     */
    DevCfgRegs.SYSDBGCTL.bit.BIT_0 = 1;

    /*
     * (h) Switch to the PLL as the system clock by setting
     *     SYSPLLCTL1[PLLCLKEN].
     */
    ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 1;

    /*
     * Delay to ensure system is clocking from PLL prior to clearing status bit
     */
    asm(" RPT #20 || NOP");

    /*
     * (i) Clear the SYSDBGCTL[BIT_0] bit.
     */
    DevCfgRegs.SYSDBGCTL.bit.BIT_0 = 0;

    /*
     * Disable the watch-dog timer
     */
    WdRegs.WDKEY.bit.WDKEY = 0x55;
    WdRegs.WDKEY.bit.WDKEY = 0xAA;
    WdRegs.WDCR.all = ( WDCR_WDDIS | WDCR_WDCHK );

    /*
     * 200 PLLSYSCLK delay to allow voltage regulator to stabilize prior
     * to increasing entire system clock frequency.
     */
    asm(" RPT #200 || NOP");

    /*
     * (j) Change the divider to the appropriate value.
     */
    ClkCfgRegs.SYSCLKDIVSEL.all = SYSCLKDIVSEL_REG_VALUE;

    EDIS;
}
