//###########################################################################
//
// FILE:    F2837xS_cla.h
//
// TITLE:   F2837xS Device CLA Register Definitions.
//
//###########################################################################
// $TI Release: F2837xS Support Library v210 $
// $Release Date: Tue Nov  1 15:35:23 CDT 2016 $
// $Copyright: Copyright (C) 2014-2016 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

#ifndef __F2837xS_CLA_H__
#define __F2837xS_CLA_H__

#ifdef __cplusplus
extern "C" {
#endif


/*
 * MCTL Register
 */
#define CLA_FORCE_RESET           ( 0x1 )
#define CLA_IACK_ENABLE           ( 0x1 )
#define CLA_IACK_DISABLE          ( 0x0 )

/*
 * MMEMCFG Register
 */
#define CLA_CLA_SPACE             ( 0x1 )
#define CLA_CPU_SPACE             ( 0x0 )

/*
 * MIER Interrupt Enable Register
 */
#define CLA_INT_ENABLE            ( 0x1 )
#define CLA_INT_DISABLE           ( 0x0 )

/*
 * Peripheral Interrupt Source Select define for DMAnCLASourceSelect Register
 */
#define CLA_TRIG_NOPERPH         ( 0  )
#define CLA_TRIG_ADCAINT1        ( 1  )
#define CLA_TRIG_ADCAINT2        ( 2  )
#define CLA_TRIG_ADCAINT3        ( 3  )
#define CLA_TRIG_ADCAINT4        ( 4  )
#define CLA_TRIG_ADCAEVT         ( 5  )
#define CLA_TRIG_ADCBINT1        ( 6  )
#define CLA_TRIG_ADCBINT2        ( 7  )
#define CLA_TRIG_ADCBINT3        ( 8  )
#define CLA_TRIG_ADCBINT4        ( 9  )
#define CLA_TRIG_ADCBEVT         ( 10 )
#define CLA_TRIG_ADCCINT1        ( 11 )
#define CLA_TRIG_ADCCINT2        ( 12 )
#define CLA_TRIG_ADCCINT3        ( 13 )
#define CLA_TRIG_ADCCINT4        ( 14 )
#define CLA_TRIG_ADCCEVT         ( 15 )
#define CLA_TRIG_ADCDINT1        ( 16 )
#define CLA_TRIG_ADCDINT2        ( 17 )
#define CLA_TRIG_ADCDINT3        ( 18 )
#define CLA_TRIG_ADCDINT4        ( 19 )
#define CLA_TRIG_ADCDEVT         ( 20 )

#define CLA_TRIG_XINT1           ( 29 )
#define CLA_TRIG_XINT2           ( 30 )
#define CLA_TRIG_XINT3           ( 31 )
#define CLA_TRIG_XINT4           ( 32 )
#define CLA_TRIG_XINT5           ( 33 )

#define CLA_TRIG_EPWM1INT        ( 36 )
#define CLA_TRIG_EPWM2INT        ( 37 )
#define CLA_TRIG_EPWM3INT        ( 38 )
#define CLA_TRIG_EPWM4INT        ( 39 )
#define CLA_TRIG_EPWM5INT        ( 40 )
#define CLA_TRIG_EPWM6INT        ( 41 )
#define CLA_TRIG_EPWM7INT        ( 42 )
#define CLA_TRIG_EPWM8INT        ( 43 )
#define CLA_TRIG_EPWM9INT        ( 44 )
#define CLA_TRIG_EPWM10INT       ( 45 )
#define CLA_TRIG_EPWM11INT       ( 46 )
#define CLA_TRIG_EPWM12INT       ( 47 )

#define CLA_TRIG_TINT0           ( 68 )
#define CLA_TRIG_TINT1           ( 69 )
#define CLA_TRIG_TINT2           ( 70 )

#define CLA_TRIG_MXEVTA          ( 71 )
#define CLA_TRIG_MREVTA          ( 72 )
#define CLA_TRIG_MXEVTB          ( 73 )
#define CLA_TRIG_MREVTB          ( 74 )

#define CLA_TRIG_ECAP1INT        ( 75 )
#define CLA_TRIG_ECAP2INT        ( 76 )
#define CLA_TRIG_ECAP3INT        ( 77 )
#define CLA_TRIG_ECAP4INT        ( 78 )
#define CLA_TRIG_ECAP5INT        ( 79 )
#define CLA_TRIG_ECAP6INT        ( 80 )

#define CLA_TRIG_EQEP1INT        ( 83 )
#define CLA_TRIG_EQEP2INT        ( 84 )
#define CLA_TRIG_EQEP3INT        ( 85 )

#define CLA_TRIG_HRCAP1INT       ( 87 )
#define CLA_TRIG_HRCAP2INT       ( 88 )

#define CLA_TRIG_SD1INT          ( 95 )
#define CLA_TRIG_SD2INT          ( 96 )

#define CLA_TRIG_UPP1_INT       ( 107 )

#define CLA_TRIG_SPITXINTA      ( 109 )
#define CLA_TRIG_SPIRXINTA      ( 110 )
#define CLA_TRIG_SPITXINTB      ( 111 )
#define CLA_TRIG_SPIRXINTB      ( 112 )
#define CLA_TRIG_SPITXINTC      ( 113 )
#define CLA_TRIG_SPIRXINTC      ( 114 )

#define Cla1ForceTask1andWait()asm("  IACK  #0x0001");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT1 == 1);

#define Cla1ForceTask2andWait()asm("  IACK  #0x0002");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT2 == 1);

#define Cla1ForceTask3andWait()asm("  IACK  #0x0004");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT3 == 1);

#define Cla1ForceTask4andWait()asm("  IACK  #0x0008");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT4 == 1);

#define Cla1ForceTask5andWait()asm("  IACK  #0x0010");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT5 == 1);

#define Cla1ForceTask6andWait()asm("  IACK  #0x0020");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT6 == 1);

#define Cla1ForceTask7andWait()asm("  IACK  #0x0040");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT7 == 1);

#define Cla1ForceTask8andWait()asm("  IACK  #0x0080");             \
                               asm("  RPT #3 || NOP");             \
                                while(Cla1Regs.MIRUN.bit.INT8 == 1);

#define Cla1ForceTask1()       asm("  IACK  #0x0001")
#define Cla1ForceTask2()       asm("  IACK  #0x0002")
#define Cla1ForceTask3()       asm("  IACK  #0x0004")
#define Cla1ForceTask4()       asm("  IACK  #0x0008")
#define Cla1ForceTask5()       asm("  IACK  #0x0010")
#define Cla1ForceTask6()       asm("  IACK  #0x0020")
#define Cla1ForceTask7()       asm("  IACK  #0x0040")
#define Cla1ForceTask8()       asm("  IACK  #0x0080")

//---------------------------------------------------------------------------
// CLA Individual Register Bit Definitions:

struct MCTL_BITS {                      // bits description
    Uint16 HARDRESET:1;                 // 0 Hard Reset
    Uint16 SOFTRESET:1;                 // 1 Soft Reset
    Uint16 IACKE:1;                     // 2 IACK enable
    Uint16 rsvd1:13;                    // 15:3 Reserved
};

union MCTL_REG {
    Uint16  all;
    struct  MCTL_BITS  bit;
};

struct MIFR_BITS {                      // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Flag
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Flag
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Flag
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Flag
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Flag
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Flag
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Flag
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Flag
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MIFR_REG {
    Uint16  all;
    struct  MIFR_BITS  bit;
};

struct MIOVF_BITS {                     // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Overflow Flag
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Overflow Flag
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Overflow Flag
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Overflow Flag
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Overflow Flag
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Overflow Flag
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Overflow Flag
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Overflow Flag
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MIOVF_REG {
    Uint16  all;
    struct  MIOVF_BITS  bit;
};

struct MIFRC_BITS {                     // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Force
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Force
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Force
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Force
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Force
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Force
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Force
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Force
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MIFRC_REG {
    Uint16  all;
    struct  MIFRC_BITS  bit;
};

struct MICLR_BITS {                     // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Flag Clear
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Flag Clear
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Flag Clear
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Flag Clear
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Flag Clear
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Flag Clear
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Flag Clear
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Flag Clear
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MICLR_REG {
    Uint16  all;
    struct  MICLR_BITS  bit;
};

struct MICLROVF_BITS {                  // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Overflow Flag Clear
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Overflow Flag Clear
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Overflow Flag Clear
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Overflow Flag Clear
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Overflow Flag Clear
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Overflow Flag Clear
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Overflow Flag Clear
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Overflow Flag Clear
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MICLROVF_REG {
    Uint16  all;
    struct  MICLROVF_BITS  bit;
};

struct MIER_BITS {                      // bits description
    Uint16 INT1:1;                      // 0 Task 1 Interrupt Enable
    Uint16 INT2:1;                      // 1 Task 2 Interrupt Enable
    Uint16 INT3:1;                      // 2 Task 3 Interrupt Enable
    Uint16 INT4:1;                      // 3 Task 4 Interrupt Enable
    Uint16 INT5:1;                      // 4 Task 5 Interrupt Enable
    Uint16 INT6:1;                      // 5 Task 6 Interrupt Enable
    Uint16 INT7:1;                      // 6 Task 7 Interrupt Enable
    Uint16 INT8:1;                      // 7 Task 8 Interrupt Enable
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MIER_REG {
    Uint16  all;
    struct  MIER_BITS  bit;
};

struct MIRUN_BITS {                     // bits description
    Uint16 INT1:1;                      // 0 Task 1 Run Status
    Uint16 INT2:1;                      // 1 Task 2 Run Status
    Uint16 INT3:1;                      // 2 Task 3 Run Status
    Uint16 INT4:1;                      // 3 Task 4 Run Status
    Uint16 INT5:1;                      // 4 Task 5 Run Status
    Uint16 INT6:1;                      // 5 Task 6 Run Status
    Uint16 INT7:1;                      // 6 Task 7 Run Status
    Uint16 INT8:1;                      // 7 Task 8 Run Status
    Uint16 rsvd1:8;                     // 15:8 Reserved
};

union MIRUN_REG {
    Uint16  all;
    struct  MIRUN_BITS  bit;
};

struct _MSTF_BITS {                     // bits description
    Uint16 LVF:1;                       // 0 Latched Overflow Flag 
    Uint16 LUF:1;                       // 1 Latched Underflow Flag 
    Uint16 NF:1;                        // 2 Negative Float Flag 
    Uint16 ZF:1;                        // 3 Zero Float Flag
    Uint16 rsvd1:2;                     // 5:4 Reserved
    Uint16 TF:1;                        // 6 Test Flag 
    Uint16 rsvd2:2;                     // 8:7 Reserved
    Uint16 RNDF32:1;                    // 9 Round 32-bit Floating-Point Mode
    Uint16 rsvd3:1;                     // 10 Reserved
    Uint16 MEALLOW:1;                   // 11 MEALLOW Status
    Uint32 _RPC:16;                     // 27:12 Return PC
    Uint16 rsvd4:4;                     // 31:28 Reserved
};

union _MSTF_REG {
    Uint32  all;
    struct  _MSTF_BITS  bit;
};

union MR_REG {
    Uint32              i32;
    float               f32;
};

struct CLA_REGS {
    Uint16                                   MVECT1;                       // Task Interrupt Vector
    Uint16                                   MVECT2;                       // Task Interrupt Vector
    Uint16                                   MVECT3;                       // Task Interrupt Vector
    Uint16                                   MVECT4;                       // Task Interrupt Vector
    Uint16                                   MVECT5;                       // Task Interrupt Vector
    Uint16                                   MVECT6;                       // Task Interrupt Vector
    Uint16                                   MVECT7;                       // Task Interrupt Vector
    Uint16                                   MVECT8;                       // Task Interrupt Vector
    Uint16                                   rsvd1[8];                     // Reserved
    union   MCTL_REG                         MCTL;                         // Control Register
    Uint16                                   rsvd2[15];                    // Reserved
    union   MIFR_REG                         MIFR;                         // Interrupt Flag Register
    union   MIOVF_REG                        MIOVF;                        // Interrupt Overflow Flag Register
    union   MIFRC_REG                        MIFRC;                        // Interrupt Force Register
    union   MICLR_REG                        MICLR;                        // Interrupt Flag Clear Register
    union   MICLROVF_REG                     MICLROVF;                     // Interrupt Overflow Flag Clear Register
    union   MIER_REG                         MIER;                         // Interrupt Enable Register
    union   MIRUN_REG                        MIRUN;                        // Interrupt Run Status Register
    Uint16                                   rsvd3;                        // Reserved
    Uint16                                   _MPC;                         // CLA Program Counter
    Uint16                                   rsvd4;                        // Reserved
    Uint16                                   _MAR0;                        // CLA Auxiliary Register 0
    Uint16                                   _MAR1;                        // CLA Auxiliary Register 1
    Uint16                                   rsvd5[2];                     // Reserved
    union   _MSTF_REG                        _MSTF;                        // CLA Floating-Point Status Register
    union   MR_REG                           _MR0;                         // CLA Floating-Point Result Register 0
    Uint16                                   rsvd6[2];                     // Reserved
    union   MR_REG                           _MR1;                         // CLA Floating-Point Result Register 1
    Uint16                                   rsvd7[2];                     // Reserved
    union   MR_REG                           _MR2;                         // CLA Floating-Point Result Register 2
    Uint16                                   rsvd8[2];                     // Reserved
    union   MR_REG                           _MR3;                         // CLA Floating-Point Result Register 3
};

struct SOFTINTEN_BITS {                 // bits description
    Uint16 TASK1:1;                     // 0 Task 1 Software Interrupt Enable
    Uint16 TASK2:1;                     // 1 Task 2 Software Interrupt Enable
    Uint16 TASK3:1;                     // 2 Task 3 Software Interrupt Enable
    Uint16 TASK4:1;                     // 3 Task 4 Software Interrupt Enable
    Uint16 TASK5:1;                     // 4 Task 5 Software Interrupt Enable
    Uint16 TASK6:1;                     // 5 Task 6 Software Interrupt Enable
    Uint16 TASK7:1;                     // 6 Task 7 Software Interrupt Enable
    Uint16 TASK8:1;                     // 7 Task 8 Software Interrupt Enable
    Uint16 rsvd1:8;                     // 15:8 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union SOFTINTEN_REG {
    Uint32  all;
    struct  SOFTINTEN_BITS  bit;
};

struct SOFTINTFRC_BITS {                // bits description
    Uint16 TASK1:1;                     // 0 Task 1 Software Interrupt Force
    Uint16 TASK2:1;                     // 1 Task 2 Software Interrupt Force
    Uint16 TASK3:1;                     // 2 Task 3 Software Interrupt Force
    Uint16 TASK4:1;                     // 3 Task 4 Software Interrupt Force
    Uint16 TASK5:1;                     // 4 Task 5 Software Interrupt Force
    Uint16 TASK6:1;                     // 5 Task 6 Software Interrupt Force
    Uint16 TASK7:1;                     // 6 Task 7 Software Interrupt Force
    Uint16 TASK8:1;                     // 7 Task 8 Software Interrupt Force
    Uint16 rsvd1:8;                     // 15:8 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union SOFTINTFRC_REG {
    Uint32  all;
    struct  SOFTINTFRC_BITS  bit;
};

struct CLA_SOFTINT_REGS {
    union   SOFTINTEN_REG                    SOFTINTEN;                    // CLA Software Interrupt Enable Register
    union   SOFTINTFRC_REG                   SOFTINTFRC;                   // CLA Software Interrupt Force Register
};

//---------------------------------------------------------------------------
// CLA External References & Function Declarations:
//
extern volatile struct CLA_SOFTINT_REGS Cla1SoftIntRegs;
extern volatile struct CLA_REGS Cla1Regs;

#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif

//===========================================================================
// End of file.
//===========================================================================
