/*
 * F2837xS_flash.c
 */

#include "../inc/F2837xS_device.h"

#pragma CODE_SECTION(flashctl_bank0_init, ramFuncSection);
void flashctl_bank0_init( void )
{
    EALLOW;

   /*
    * Set VREADST to the proper value for the flash banks to power up
    * properly. This sets the bank power up delay.
    */
   Flash0CtrlRegs.FBAC.bit.VREADST = 0x14;

   /*
    * At reset bank and pump are in sleep. A Flash access will power up the
    * bank and pump automatically.
    *
    * After a Flash access, bank and pump go to low power mode (configurable
    * in FBFALLBACK/FPAC1 registers) if there is no further access to flash.
    *
    * Power up Flash bank and pump. This also sets the fall back mode of
    * flash and pump as active.
    */
   Flash0CtrlRegs.FPAC1.bit.PMPPWR = 0x1;
   Flash0CtrlRegs.FBFALLBACK.bit.BNKPWR0 = 0x3;

   /*
    * Disable Cache and prefetch mechanism before changing wait states
    */
   Flash0CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 0;
   Flash0CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 0;

   /*
    * Set waitstates according to frequency
    *
    *      *CAUTION*
    * Minimum waitstates required for the flash operating at a given CPU rate
    * must be characterized by TI. Refer to the datasheet for the latest
    * information.
    */
   Flash0CtrlRegs.FRDCNTL.bit.RWAIT = 0x3;

   /*
    * Enable Cache and prefetch mechanism to improve performance of code
    * executed from Flash.
    */
   Flash0CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 1;
   Flash0CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 1;

   /*
    * At reset, ECC is enabled. If it is disabled by application software and
    * if application again wants to enable ECC.
    */
   Flash0EccRegs.ECC_ENABLE.bit.ENABLE = 0xA;

   EDIS;

   /*
    * Force a pipeline flush to ensure that the write to the last register
    * configured occurs before returning.
    */
   __asm(" RPT #7 || NOP");
}


#pragma CODE_SECTION(flashctl_bank1_init, ramFuncSection);
void flashctl_bank1_init( void )
{
    EALLOW;

    /*
     * Set VREADST to the proper value for the flash banks to power up
     * properly. This sets the bank power up delay.
     */
    Flash1CtrlRegs.FBAC.bit.VREADST = 0x14;

    /*
     * At reset bank and pump are in sleep. A Flash access will power up the
     * bank and pump automatically.
     *
     * After a Flash access, bank and pump go to low power mode (configurable
     * in FBFALLBACK/FPAC1 registers) if there is no further access to flash.
     *
     * Power up Flash bank and pump. This also sets the fall back mode of
     * flash and pump as active.
     */
    Flash1CtrlRegs.FPAC1.bit.PMPPWR = 0x1;
    Flash1CtrlRegs.FBFALLBACK.bit.BNKPWR0 = 0x3;

    /*
     * Disable Cache and prefetch mechanism before changing wait states
     */
    Flash1CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 0;
    Flash1CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 0;

    /*
     * Set waitstates according to frequency
     *
     *      *CAUTION*
     * Minimum waitstates required for the flash operating at a given CPU rate
     * must be characterized by TI. Refer to the datasheet for the latest
     * information.
     */
    Flash1CtrlRegs.FRDCNTL.bit.RWAIT = 0x3;

    /*
     * Enable Cache and prefetch mechanism to improve performance of code
     * executed from Flash.
     */
    Flash1CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 1;
    Flash1CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 1;

    /*
     * At reset, ECC is enabled. If it is disabled by application software and
     * if application again wants to enable ECC.
     */
    Flash1EccRegs.ECC_ENABLE.bit.ENABLE = 0xA;

    EDIS;

    /*
     * Force a pipeline flush to ensure that the write to the last register
     * configured occurs before returning.
     */
    __asm(" RPT #7 || NOP");
}


#pragma CODE_SECTION( flashinit, ramFuncSection );
void flashinit( void )
{
    flashctl_bank0_init();

    flashctl_bank1_init();
}

