/*
 * F2837xS_pievect.c
 */

#include "../inc/F2837xS_device.h"

/*
 * PIE_RESERVED_ISR - Reserved ISR
 */
interrupt void PIE_RESERVED_ISR( void )
{
    asm ("      ESTOP0");
    for(;;);
}


static void pievecttableinit( void )
{
    uint16_t intNum;
    uint32_t *Dest  = ( ( uint32_t* )( &PieVectTable ) );

    /*
     * Do not write over first 3 32-bit locations (these locations are
     * initialized by Boot ROM with boot variables)
     */
    Dest = Dest + 3;

    for( intNum = 0; intNum < 221; intNum++)
    {
        *Dest++ = ( ( uint32_t )( PIE_RESERVED_ISR ) );
    }
}


void pievectinit( void )
{
    EALLOW;
   // Disable the PIE
   PieCtrlRegs.PIECTRL.bit.ENPIE = 0;

   // Clear all PIEIER registers:
   PieCtrlRegs.PIEIER1.all = 0;
   PieCtrlRegs.PIEIER2.all = 0;
   PieCtrlRegs.PIEIER3.all = 0;
   PieCtrlRegs.PIEIER4.all = 0;
   PieCtrlRegs.PIEIER5.all = 0;
   PieCtrlRegs.PIEIER6.all = 0;
   PieCtrlRegs.PIEIER7.all = 0;
   PieCtrlRegs.PIEIER8.all = 0;
   PieCtrlRegs.PIEIER9.all = 0;
   PieCtrlRegs.PIEIER10.all = 0;
   PieCtrlRegs.PIEIER11.all = 0;
   PieCtrlRegs.PIEIER12.all = 0;

   // Clear all PIEIFR registers:
   PieCtrlRegs.PIEIFR1.all = 0;
   PieCtrlRegs.PIEIFR2.all = 0;
   PieCtrlRegs.PIEIFR3.all = 0;
   PieCtrlRegs.PIEIFR4.all = 0;
   PieCtrlRegs.PIEIFR5.all = 0;
   PieCtrlRegs.PIEIFR6.all = 0;
   PieCtrlRegs.PIEIFR7.all = 0;
   PieCtrlRegs.PIEIFR8.all = 0;
   PieCtrlRegs.PIEIFR9.all = 0;
   PieCtrlRegs.PIEIFR10.all = 0;
   PieCtrlRegs.PIEIFR11.all = 0;
   PieCtrlRegs.PIEIFR12.all = 0;

   pievecttableinit();

   PieCtrlRegs.PIECTRL.bit.ENPIE   = 1;
   PieCtrlRegs.PIEACK.all          = 0xFFFF;

   EDIS;
}
