/*
 * psp.c
 */

#include <stdlib.h>
#include <string.h>

#include "../inc/F2837xS_device.h"
#include "../cfg/inc/pspcfg.h"

extern unsigned long RamfuncsLoadStart;
extern unsigned long RamfuncsRunStart;
extern unsigned long RamfuncsLoadSize;

void pspinit( void )
{
    EALLOW;

    // Disable the watchdog
    WdRegs.WDCR.all = ( WDCR_WDDIS | WDCR_WDCHK );
    EDIS;

    /*
     * Copy time critical code and Flash setup code to RAM. This includes the
     * following functions: InitFlash()
     *
     * The  RamfuncsLoadStart, RamfuncsLoadSize, and RamfuncsRunStart
     * symbols are created by the linker. Refer to the device .cmd file.
     */
    memcpy(  ( ( void* )( &RamfuncsRunStart   ) ),
             ( ( void* )( &RamfuncsLoadStart  ) ),
             ( ( size_t )( &RamfuncsLoadSize  ) )  );

    flashinit();

    EALLOW;
    /*
     * Enable pull-ups on unbonded IOs as soon as possible to reduce power
     * consumption.
     */
    //GPIO_EnableUnbondedIOPullups();

    CpuSysRegs.PCLKCR13.bit.ADC_A = 1;
    CpuSysRegs.PCLKCR13.bit.ADC_B = 1;
    CpuSysRegs.PCLKCR13.bit.ADC_C = 1;
    CpuSysRegs.PCLKCR13.bit.ADC_D = 1;

    /*
     *  Check if device is trimmed
     */
    if(*( ( uint16_t* )( 0x5D1B6 ) ) == 0x0000 )
    {
        // Device is not trimmed--apply static calibration values
        AnalogSubsysRegs.ANAREFTRIMA.all = 31709;
        AnalogSubsysRegs.ANAREFTRIMB.all = 31709;
        AnalogSubsysRegs.ANAREFTRIMC.all = 31709;
        AnalogSubsysRegs.ANAREFTRIMD.all = 31709;
    }

    CpuSysRegs.PCLKCR13.bit.ADC_A = 0;
    CpuSysRegs.PCLKCR13.bit.ADC_B = 0;
    CpuSysRegs.PCLKCR13.bit.ADC_C = 0;
    CpuSysRegs.PCLKCR13.bit.ADC_D = 0;

    /*
     * Disable CPU interrupts and clear all CPU interrupt flags:
     */
    DINT;

    /*
     * 0x0000 (INT1 to INT14, DLOGINT, RTOSINT disabled)
     */
    IER = 0x0000;
    IFR = 0x0000;

    EDIS;

    pspcfg();
}
