#ifndef _CLA_MATRIX_MPY_SHARED_H_
#define _CLA_MATRIX_MPY_SHARED_H_
//#############################################################################
// FILE:   cla_matrix_mpy_shared.h
// TITLE:  Matrix Multiplication Test
//
//  Group: 			C2000
//  Target Family:	F2837x
//
// (C)Copyright 2013, Texas Instruments, Inc.
//#############################################################################
//$TI Release: F2837xD Support Library v100 $
//$Release Date: Mon Dec  9 12:58:09 CST 2013 $
//#############################################################################

//*****************************************************************************
// includes
//*****************************************************************************
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

//*****************************************************************************
// defines
//*****************************************************************************

//*****************************************************************************
// typedefs
//*****************************************************************************


//*****************************************************************************
// globals
//*****************************************************************************


//Task 1 (C) Variables
extern uint16_t num, den, rem, quo;

//Task 2 (C) Variables

//Task 3 (C) Variables

//Task 4 (C) Variables

//Task 5 (C) Variables

//Task 6 (C) Variables

//Task 7 (C) Variables

//Task 8 (C) Variables

//Common (C) Variables

//*****************************************************************************
// function prototypes
//*****************************************************************************
// The following are symbols defined in the CLA assembly code
// Including them in the shared header file makes them
// .global and the main CPU can make use of them.

//CLA C Tasks
__interrupt void Cla1Task1();
__interrupt void Cla1Task2();
__interrupt void Cla1Task3();
__interrupt void Cla1Task4();
__interrupt void Cla1Task5();
__interrupt void Cla1Task6();
__interrupt void Cla1Task7();
__interrupt void Cla1Task8();


//! \brief Unsigned Integer (16-bits) modulus
//! \param[in] num : 16-bit unsigned numerator
//! \param[in] den : 16-bit unsigned denominator
//! \return 32-bit unsigned int, MSW is the remainder, LSW is the quotient
//
uint32_t cla_unsigned_mod(uint16_t num, uint16_t den);

#ifdef __cplusplus
}
#endif // extern "C"

#endif //end of _CLA_MATRIX_MPY_SHARED_H_ definition
