;;#############################################################################
;; \file cla_unsigned_modulus.asm
;;
;; \brief  Unsigned Modulus
;; \date   Jan 22, 2015
;; \author Vishal Coelho
;;
;; Group: 			C2000
;; Target Family:	F2837x
;;
;;(C)Copyright 2015, Texas Instruments, Inc.
;;#############################################################################
;;$TI Release: F2837xD Support Library v110 $
;;$Release Date: Mon Apr  7 10:35:37 CDT 2014 $
;;#############################################################################

;;*****************************************************************************
;; includes
;;*****************************************************************************

;;*****************************************************************************
;; defines
;;*****************************************************************************
;// To include an MDEBUGSTOP (CLA breakpoint) as the first instruction
;// of each task, set CLA_DEBUG to 1.  Use any other value to leave out
;// the MDEBUGSTOP instruction.

CLA_DEBUG          .set  1

;;*****************************************************************************
;; function definitions
;;*****************************************************************************
;// CLA code must be within its own assembly section and must be
;// even aligned.  Note: since all CLA instructions are 32-bit
;// this alignment naturally occurs and the .align 2 is most likely
;// redundant

	.global		_cla_unsigned16_mod
	.sect	"Cla1Prog:_cla_unsigned16_mod"
	.align	 2
__cla_unsigned_mod_sp	.usect	".scratchpad:Cla1Prog:_cla_unsigned16_mod",2,0,1
;***************************************************************
;* FNAME: _cla_unsigned_mod             FR SIZE:   2           *
;*                                                             *
;* FUNCTION ENVIRONMENT                                        *
;*                                                             *
;* FUNCTION PROPERTIES                                         *
;*                                          2 Auto,  1 SOE     *
;***************************************************************
_cla_unsigned16_mod:
	.if			CLA_DEBUG == 1
	MDEBUGSTOP
	MNOP
	MNOP
	MNOP
	.endif
	MMOV32		@__cla_unsigned_mod_sp + 0, MR3
	MMOVIZ		MR3, #0
	MMOVXI		MR3, #1							; MR3 = 1
	MLSL32		MR1, #16						; den = den << 16
	; the accumulator has the numerator on the first iteration
	.asg		0, N
	.loop
	MLSL32		MR0, #1							; acc <<= 1
	MSUB32		MR2, MR0, MR1					; temp = (acc << 1) - (den << 16) (set flag)
	MADD32		MR2, MR2, MR3					; temp += 1 (could change flag)
	MMOV32		MR0, MR2, GT					; if(temp >0) acc = temp+1
	                                            ; else        acc <<= 1
	.eval		N + 1, N
	.break		N == 16
	.endloop
	.unasg		N
	MRCNDD		UNCF
	MMOV32		MR3, @__cla_unsigned_mod_sp + 0
	MNOP
	MNOP

;; End of file
