//###########################################################################
//###########################################################################
// $TI Release: F2806x C/C++ Header Files and Peripheral Examples V150 $
// $Release Date: June 16, 2015 $
// $Copyright: Copyright (C) 2011-2015 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

#define xdc__strict
//#define xdc__nolocalnames
#include <xdc/std.h>
#include "DSP28x_Project.h"
#include <xdc/runtime/System.h>
#include <ti/sysbios/BIOS.h>
#include "C28x_FPU_FastRTS.h"
#include <ti/sysbios/knl/Clock.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/Log.h>
#define f 50.0
#define PI 3.14159265
#define GRID_FREQ 50.0
#define ISR_FREQUENCY 20000.0

#define PWM1_INT_ENABLE  1
//#define OPT1 GpioDataRegs.GPBDAT.bit.GPIO58
#define EPWM_TIMER_TBPRD   1129
#define EPWM_TIMER_TBPRDh 614



//__interrupt void epwm1_timer_isr(void);
//void InitEPwmTimer(void);
void InitEPWM(void);
typedef struct
{
	float Va;
	float Vb;
	float Vc;
}Voltage;
Voltage *V;
//ABC_DQ0_POS_F *Vp;
//ABC_DQ0_NEG_F *Vn;
//SPLL_3ph_DDSRF_F spll1;

//unsigned long EPwm1TimerIntCount;
void main(void)
{
	//gen_regs_bits.bit.io_read_inhibit = 0;
	//i = 0;
	//memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (Uint32)&RamfuncsLoadSize);
	InitFlash();
	//Factory_status.bit.phase_loss_bypass = 0;
    InitSysCtrl();						// Initialize the CPU

    InitPieCtrl();						// Initialize and enable the PIE
    InitPieVectTable();
	//InitWatchdog();						// Initialize the Watchdog Timer
	InitEPWM();							// Initialize the PWM
	InitCpuTimers();
//   ABC_DQ0_POS_F_init(Vp);
//   ABC_DQ0_NEG_F_init(Vn);
//   SPLL_3ph_DDSRF_F_init(GRID_FREQ,((float)(1.0/ISR_FREQUENCY)), (float)(0.00933678), (float)(-0.9813264),&spll1);
   //DINT;

  // InitPieCtrl();

  // IER = 0x0000;
 //  IFR = 0x0000;
   asm(" EALLOW");
   GpioCtrlRegs.GPBMUX2.bit.GPIO58 = 0;
   GpioCtrlRegs.GPBDIR.bit.GPIO58 = 1;			// OPT1
   asm(" EDIS");

//  OPT1 = 0;
//   asm(" EALLOW");
   //PieVectTable.EPWM1_INT = &epwm1_timer_isr;
//   asm(" EDIS");
   //InitEPwmTimer();
   //InitEPwm();
   //EPwm1TimerIntCount = 0;
  // IER |= M_INT3;
 //  PieCtrlRegs.PIEIER3.bit.INTx1 = PWM1_INT_ENABLE;
 //  EINT;   // Enable Global interrupt INTM
 //  ERTM;   // Enable Global realtime interrupt DBGM
   BIOS_start();
}

//void InitEPwmTimer()
//{

//   asm(" EALLOW");
 //  SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
//   asm(" EDIS");
 //  EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;
 //  EPwm1Regs.TBCTL.bit.PHSEN = TB_ENABLE;
 //  EPwm1Regs.TBPHS.half.TBPHS = 0;
 //  EPwm1Regs.TBPRD = PWM1_TIMER_TBPRD;
 //  EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;
//   EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;
//   EPwm1Regs.ETSEL.bit.INTEN = PWM1_INT_ENABLE;
 //  EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;
 //  asm(" EALLOW");
 //  SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
 //  asm(" EDIS");
//}
//__interrupt void epwm1_timer_isr(void)
//{

//}
/**********************************************************************
* Function: InitEPwm()
*
* Description: Initializes the Enhanced PWM modules on the F2806x.
**********************************************************************/
void InitEPWM(void)
{
//---------------------------------------------------------------------
//--- Must disable the clock to the ePWM modules if you
//--- want all ePWM modules synchronized.
//---------------------------------------------------------------------

	asm(" EALLOW");						// Enable EALLOW protected register access
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
	asm(" EDIS");						// Disable EALLOW protected register access
// Setup TBCLK
// Configure EPWM1
   EPwm1Regs.TBPRD = EPWM_TIMER_TBPRD;           // Set timer period 801 TBCLKs
   EPwm1Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm1Regs.TBCTR = 0x0000;                      // Clear counter

   // Set Compare values
   EPwm1Regs.CMPA.half.CMPA = EPWM_TIMER_TBPRDh;     // Set compare A value
   EPwm1Regs.CMPB = EPWM_TIMER_TBPRDh;               // Set Compare B value

   // Setup counter mode
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading ** master module , disable sync
   EPwm1Regs.TBCTL.bit.PRDLD = TB_SHADOW;         // Load period value through shadow register
   EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT** 80 MHZ clock input
   EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;		  // TB_DIV1 = 0
   EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_CTR_ZERO; 	  // **synch output at ctr = 0
   // Setup shadowing
   EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;	  // ***for all explanations: ref to fig 2-28 page 52 SPRU791E
   EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on Zero
   EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;


   // Set actions
   EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on event A, up count
   EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;           // Clear PWM1A on event A, down count
   EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;

   // dead time settings
   EPwm1Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;	//dead time disabled
   EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;	// active high complementary
   EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;		// channel A is the source for both rising and falling edge delays


   // Interrupt where we will change the Compare Values
   EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;      // Select INT on Zero event
   EPwm1Regs.ETSEL.bit.INTEN = 0;                 // disble INT
   EALLOW;
   EPwm1Regs.TZSEL.bit.OSHT1 = 1;				// ****configure trip input in one shot mode


   // Force o/ps low on trip
    EPwm1Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
    EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

   // Enable TZ interrupt

    EDIS;
   // Configure EPWM2
   EPwm2Regs.TBPRD = EPWM_TIMER_TBPRD;           // Set timer period 801 TBCLKs
   EPwm2Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm2Regs.TBCTR = 0x0000;                      // Clear counter

   // Set Compare values
   EPwm2Regs.CMPA.half.CMPA = EPWM_TIMER_TBPRDh;     // Set compare A value
   EPwm2Regs.CMPB = EPWM_TIMER_TBPRDh;               // Set Compare B value

   // Setup counter mode
   //EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // this done on run command
   EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;        // ** enable phase loading
   EPwm2Regs.TBCTL.bit.PRDLD = TB_SHADOW;         // ***load period value through shadow register
   EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;
   EPwm2Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN; 	  // **sync o/p = EPWM1
   // Setup shadowing
   EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
   EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on Zero
   EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;


   // Set actions

   EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on event A, up count
   EPwm2Regs.AQCTLA.bit.CAD = AQ_CLEAR;           // Clear PWM1A on event A, down count
   EPwm2Regs.AQCTLA.bit.ZRO = AQ_CLEAR;

  // dead time settings
   EPwm2Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;	 //Dead time disabled;
   EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
   EPwm2Regs.DBCTL.bit.IN_MODE = DBA_ALL;

   // Interrupt where we will change the Compare Values
   	EPwm2Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
   	EPwm2Regs.ETSEL.bit.INTEN = 0;                // disable INT
   	EALLOW;
	EPwm2Regs.TZSEL.bit.OSHT1 = 1;				// configure trip input in one shot mode


   // Force o/ps low on trip
    EPwm2Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
    EPwm2Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

   // Enable TZ interrupt
    EDIS;
    // configure EPWM3
   	EPwm3Regs.TBPRD = EPWM_TIMER_TBPRD;          // Set timer period
   	EPwm3Regs.TBPHS.half.TBPHS = 0x0000;          // Phase is 0
   	EPwm3Regs.TBCTR = 0x0000;                     // Clear counter
  // Set Compare values
   EPwm3Regs.CMPA.half.CMPA = EPWM_TIMER_TBPRDh;    // Set compare A value
   EPwm3Regs.CMPB = EPWM_TIMER_TBPRDh;              // Set Compare B value

 // Setup counter mode
   //EPwm3Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;// Count up/down
   EPwm3Regs.TBCTL.bit.PHSEN = TB_ENABLE;       // Enable phase loading
   EPwm3Regs.TBCTL.bit.PRDLD = TB_SHADOW;         // ***load period value through shadow register
   EPwm3Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;      // Clock ratio to SYSCLKOUT
   EPwm3Regs.TBCTL.bit.CLKDIV = TB_DIV1;
   EPwm3Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE; 	  // sync output disable*** sync o/p not for epwm4
   // Setup shadow register load on ZERO
   EPwm3Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
   EPwm3Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm3Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
   EPwm3Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;


   // Set actions
   EPwm3Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on event A, up count
   EPwm3Regs.AQCTLA.bit.CAD = AQ_CLEAR;           // Clear PWM1A on event A, down count
   EPwm3Regs.AQCTLA.bit.ZRO = AQ_CLEAR;


    // dead time settings
   EPwm3Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;	 //dead time disabled;
   EPwm3Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
   EPwm3Regs.DBCTL.bit.IN_MODE = DBA_ALL;

   // Interrupt where we will change the Compare Values
   EPwm3Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
   EPwm3Regs.ETSEL.bit.INTEN = 1;                // Enable INT
   //if((Switch_Freq < 5)||(control_status.bit.autotune == 1))EPwm3Regs.ETPS.bit.INTPRD = ET_1ST;     // Generate INT on 1st event for fsw upto 8Khz or if auto tune is enabled(fsw = 3Khz)
   //else EPwm3Regs.ETPS.bit.INTPRD = ET_2ND;// gen INT on 2nd event for 12 and 16Khz

	EPwm3Regs.ETPS.bit.INTPRD = ET_1ST;
	EALLOW;
	EPwm3Regs.TZSEL.bit.OSHT1 = 1;				// ***configure trip input in one shot mode

	   // Force o/ps low on trip
	    EPwm3Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
	    EPwm3Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

	   // Enable TZ interrupt
	EPwm3Regs.TZEINT.bit.OST = 1;

	EPwm3Regs.ETSEL.bit.SOCAEN = 1;        // **Enable SOC on A group
	EPwm3Regs.ETSEL.bit.SOCASEL = 2;       // **Select SOC on timer period
	EPwm3Regs.ETPS.bit.SOCAPRD = 1;        // **Generate pulse on 1st event

	// Enable interrupt in the PIE group 3 3
	PieCtrlRegs.PIEIER3.bit.INTx3 = 1;
	// Enable EPWM INTn in the PIE: Group 2 3
	PieCtrlRegs.PIEIER2.bit.INTx3 = 1;
	// Enable CPU INT3 which is connected to EPWM1-3 INT:
   IER |= M_INT3;
// Enable CPU INT2 which is connected to EPWM1-3 TRIP INT:
   IER |= M_INT2;
//---------------------------------------------------------------------
//--- Enable the clocks to the ePWM module.
//--- Note: this should be done after all ePWM modules are configured
//--- to ensure synchronization between the ePWM modules.
//---------------------------------------------------------------------
	asm(" EALLOW");							// Enable EALLOW protected register access
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;	// HSPCLK to ePWM modules enabled
	asm(" EDIS");							// Disable EALLOW protected register access
}


