
#ifndef SOURCE_CANCOMM_CANAPP_H_
#define SOURCE_CANCOMM_CANAPP_H_

/* header files ***************************************************************/
#include "driverlib.h"

/***********CAN message object  ID************/
//Tx message object ID
#define TX_MSG_OBJ_CHARGE_STATUS_NO1_ID         1u //ID (0x301)
#define TX_MSG_OBJ_CHARGE_STATUS_NO2_ID         2u //ID (0x302)
#define TX_MSG_OBJ_CHARGE_STATE_ALARM_ID        3u //ID (0x303)
#define TX_MSG_OBJ_FLASH_RESPONSE_ID            4u //ID (0x305)
#define TX_MSG_OBJ_CONFIGURATION_RESPONSE_ID    5u //ID (0x307)
#define TX_MSG_OBJ_CARB_OBD_SENSOR_ID           6u //ID (0x308)
#define TX_MSG_OBJ_CARB_OBD_RATIONALITY_ID      7u //ID (0x309)
#define TX_MSG_OBJ_SELFTEST_STATUS_ID           8u //ID (0x30A)
#define TX_MSG_OBJ_DEBUG1_ID                    9u //ID (0x30B)
#define TX_MSG_OBJ_DEBUG2_ID                    10u //ID (0x30C)
#define TX_MSG_OBJ_IND_BUS_INVPOWER_ID          11u //ID (0x30D)
#define TX_MSG_OBJ_DEBUG4_ID                    12u //ID (0x30E)

//Rx message object ID

#define RX_MSG_OBJ_CHARGE_CONTROL_ID            13u//ID (0x300)
#define RX_MSG_OBJ_FLASH_ID                     14u//ID (0x304)
#define RX_MSG_OBJ_DEBUG1_ID                    15u//ID (0x310)
#define RX_MSG_OBJ_DEBUG2_ID                    16u//ID (0x311)

#define MSG_DATA_LENGTH     8u
/***********CAN transmit message ID************/
#define ID_CHARGE_STATUS_NO1            (0x301u)
#define ID_CHARGE_STATUS_NO2            (0x302u)
#define ID_CHARGE_STATE_ALARM           (0x303u)
#define ID_FLASH_RESPONSE               (0x305u)
#define ID_CONFIGURATION_RESPONSE       (0x307u)
#define ID_CARB_OBD_SENSOR              (0x308u)
#define ID_CARB_OBD_RATIONALITY         (0x309u)
#define ID_SELFTEST_STATUS              (0x30Au)
#define ID_DEBUG1                       (0x30Bu)
#define ID_DEBUG2                       (0x30Cu)
#define ID_IND_BUS_INVPOWER             (0x30Du)
#define ID_DEBUG4                       (0x30Eu)
/***********CAN receive message ID************/
#define ID_CHARGE_CONTROL               (0x300u)
#define ID_FLASH                        (0x304u)
#define ID_OPENLOOP_DEBUG1              (0x310u)
#define ID_OPENLOOP_DEBUG2              (0x311u)

#define CAN_RD_MB (4u)
#define CAN_MSK_ID 0x3FFu

//Macro STREAM state
#define ECAN_MB_STREAM_INIT    (0)
#define ECAN_MB_STREAM_TXING   (1)
#define ECAN_MB_STREAM_FINISH  (2)

//Mcro ECAN_MB_STATE
#define ECAN_MB_INIT    (0)
#define ECAN_MB_TXING   (1)
#define ECAN_MB_TXED    (2)
#define ECAN_MB_MOTO    (3)
#define ECAN_MB_BUSY    (4)
#define ECAN_MB_RXED    (5)
//Macro ECAN_MB_RX_STATE
#define ECAN_RX_INIT    (0)
#define ECAN_RX_FULL    (1)
#define ECAN_RX_SUCCESS (2)
//Macro STREAM state
#define ECAN_MB_STREAM_INIT    (0)
#define ECAN_MB_STREAM_TXING   (1)
#define ECAN_MB_STREAM_FINISH  (2)

#define ECAN_MB_RX_NO_MAX      (3)
#define RXTIMEOUT_SET          (1000)
#define RX_PERIOD_CB           (10)
#define RXTIMEOUT              (RXTIMEOUT_SET / RX_PERIOD_CB)//40 * period call

//data push and pop
#define MBX_MAX_BITS                  (4)
#define MBX_MAX_BUFFER                (0x1 << MBX_MAX_BITS)
#define MBX_MAX_BUFFER_MASK           (MBX_MAX_BUFFER - 1)

#define  SETBIT_32b(value,index)    ((value) | (0x00000001UL << (index)))
#define  RESETBIT_32b(value,index)  ((value) & (~(0x00000001UL << (index))))

#define  SETBIT_16b(value,index)    ((value) | (0x0001 << (index)))
#define  RESETBIT_16b(value,index)  ((value) & (~(0x0001 << (index))))

typedef void (*P_FUNC)(void *p);//



//Ecan id Vs MailBox NUM
typedef enum
{
    ECAN_ID_IND_STATUS_1 = 0,
    ECAN_ID_IND_STATUS_2,
    ECAN_ID_IND_STATE_ALARM,
    ECAN_ID_IND_FLASH_RP,
    ECAN_ID_IND_CONFIG_RP,
    ECAN_ID_IND_OBD_SENSOR,
    ECAN_ID_IND_OBD_RATI,
    ECAN_ID_IND_SELF_TEST,
    ECAN_ID_IND_BUS_INVPOWER = 10,
    ECAN_ID_IND_CTRL = 12,
    ECAN_ID_IND_FLASH,
    ECAN_ID_IND_DEBUG1,
    ECAN_ID_IND_DEBUG2,
    ECAN_ID_IND_MAX
}Ecan_id_index;

//ECAN Mode state
typedef enum
{
    ECAN_UINT = 0,
    ECAN_CLOSE,
    ECAN_NORMAL,
    ECAN_EP,
    ECAN_MAX
}Ecan_State_Index;


//mailbox flag
typedef struct
{
    uint16_t bfMB_State         : 4;   //mailbox state: BUSY,TIMEOUT,NORMAL,TXING,TXED,TESET,AA
    uint16_t bfMB_MOTO_flag     : 1;   //mailbox is timeout,clear normal transmit data
    uint16_t bfMB_Enable        : 1;   //TX:1:enable   0:disable;RX none using
    uint16_t bfMB_Dir           : 1;   //0:transmit(default) 1:receive.
    uint16_t bfMB_MOTO_Enable   : 1;   //0:enable(default)   1:disable.
    uint16_t bfMB_timeover_falg : 1;   //mailbox receive time out flag
}MB_Flag_Set;

typedef union
{
    uint16_t      all;
    MB_Flag_Set   bits;
}MB_Flag_Ctrl;

//mailbox information
typedef struct
{
    uint8_t u8MB_ID;            //mailbox id
    uint8_t u8MB_DLC;           //transmit data length
    uint8_t u8Buf_W_Index;      //RAM block write index
    uint8_t u8Buf_R_Index;      //RAM block read index
    uint8_t u8Stream_state;     //mailbox stream state:application send data stream.this is a state
    uint8_t u8TimeOutConst;
    uint8_t u8TimeOutCnt;        //resend times cout;
    MB_Flag_Ctrl  MB_flags;         //mailbox flags
    //uint32_t        Moto_times;       //tx/rx time out value
    //uint32_t        Mots_times;       //time stamp value
    uint8_t *pu8msg;             //mailbox transmit or receive data
}MailBox_Msg;

//Global parameter
typedef struct
{
    uint8_t  u8APP_State;                //CAN BUS state
    uint32_t u32App_Ecan_sleep_cnt;      //sleep counter
    uint32_t u32App_Ecan_Tx_flag;        //Tx enable flag:0:enable write data and transmit 1:dos't transmit
    uint32_t u32App_Ecan_Error_flag;     //
    //MailboxRxInfor App_rx_ctrl;     //receive flag
    uint32_t u32App_Rx_Ready_flag;
    uint8_t  App_wakeup_flag;
}App_Ecan_DS;

extern MailBox_Msg  aApp_MB_Infor[ECAN_ID_IND_MAX];
extern P_FUNC  Ary_MB_Callback[CAN_RD_MB];


extern __interrupt void Can_Line0_ISR(void);
extern uint8_t CanApp_SetEcanState(uint8_t u8state);//set the state of CANBUS
extern void CanApp_SetRxReady(uint8_t u8length);
extern void CanApp_CanResetFunc(uint8_t u8mode);
extern void CanApp_CanIfReStart(void);
extern void CanApp_GetRxdata(P_FUNC *p_func);         //get receive data and operation
extern void CanApp_RxDataPush(void);
extern void CanApp_TxTp(void);                         //write transmit data on mailbox
extern uint8_t CanApp_TxApp(uint8_t u8id_index,uint8_t *pu8data,uint8_t u8length);
extern void CanApp_SetEcanStreamState(uint8_t u8id,uint8_t u8state);//set mailbox state



#endif /* SOURCE_CANCOMM_CANAPP_H_ */
