/* Define to prevent recursive inclusion **************************************/
#ifndef __TASK_H
#define __TASK_H

#ifdef __cplusplus
extern "C" {
#endif

/* header files ***************************************************************/

/* Global macro ***************************************************************/

/* Global types ***************************************************************/
// Low value indicate high priority task
typedef enum
{
	TASK_EVENT_CAN_RX = 0,
	TASK_EVENT_INV_ZERO,
	TASK_EVENT_LINE_ZERO,
	TASK_EVENT_CALC_CUR_LIMIT,
	TASK_EVENT_1MS_GROUP,
	TASK_EVENT_2MS_GROUP,
	TASK_EVENT_4MS_GROUP,
	TASK_EVENT_5MS_GROUP,
	TASK_EVENT_10MS_GROUP,
	TASK_EVENT_20MS_GROUP,
	TASK_EVENT_50MS_GROUP,
	TASK_EVENT_100MS_GROUP,
	TASK_EVENT_200MS_GROUP,
	TASK_EVENT_1000MS_GROUP,
	TASK_EVENT_TOTAL
} eventId_t;

typedef uint16_t eventType_t;
//typedef uint32_t eventType_t;  // Set to 32bit when TASK_EVENT_TOTAL higher than 16

/* Global variables ***********************************************************/

/* Global functions ***********************************************************/
extern void Task_MainLoop(void);
extern void Task_EventSend(eventId_t eventId);
extern void Task_EventSendISR(eventId_t eventId);
extern uint64_t Timer_u64Get1msTimerTick(void);
extern bool Timer_bIsElasped(uint64_t u64TimerStart, uint64_t u64TimePeriod);

#ifdef __cplusplus
}
#endif

#endif  // End of __TASK_H definition

/* End of file ****************************************************************/
