/* Define to prevent recursive inclusion **************************************/
#ifndef __TIMER_H
#define __TIMER_H

#ifdef __cplusplus
extern "C" {
#endif

/* header files ***************************************************************/

/* Global macro ***************************************************************/
#define INVALID_TIMER_ID	0xFF
#define SAMPLE_CLOCK        60000u      // sample clock is 60K
#define SYS_TICKS_PER_SEC	30000u		// control ISR is 30K

#define SYS_TICKS_0_1_MS	((uint32_t)((0.1e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_0_5_MS	((uint32_t)((0.5e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_1_MS		((uint32_t)((1.0e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_2_MS		((uint32_t)((2.0e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_4_MS		((uint32_t)((4.0e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_5_MS		((uint32_t)((5.0e-3    * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_10_MS		((uint32_t)((10.0e-3   * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_20_MS		((uint32_t)((20.0e-3   * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_30_MS		((uint32_t)((30.0e-3   * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_50_MS		((uint32_t)((50.0e-3   * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_100_MS	((uint32_t)((100.0e-3  * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_200_MS	((uint32_t)((200.0e-3  * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_500_MS	((uint32_t)((500.0e-3  * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_1_S		((uint32_t)((1.0       * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_2_S		((uint32_t)((2.0       * (float32_t)SYS_TICKS_PER_SEC) + 0.5))
#define SYS_TICKS_10_S		((uint32_t)((10.0      * (float32_t)SYS_TICKS_PER_SEC) + 0.5))

/* Global types ***************************************************************/

/* Global variables ***********************************************************/

/* Global functions ***********************************************************/
extern uint16_t Timer_u16StartTask(uint32_t u32tickOffset, uint32_t u32period, void (*callbackFunc)(void*), void* callbackArg, uint16_t u8repeat);
//void releaseTimers(uint16_t u16timerId);
extern void Timer_Check(void);
extern void Timer_SystemTick(void);
extern uint64_t Timer_u64getSystemTick(void);

#ifdef __cplusplus
}
#endif

#endif  // End of __TIMER_H definition

/* End of file ****************************************************************/
