
#include "CanApp.h"
#include "device.h"

App_Ecan_DS strApp_Ecan_DS_Para;
MailBox_Msg  aApp_MB_Infor[ECAN_ID_IND_MAX];

P_FUNC  Ary_MB_Callback[CAN_RD_MB] = {0,0,0,0};

uint8_t u8GetEcanState(void); //get the state of CANBUS
static uint8_t u8Bufferstate(uint8_t u8id);        //the state of BUFFER
uint8_t getMailBoxInfor(uint8_t u8id_index,MailBox_Msg *pstrdata);          //interface to
uint8_t setMailBoxPara(uint8_t u8id_index,uint8_t *pu8data,uint8_t u8length);//interface to
uint8_t u8GetEcanStreamState(uint8_t u8id);//GetMailbox state

/*******************************************************************************
 * u8Bufferstate()
 * Description: the Mailbox buffer state
 *
 * Inputs: id   the number of Mailbox's buffer
 *
 * Return:      the can be used empty data in Mailbox buffer
 *              127  the buffer is empty
 *              0    the buffer is full
*******************************************************************************/
static uint8_t u8Bufferstate(uint8_t u8id)
{
    return(( MBX_MAX_BUFFER - 1 + aApp_MB_Infor[u8id].u8Buf_R_Index - aApp_MB_Infor[u8id].u8Buf_W_Index) & MBX_MAX_BUFFER_MASK);
}

/***************************************************************
 * CanApp_SetEcanState();
 * Description : Set the can bus state
 *
 * input       : uint8_t state:the bus state
 *
 * return      :

 ****************************************************************/
uint8_t CanApp_SetEcanState(uint8_t u8state)
{
    if(u8state > ECAN_MAX)
    {
        return 0;
    }
    strApp_Ecan_DS_Para.u8APP_State = u8state;
    return 1;
}

/***************************************************************
 * u8GetEcanState();
 * Description : get the can bus state
 *
 * input       : void
 *
 * return      : can bus state

 ****************************************************************/
uint8_t u8GetEcanState(void)
{
    return (strApp_Ecan_DS_Para.u8APP_State);
}
/***************************************************************
 * function : void CanApp_SetRxReady(uint8_t u8index)
 * input    : uint8_t u8index
 * output   : none
 * date     :
 *
 ****************************************************************/
void CanApp_SetRxReady(uint8_t u8index)
{
    //strApp_Ecan_DS_Para.u32App_Rx_Ready_flag |= Rx_Tx_index;
    strApp_Ecan_DS_Para.u32App_Rx_Ready_flag = SETBIT_32b(strApp_Ecan_DS_Para.u32App_Rx_Ready_flag,u8index);
}

/***************************************************************
 * function : uint8_t CanApp_u8GetHighBits(uint32_t u32value)
 * input    : uint32_t value
 * output   : bits
 * date     : 2017/08/30
 *            Get High bits
 ****************************************************************/
void CanApp_CanResetFunc(uint8_t u8mode)
{
    uint32_t u32Status;

    if(u8GetEcanState() == ECAN_CLOSE)
    {
        u32Status = CAN_getStatus(CANA_BASE) & CAN_STATUS_LEC_MSK;
        if((u32Status == CAN_STATUS_LEC_MSK) || (u32Status == CAN_STATUS_LEC_NONE))
        {
            Device_initCan();
            CanApp_CanIfReStart();
        }
    }
}

/*******************************************************************************
 * CanApp_CanIfReStart
 * Description: reset Mailbox[n] data,when the can bus is close,the update the value
 *
 * Inputs: none
 *
 * Return: none
*******************************************************************************/
void CanApp_CanIfReStart(void)
{
    uint8_t i = 0;
    //uint8_t j = 0;
    for(i = 0;i < ECAN_ID_IND_MAX;i++)
    {
        aApp_MB_Infor[i].u8Buf_R_Index = 0;
        aApp_MB_Infor[i].u8Buf_W_Index = 0;

        aApp_MB_Infor[i].u8Stream_state = ECAN_MB_STREAM_INIT;
        aApp_MB_Infor[i].MB_flags.all = 0x0;

        aApp_MB_Infor[i].u8TimeOutCnt = 0;
    }
    //application init
    strApp_Ecan_DS_Para.u8APP_State = ECAN_UINT;
    //
}

/*******************************************************************************
 * Buffer_Pop()
 * Description: push the data into buffer
 *
 * Inputs:      uint8_t id : Mailbox NO.
 *              uint8_t *pu8data  :  the pointer of data
 *              uint8_t u8length   :  the length  of data
 * Return:      true / false
*******************************************************************************/
static uint8_t Buffer_Pop(uint8_t u8id,uint8_t *pu8data,uint8_t u8length)
{
    uint8_t data_len = 0;
    uint8_t i = 0;
    if(u8Bufferstate(u8id) == MBX_MAX_BUFFER_MASK)//the buffer is empty
    {
        return false;
    }
    //make sure length of read data is n*8
    if((u8length & 0x07))//==8 or n*8
    {
        return false;
    }
    //calculate the buffer data length
    data_len = ((aApp_MB_Infor[u8id].u8Buf_W_Index + MBX_MAX_BUFFER - aApp_MB_Infor[u8id].u8Buf_R_Index) & MBX_MAX_BUFFER_MASK);
    if(data_len < u8length) //data in buffer is less length
    {
        return false;
    }

    for(i = 0;i < u8length;i++)
    {
        *(pu8data + i) = *(aApp_MB_Infor[u8id].pu8msg + aApp_MB_Infor[u8id].u8Buf_R_Index );
        aApp_MB_Infor[u8id].u8Buf_R_Index = (aApp_MB_Infor[u8id].u8Buf_R_Index + 1) % MBX_MAX_BUFFER;
    }

    return true;
}

/*******************************************************************************
 * Buffer_Push()
 * Description: push the data into buffer
 *
 * Inputs:      uint8_t id : Mailbox NO.
 *              uint8_t *pu8data  :  the pointer of data
 *              uint8_t u8length   :  the length  of data
 * Return:      true / false
*******************************************************************************/
uint8_t i = 0;
uint8_t empty_length = 0;
uint8_t tmplen = 0;
static bool Buffer_Push(uint8_t u8id,uint8_t *pu8data,uint8_t u8length)
{
//  uint8_t i = 0;
//  uint8_t empty_length = 0;
//  uint8_t tmplen = 0;
    i = 0;
    empty_length = 0;
    tmplen = 0;

    if((pu8data == 0)  || (u8length == 0)  || ( u8id >= ECAN_ID_IND_MAX))//
    {
        return false;
    }
    //the buffer'length is short
    empty_length = u8Bufferstate(u8id);
    if(empty_length < u8length)
    {
        return false;
    }

    for(i = 0 ;i < u8length;i++)
    {
        *(aApp_MB_Infor[u8id].pu8msg + aApp_MB_Infor[u8id].u8Buf_W_Index) = *(pu8data + i);
        aApp_MB_Infor[u8id].u8Buf_W_Index = ((aApp_MB_Infor[u8id].u8Buf_W_Index + 1) & MBX_MAX_BUFFER_MASK);
    }
    //if the data is not 8 bytes,fill up to 8 with 0
    tmplen = (u8length & 0x07);
    //if(tmplen != 0x0)
    if((tmplen != 0x0) && (u8length <= 8))
    {
        tmplen = 8 - tmplen;
        for(i = 0 ;i < tmplen;i++)
        {
            *(aApp_MB_Infor[u8id].pu8msg + aApp_MB_Infor[u8id].u8Buf_W_Index) = 0x0;
            aApp_MB_Infor[u8id].u8Buf_W_Index = ((aApp_MB_Infor[u8id].u8Buf_W_Index + 1) & MBX_MAX_BUFFER_MASK);
        }
    }
    return true;
}

/*******************************************************************
 * function :  uint8_t CanApp_GetRxdata(void);
 * input    :
 * output   :
 * date     : 2017.07.03
 * des      : main function:
 *            Read function
 *            be called period task
 *
 ******************************************************************/
void CanApp_GetRxdata(P_FUNC *p_func)
{
    uint8_t i = 0;
    uint8_t p[8] = {0};

    for(i = ECAN_ID_IND_CTRL;i < ECAN_ID_IND_MAX;i++)
    {
        if(aApp_MB_Infor[i].MB_flags.bits.bfMB_State != ECAN_RX_SUCCESS)
        {
            continue ;
        }

        if(Buffer_Pop(i,&p[0],8))
        {
            if(aApp_MB_Infor[i].u8Buf_R_Index == aApp_MB_Infor[i].u8Buf_W_Index)// receive data is finish
            {
                aApp_MB_Infor[i].MB_flags.bits.bfMB_State = ECAN_RX_INIT;
            }
            //(*p_func[i])((void *)&p[0]);
            (**(p_func + i - ECAN_ID_IND_CTRL))((void *)&p[0]);
        }
    }
}

/*******************************************************************************
 * CanApp_RxDataPush()
 * Description: rx isr data push
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
void CanApp_RxDataPush(void)
{
    //volatile struct MBOX *pstrMailbox;//Mailbox base id
    uint8_t i;
    uint8_t a[8];
    uint32_t u32MsgObjId;
//    GpioDataRegs.GPACLEAR.bit.GPIO21 = 1u;
    for(i = ECAN_ID_IND_CTRL;i < ECAN_ID_IND_MAX;i++)
    {
        if(strApp_Ecan_DS_Para.u32App_Rx_Ready_flag & (0x000000001 << i) )
        {
            //clear flag;
            strApp_Ecan_DS_Para.u32App_Rx_Ready_flag = RESETBIT_32b(strApp_Ecan_DS_Para.u32App_Rx_Ready_flag,i);

//          pstrMailbox = (struct MBOX *)(&(ECanaMboxes.MBOX0)) + i ;
//          //pstrMailbox = (void *)(MAILBOX_BASE_ADDR/*0x00006100*/ + i * 8);
//          a[0] = pstrMailbox->MDL.byte.BYTE0;
//          a[1] = pstrMailbox->MDL.byte.BYTE1;
//          a[2] = pstrMailbox->MDL.byte.BYTE2;
//          a[3] = pstrMailbox->MDL.byte.BYTE3;
//          a[4] = pstrMailbox->MDH.byte.BYTE4;
//          a[5] = pstrMailbox->MDH.byte.BYTE5;
//          a[6] = pstrMailbox->MDH.byte.BYTE6;
//          a[7] = pstrMailbox->MDH.byte.BYTE7;
            u32MsgObjId = i + 1;//Because the mail box starts at 1
            CAN_readMessage(CANA_BASE, u32MsgObjId, (uint16_t *)&a[0]);
            if(Buffer_Push(i,&a[0],8))
            {
                aApp_MB_Infor[i].MB_flags.bits.bfMB_State = ECAN_RX_SUCCESS;
            }
        }
    }
}

/*******************************************************************
 * function :  uint8_t APP_ECAN_Tx_S(uint8_t id_index,uint8_t *pu8data,uint8_t u8length);
 * input    :  uint8_t id_index:  Mailbox id
 *             uint8_t *pu8data:   send data
 *             uint8_t u8length:    the length of send data
 * output   :
 * date     :
 * des      : ECAN APP
 *
 ******************************************************************/
uint8_t CanApp_TxApp(uint8_t u8id_index,uint8_t *pu8data,uint8_t u8length)
{
    //check the input parameter state
    if((u8id_index > ECAN_ID_IND_CTRL) || (pu8data == 0)  || (u8length == 0))//id max error //the data is null
    {
        return 0;
    }
    //Mailbox txing last stream
    if((u8GetEcanStreamState(u8id_index) == ECAN_MB_STREAM_TXING) || (u8GetEcanState() == ECAN_CLOSE))
    {
        return 0;
    }
    return (setMailBoxPara(u8id_index,pu8data,u8length));
}
/*******************************************************************
 * function :  void CanApp_TxTp(void);
 * input    :
 * output   :
 * date     :
 * des      : main function:
 *            call transmit data
 *            be called period task
 *
 ******************************************************************/
void CanApp_TxTp(void)
{
    uint8_t u8id_index = 0;
    uint8_t u8ecan_bus_state;

    u8ecan_bus_state = u8GetEcanState();
    //can bus is close
    if((u8ecan_bus_state == ECAN_CLOSE))
    {
        return;
    }
    //check Mailbox's state
    for(u8id_index = 0;u8id_index < ECAN_ID_IND_CTRL;u8id_index++)
    {
        if(aApp_MB_Infor[u8id_index].u8Stream_state == ECAN_MB_STREAM_TXING)
        {

            if(aApp_MB_Infor[u8id_index].MB_flags.bits.bfMB_Enable == 0)
            {
                //ENTER_CRITICAL();
                //Can_Transmit(u8id_index);
                //EXIT_CRITICAL();
            }
        }
      }
}

/***************************************************************
 * function : uint8_t u8GetEcanStreamState(uint8_t id);//GetMailbox state;
 * input    : uint8_t id:Mailbox id
 * output   : stream state
 * date     : 2017/07/03
 *
 ****************************************************************/
uint8_t u8GetEcanStreamState(uint8_t u8id)
{
    return (aApp_MB_Infor[u8id].u8Stream_state);
}

void SetEcanStreamState(uint8_t u8id,uint8_t u8state)
{
    aApp_MB_Infor[u8id].u8Stream_state = u8state;
}

/***************************************************************
 * setMailBoxPara()
 * Description : set Mailbox data
 *
 * input    : uint8_t id_index
 *            MailBox_Msg *p_data  return the value of id_index
 *
 * output   : the get message state
 ****************************************************************/
uint8_t setMailBoxPara(uint8_t u8id_index,uint8_t *pu8data,uint8_t u8length)
{
    if((u8id_index >= ECAN_ID_IND_CTRL) || (pu8data == 0))
    {
        return 0;
    }

    if(Buffer_Push(u8id_index,pu8data,u8length))
    {
        aApp_MB_Infor[u8id_index].u8Stream_state = ECAN_MB_STREAM_TXING;
        //aApp_MB_Infor[u8id_index].resendcnt    = 0x0;
        return 1;
    }
    return 0;
}

