

#include "Database.h"
#include "CanProtocol.h"
#include "CanApp.h"



uint16_t u16test[16] = {0};
static  uint8_t au8tempdatabuffer[8] = {0};

static void CanApp_ControlMessage(void *p);
static void CanApp_FlashMessage(void *p);
static void CanApp_Openloop1Message(void *p);
static void CanApp_Openloop2Message(void *p);
static void vidTransmitStatus1(uint8_t u8index);
static void vidTransmitStatus2(uint8_t u8index);
static void vidTransmitAlarms(uint8_t u8index);
//static void vidTransmitSensorDagnostic(uint8_t u8index);
//static void vidTransmitRationnality(uint8_t u8index);
//static void vidTransmitSelfTestStatus(uint8_t u8index);
//static void vidTransmitStatus3(uint8_t u8index);

/*******************************************************************************
 * void CanProtocol_init(void);
 * Description: application read mailbox data,then dealdata
 *
 * Inputs:      void *p,the receive data
 *
 * Return:      None
*******************************************************************************/
void CanProtocol_init(void)
{
    Ary_MB_Callback[0] = CanApp_ControlMessage;          /*Control 0x300*/
    Ary_MB_Callback[1] = CanApp_FlashMessage;            /*Flash 0x304*/
    Ary_MB_Callback[2] = CanApp_Openloop1Message;        /*Configuration 0x310*/
    Ary_MB_Callback[3] = CanApp_Openloop2Message;        /*Configuration 0x311*/
}

/*******************************************************************************
 * void CanApp_ControlMessage(void *p)
 * Description: application read mailbox data,then dealdata
 *
 * Inputs:      void *p,the receive data
 *
 * Return:      None
*******************************************************************************/
uint16_t u16Test1[8] = {0};
static void CanApp_ControlMessage(void *p)
{
//    static bool CrcError = 0;
//    static bool RollingError = 0;
//    static uint8_t CrcErrorCounter = 0;
//    static uint8_t CrcRightCounter = 0;
//    uint16_t Detal = 0;
//    static uint8_t RollingWrongCounter = 0;
//    static uint8_t RollingRightCounter = 0;
//    uint16_t u16tmpdata = 0;
    uint8_t *pointer = (uint8_t *)p;
    u16Test1[0] = *pointer;
    u16Test1[1] = *(pointer+1);
    u16Test1[2] = *(pointer+2);
    u16Test1[3] = *(pointer+3);
    u16Test1[4] = *(pointer+4);
    u16Test1[5] = *(pointer+5);

//    static uint16_t u16RollingCounter = 0;
//    static uint16_t u16RollingLastData = 0;
//    static uint16_t u16FirstMessageReceiveCnt = 0;
////    static bool bIsFirstMessageReceive = true;
////    CanProtocolSystem.bIsFirstMessageReceive = true;
//    CanApp_UpdateRxTimer();
//
//    u16RollingCounter = (uint16_t)((uint16_t)*pointer >> 4);
//
//    if(CanProtocolSystem.bIsFirstMessageReceive == false)
//    {
//        if (u16RollingCounter == u16RollingLastData)
//        {
//            RollingWrongCounter ++;
//            if (RollingWrongCounter >= 3)
//            {
//                RollingError = true;
//            }
//            RollingRightCounter = 0;
//        }
//        else
//        {
//            if (u16RollingCounter > u16RollingLastData)
//            {
//                Detal = u16RollingCounter - u16RollingLastData;
//            }
//            else
//            {
//                Detal = u16RollingCounter + 16 - u16RollingLastData;
//            }
//
//            if (Detal >= 3)
//            {
//                RollingError = true;
//            }
//            else if (Detal == 1)
//            {
//                RollingRightCounter ++;
//                RollingWrongCounter = 0;
//            }
//
//            if (RollingRightCounter >= 3)
//            {
//                RollingError = false;
//            }
//        }
//        u16RollingLastData = u16RollingCounter;
//    }
//    else
//    {
//        u16FirstMessageReceiveCnt++;
//    }
//    if(u16FirstMessageReceiveCnt >= 3)
//    {
//        u16FirstMessageReceiveCnt = 0;
//        CanProtocolSystem.bIsFirstMessageReceive = false;
//    }
//    u16RollingLastData = u16RollingCounter;
//
//    u16CrcDataLocal = Crc_CalculateCRC8((uint8_t *)pointer, 7, 0, true);
//    u16CrcDataRemote = (uint16_t)((uint16_t)*(pointer+7));
//
//    *****Check CrcError Fail**
//    if(u16CrcDataLocal != u16CrcDataRemote)//if((u16CrcDataLocal != u16CrcDataRemote) || (RollingError == true))
//    {
//        CrcErrorCounter++;
//        CrcRightCounter = 0;
//    }
//    else   // if(u16CrcDataLocal == u16CrcDataRemote) //else if((u16CrcDataLocal == u16CrcDataRemote) && (RollingError == false))
//    {
//        CrcRightCounter++;
//        CrcErrorCounter = 0;
//    }
//    if(CrcErrorCounter >= 3)
//    {
//        CrcError = true;
//        CrcErrorCounter = 0;
//    }
//    if(CrcRightCounter >= 3)
//    {
//        CrcError = false;
//        CrcRightCounter = 0;
//    }
//
//    *****Set bCrcRollingCntFail Flag
//     According to CrcError and RollingError****
//    if((CrcError == true) || (RollingError == true))
//    {
//        bCrcRollingCntFail = true;
//    }
//    else if((CrcError == false) && (RollingError == false))
//    {
//        bCrcRollingCntFail = false;
//
//        u16tmpdata = (uint16_t)((uint16_t)*pointer & 0x0F);
//        Database_SetSystemControl(u16tmpdata);
//
//        u16tmpdata = (uint16_t)(((uint16_t)*(pointer+2) << 8) + *(pointer+1));
//        Database_SetPowerLimit(u16tmpdata);
//
//        u16tmpdata = (uint16_t)(((uint16_t)*(pointer+4) << 8) + *(pointer+3));
//        Database_SetVoltageLimit((uint32_t)(u16tmpdata));
//
//        Database_SetDcCurrentLimit(*(pointer+5));
//
//        u16tmpdata = (uint16_t)((uint16_t)*(pointer+6) & 0x3F);
//        Database_SetAcCurrentLimit(u16tmpdata);
//
//        u16tmpdata = (uint16_t)((uint16_t)*(pointer+6) >> 6);
//        Database_SetS2Status(u16tmpdata);
//    }
}
/*******************************************************************************
 * void CanApp_FlashMessage(void *p)
 * Description: application read mailbox data,then deal data
 *
 * Inputs:      void *p,the receive data
 *
 * Return:      None
*******************************************************************************/
static void CanApp_FlashMessage(void *p)
{
////#if BIOBC_TEST
////  uint8_t u8tmpdata = 0;
////  uint8_t* pointer = (uint8_t*)p;
////    u8tmpdata = *pointer;
////  Control_SetDataCapture(1);
////#endif
//
//    uint8_t* pointer = (uint8_t*)p;
//
//    if ((*pointer == 0x06) && (*(pointer+1) == 0x00) && (*(pointer+2) == (char_t)'L') && (*(pointer+3) == (char_t)'T') && (*(pointer+4) == (char_t)'K'))  //0x4C, 0x54, 0x4B, 0x18, 0x53
//                        //(pMessage->pchData[2] == (CHAR)'L') && (pMessage->pchData[3] == (CHAR)'T') && (pMessage->pchData[4] == (CHAR)'K'))
//    {
//         Verify CRC
//        if (Crc_IsEqual(CrcType_CCITT_XMODEM, (uint16_t const*)(pointer+1), 4, CanCB_CanReadWord(pointer+5)))
//        lint -restore
//        {
//            uint64_t u64AlarmBits = Database_u64GetAlarmBits();
//
//            if (((u64AlarmBits >> (uint16_t)AlarmBit_EepromWornOut) & 0x01) == false)
//            {
//                 Eeprom(s) not worn out, indicate request for transition to bootloader
//                Database_SetEnterBootloader();
//            }
//            else
//            {
//                 Block transition to bootloader, as one of the eeproms are worn out and one of the magic word(s) therefore cannot be written
//            }
//        }
//        //Eeprom_SendEvent(CLEAR_ALL);
//        //Eeprom_SendEvent(WRITE_ALL);
//    }
//    else
//    {
//         Incorrect code. ignore
//    }
}

/*******************************************************************************
 * void CanApp_Openloop1Message(void *p)
 * Description: application debug control message for open loop
 * PWM period and duty
 *
 * Inputs:      void *p,the receive data
 *
 * Return:      None
*******************************************************************************/
#define OPENLOOP 0
static void CanApp_Openloop1Message(void *p)
{
#if OPENLOOP
    uint8_t* pointer = (uint8_t*)p;
    {
        uint16_t i;
        for(i=0; i<8; i++)
        {
            u16test[i] = *(pointer+i);
        }
        Database_setPWM_Period_Duty(SEC_1_2, *pointer, *(pointer+1));
        Database_setPWM_Period_Duty(SEC_3_4, *(pointer+2), *(pointer+3));
        Database_setPWM_Period_Duty(PRI_1_2, *(pointer+4), *(pointer+5));
    }
#endif
}

/*******************************************************************************
 * void CanApp_Openloop2Message(void *p)
 * Description: application debug control message for open loop
 * PWM period and duty
 *
 * Inputs:      void *p,the receive data
 *
 * Return:      None
*******************************************************************************/
static void CanApp_Openloop2Message(void *p)
{

    #if OPENLOOP
    uint8_t* pointer = (uint8_t*)p;
    uint16_t i;
    for(i=8; i<16; i++)
    {
        u16test[i] = *(pointer+i-8);
    }
    {
        Database_setPWM_Period_Duty(PRI_3_4, *pointer, *(pointer+1));
        Database_setPWM_Period_Duty(PFC_S_1_2, *(pointer+2), *(pointer+3));
        Database_setPWM_Period_Duty(PFC_F_1_2, *(pointer+4), *(pointer+5));
    }
#endif
}

/*******************************************************************************
 * CanPro_Transmit100ms()
 * Description: can transmit per 100ms interval job
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/

void CanPro_Transmit100ms(void)
{
    vidTransmitStatus1(ECAN_ID_IND_STATUS_1);
    vidTransmitStatus2(ECAN_ID_IND_STATUS_2);
    vidTransmitAlarms(ECAN_ID_IND_STATE_ALARM);
//    vidTransmitSelfTestStatus(ECAN_ID_IND_SELF_TEST);
//    vidTransmitStatus3(ECAN_ID_IND_BUS_INVPOWER); //10
}

/*******************************************************************************
 * vidTransmitStatus1()
 * Description: can transmit status1
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
void vidTransmitStatus1(uint8_t u8index)
{
    uint32_t u32InputCurrentM10;
    uint32_t u32OutputVoltageM10;
    uint32_t u32OutputCurrentM100;
    uint32_t u32AvailablePowerDerating;

    u32InputCurrentM10 = 100;//Remote_u32GetInputCurrent();
    u32OutputVoltageM10 = 480;//Database_u16GetBatVoltAvg();//Database_u32GetOutputVoltage();/*output voltage is M10 type*/
    u32OutputCurrentM100 = 32;//Database_u32GetOutputCurrent();/*output current is M100 type*/
    u32AvailablePowerDerating = 6600;//Database_u32GetAvailablePower();

    au8tempdatabuffer[0] = (uint8_t)(u32InputCurrentM10 & 0xFF);
    au8tempdatabuffer[1] = (uint8_t)((u32InputCurrentM10 >> 8) & 0xFF);
    au8tempdatabuffer[2] = (uint8_t)(u32OutputCurrentM100 & 0xFF);
    au8tempdatabuffer[3] = (uint8_t)((u32OutputCurrentM100 >> 8) & 0xFF);
    au8tempdatabuffer[4] = (uint8_t)(u32OutputVoltageM10 & 0xFF);
    au8tempdatabuffer[5] = (uint8_t)((u32OutputVoltageM10 >> 8) & 0xFF);
    au8tempdatabuffer[6] = (uint8_t)(u32AvailablePowerDerating & 0xFF);
    au8tempdatabuffer[7] = (uint8_t)((u32AvailablePowerDerating >> 8) & 0xFF);

    CanApp_TxApp(u8index,&au8tempdatabuffer[0],8);
}

/*******************************************************************************
 * vidTransmitStatus2()
 * Description: can transmit status2
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
void vidTransmitStatus2(uint8_t u8index)
{
    int32_t s32SecondaryTemp;
    int32_t s32HVDCTrafoTemperature;
    int32_t s32TrafoTemp;
    int32_t s32PrimaryTemp;
    uint32_t u32InputVoltage;
    uint32_t u32InputFrequency;

    /* Fetch and prepare data */
    s32SecondaryTemp = 20;//Database_s32GetSecondaryTemp();
    s32HVDCTrafoTemperature = 30;//Database_s32GetTraformerTemp();
    s32TrafoTemp = 35;//Remote_s32GetTemperatureIGBT();//Database_s32GetTraformerTemp();
    s32PrimaryTemp = 26;//Remote_s32GetTemperature();
    u32InputVoltage = 230;//Remote_u32GetInputVoltage();/*input voltage is M100 type*/
    u32InputFrequency = 50;//Remote_u32GetInputFrequency();

    /* Clamp due to 8 bit limitation of temperature in CAN protocol */
    if (s32SecondaryTemp < (-128))
    {
        s32SecondaryTemp = (-128);
    }
    else if (s32SecondaryTemp > 150)
    {
        s32SecondaryTemp = 150;
    }
    else
    {
        /* Valid 8-bit temperature */
    }

    /* Clamp due to 8 bit limitation of temperature in CAN protocol */
    if (s32HVDCTrafoTemperature < (-128))
    {
        s32HVDCTrafoTemperature = (-128);
    }
    else if (s32HVDCTrafoTemperature > 150)
    {
        s32HVDCTrafoTemperature = 150;
    }
    else
    {
        /* Valid 8-bit temperature */
    }

    au8tempdatabuffer[0] = (uint8_t)(u32InputVoltage & 0xFF);//
    au8tempdatabuffer[1] = (uint8_t)((u32InputVoltage >> 8) & 0xFF);//
    au8tempdatabuffer[2] = (uint8_t)(u32InputFrequency & 0xFF);//(uint8_t)((uint32_t)s32TrafoTemp & 0xFF);
    au8tempdatabuffer[3] = (uint8_t)(s32PrimaryTemp & 0xFF);
    au8tempdatabuffer[4] = (uint8_t)(((s32SecondaryTemp << 1) & 0xFE) + ((s32PrimaryTemp >> 8) & 0x01));
    au8tempdatabuffer[5] = (uint8_t)(((s32TrafoTemp << 2) & 0xFC) + ((s32SecondaryTemp >> 7) & 0x03));
    au8tempdatabuffer[6] = (uint8_t)(((s32HVDCTrafoTemperature << 3) & 0xF1) + ((s32TrafoTemp >> 6) & 0x07));
    au8tempdatabuffer[7] = (uint8_t)((s32HVDCTrafoTemperature >> 5) & 0x0F);

    CanApp_TxApp(u8index,&au8tempdatabuffer[0],8);
}

/*******************************************************************************
 * vidTransmitAlarms()
 * Description: can transmit state and alarm
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
void vidTransmitAlarms(uint8_t u8index)
{

    uint32_t u32SystemState;
    uint64_t u64AlarmBits = 0;
//        uint16_t u16Crc_Alarm;

    u64AlarmBits = 0x010203040506;//Database_u64GetAlarmBits();
    u32SystemState = 0xFF;//Database_u32GetSystemState();


    au8tempdatabuffer[0] = (uint8_t)u32SystemState;
    au8tempdatabuffer[1] = (uint8_t)(u64AlarmBits & 0xFF);
    au8tempdatabuffer[2] = (uint8_t)((u64AlarmBits >> 8) & 0xFF);
    au8tempdatabuffer[3] = (uint8_t)((u64AlarmBits >> 16) & 0xFF);
    au8tempdatabuffer[4] = (uint8_t)((u64AlarmBits >> 24) & 0xFF);
    au8tempdatabuffer[5] = (uint8_t)((u64AlarmBits >> 32) & 0xFF);
    au8tempdatabuffer[6] = (uint8_t)((u64AlarmBits >> 40) & 0xFF);

//    u16Crc_Alarm = Crc_CalculateCRC8(au8tempdatabuffer, 7, 0, TRUE);

    au8tempdatabuffer[7] = 0u;//(uint8_t)u16Crc_Alarm;

    CanApp_TxApp(u8index,&au8tempdatabuffer[0],8);
}

/*******************************************************************************
 * vidTransmitSensorDagnostic()
 * Description: can transmit CARB sensor Diagnostics and rationality
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
/*void vidTransmitSensorDagnostic(uint8_t u8index)
{
    uint64_t u64PriSensor;
    uint64_t u64SecSensor;
    u64PriSensor = (uint64_t)STM_u32GetTest1();//Remote_u64GetSensor();
    u64SecSensor = (uint64_t)STM_u32GetTest2();//Database_u64GetSensor();

    au8tempdatabuffer[0] = (uint8_t)(u64PriSensor & 0xFF);
    au8tempdatabuffer[1] = (uint8_t)((u64PriSensor >> 8) & 0xFF);
    au8tempdatabuffer[2] = (uint8_t)((u64PriSensor >> 16) & 0xFF);
    au8tempdatabuffer[3] = (uint8_t)((u64PriSensor >> 24) & 0xFF);
    au8tempdatabuffer[4] = (uint8_t)(u64SecSensor & 0xFF);
    au8tempdatabuffer[5] = (uint8_t)((u64SecSensor >> 8) & 0xFF);
    au8tempdatabuffer[6] = (uint8_t)((u64SecSensor >> 16) & 0xFF);
    au8tempdatabuffer[7] = (uint8_t)((u64PriSensor >> 24) & 0xFF);
//  au8tempdatabuffer[3] = (uint8_t)(((u64PriSensor >> 24) & 0xF) | ((u64SecSensor & 0xF) << 4));
//  au8tempdatabuffer[4] = (uint8_t)((u64SecSensor >> 4) & 0xFF);
//  au8tempdatabuffer[5] = (uint8_t)((u64SecSensor >> 12) & 0xFF);
//  au8tempdatabuffer[6] = (uint8_t)((u64SecSensor >> 20) & 0xFF);
//  au8tempdatabuffer[7] = (uint8_t)((u64PriSensor >> 28) & 0xFF);

    CanApp_TxApp(u8index,&au8tempdatabuffer[0],8);
}*/

/*******************************************************************************
 * vidTransmitRationnality()
 * Description: can transmit CARB sensor Diagnostics and rationality
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
/*void vidTransmitRationnality(uint8_t u8index)
{
    uint32_t u32PriRationality;
    uint32_t u32SecRationality;
    u32SecRationality = Database_u32GetFailFlag();//Database_bIsSciComLost();//STM_u32GetBackwardSTMode();//STM_u32GetForwardSTMode();//Database_u32GetRationality();
    u32PriRationality = Remote_u32GetRationality();
    **debug***

    uint32_t u32PwmCnt;
    u32PwmCnt = (uint32_t)Control_s32GetBusVoltage();//STM_u32GetTest3();


    au8tempdatabuffer[0] = (uint8_t)(u32PriRationality & 0xFF);
    au8tempdatabuffer[1] = (uint8_t)((u32PriRationality >> 8) & 0xFF);
    au8tempdatabuffer[2] = (uint8_t)((u32PriRationality >> 16) & 0xFF);//(u32PriRationality & 0xFF);
    au8tempdatabuffer[3] = (uint8_t)((u32PriRationality >> 24) & 0xFF);//(((u32PriRationality >> 8) & 0x3F) | (((u32SecRationality >> 16) & 0x3) << 6));
    au8tempdatabuffer[4] = (uint8_t)(u32SecRationality & 0xFF);//((u32PwmCnt >> 24) & 0xFF);  //debug
    au8tempdatabuffer[5] = (uint8_t)((u32SecRationality >> 8) & 0xFF);//((u32PwmCnt >> 16) & 0xFF);  //debug
    au8tempdatabuffer[6] = (uint8_t)((u32SecRationality >> 16) & 0xFF);//((u32PwmCnt >> 8) & 0xFF);  //debug
    au8tempdatabuffer[7] = (uint8_t)((u32SecRationality >> 24) & 0xFF);//(u32PwmCnt & 0xFF);  //debug

    CanApp_TxApp(u8index,&au8tempdatabuffer[0],8);
}*/



