#include "Database.h"
#include "Control.h"


void Database_setPWM_Period_Duty(PWMChanel PWM_channel, uint16_t u16PeriodSetValue, uint16_t u16DutySetValue)
{
    Control_setPWM_Period_Duty(PWM_channel, u16PeriodSetValue, u16DutySetValue);
}

/*******************************************************************************
 * Database_setInputZeroLoss()
 * Description:
 *
 * Inputs:      None
 *
 * Return:      none
 * *******************************************************************************/
void Database_setInputZeroLoss(bool bValue)
{
    Control_setInputZeroLoss(bValue);
}

/*******************************************************************************
 * Database_u16GetInputFrequencyM10()
 * Description: get input frequency *10
 *
 * Inputs:      None
 *
 * Return:      input frequency *10
 * *******************************************************************************/
uint16_t Database_u16GetInputFrequencyM10(void)
{
    uint16_t u16Return;

    u16Return = Control_u16GetInputFrequencyM10();

    return u16Return;
}

uint32_t Database_u32GetBatVoltage(void)
{
    int32_t s32Return;

    s32Return = Control_s32GetBatVoltage();

    return s32Return;
}

/******************************************************************************
 * Database_u32GetOutputCurrent()
 * Description: the bat safety current measurement range is wider the the bat current.
 *
 * Inputs:      output DC current is M100 type
 *
 * Return:      None
 * ******************************************************************************/
uint32_t Database_u32GetOutputCurrent(void)
{
//    int32_t s32BatCurrent;
//    int32_t s32BatCurrentTemp;
//    uint32_t u32BatCurrentDischargeDisplay;
//    u32BatCurrentDischargeDisplay = ABS_I(Control_s32GetBatCurrent());
//
//    if(STM_u32GetSystemState() == SystemState_Prestart || STM_u32GetSystemState() == SystemState_Discharge)
//    {
//        if(u32BatCurrentDischargeDisplay <= 300)
//        {
//            s32BatCurrentTemp = Control_s32GetBatCurrent();
//        }
//        else
//        {
//            s32BatCurrentTemp = Control_s32GetBatSafetyCurrent();
//        }
//    }
//    else
//    {
//        s32BatCurrentTemp = Control_s32GetBatCurrent();
//    }
//
//    if (s32BatCurrentTemp < 0)
//    {
//        s32BatCurrent = (-s32BatCurrentTemp);
//    }
//    else
//    {
//        s32BatCurrent = s32BatCurrentTemp;
//    }
//    return (uint32_t)s32BatCurrent;
}
