
/* header files ***************************************************************/

#include "f28x_project.h"
#include "device.h"
#include "driverlib.h"
#include "Task.h"
#include "Timer.h"
#include "CanApp.h"
#include "CanProtocol.h"
//#include "Control.h"
//#include "safety.h"
/* local macro definitions ****************************************************/
#define TASK_5MS_GROUP_1_INTERVAL   (SYS_TICKS_10_MS  / SYS_TICKS_5_MS)     // Called every 10ms
#define TASK_5MS_GROUP_2_INTERVAL   (SYS_TICKS_20_MS  / SYS_TICKS_5_MS)     // Called every 20ms
#define TASK_5MS_GROUP_3_INTERVAL   (SYS_TICKS_50_MS  / SYS_TICKS_5_MS)     // Called every 50ms
#define TASK_5MS_GROUP_4_INTERVAL   (SYS_TICKS_100_MS / SYS_TICKS_5_MS)     // Called every 100ms
#define TASK_5MS_GROUP_5_INTERVAL   (SYS_TICKS_200_MS / SYS_TICKS_5_MS)     // Called every 200ms
#define TASK_5MS_GROUP_6_INTERVAL   (SYS_TICKS_1_S    / SYS_TICKS_5_MS)     // Called every 1s

#define TASK_1MS_GROUP_1_INTERVAL   (SYS_TICKS_2_MS   / SYS_TICKS_1_MS)     // Called every 2ms
#define TASK_1MS_GROUP_2_INTERVAL   (SYS_TICKS_4_MS   / SYS_TICKS_1_MS)     // Called every 4ms

/* local types definitions ****************************************************/
enum
{
    TASK_5MS_GROUP_1 = 0,
    TASK_5MS_GROUP_2,
    TASK_5MS_GROUP_3,
    TASK_5MS_GROUP_4,
    TASK_5MS_GROUP_5,
    TASK_5MS_GROUP_6,
    TASK_5MS_GROUP_TOTAL
};

enum
{
    TASK_1MS_GROUP_1 = 0,
    TASK_1MS_GROUP_2,
    TASK_1MS_GROUP_TOTAL
};

/* local variable declarations ************************************************/
static eventType_t taskEventFlags = 0;
static uint64_t u64TimerTick1ms = 0;

/* global variable declarations ***********************************************/

/* internal function prototypes ***********************************************/
static eventType_t taskEventGet(void);
static void tasksProcess(void);
static void tasksGroup1MS(void* unused);
static void tasksGroup5MS(void* unused);
static void vid_CanRxEventCall(void);
static void vid_1msPreCall(void);
static void vid_1msPostCall(void);
static void vid_2msPreCall(void);
static void vid_2msPostCall(void);
static void vid_4msPreCall(void);
static void vid_4msPostCall(void);
static void vid_5msPreCall(void);
static void vid_5msPostCall(void);
static void vid_10msPreCall(void);
static void vid_10msPostCall(void);
static void vid_20msPreCall(void);
static void vid_20msPostCall(void);
static void vid_50msPreCall(void);
static void vid_50msPostCall(void);
static void vid_100msPreCall(void);
static void vid_100msPostCall(void);
static void vid_200msPreCall(void);
static void vid_200msPostCall(void);
static void vid_1000msPreCall(void);
static void vid_1000msPostCall(void);

/*******************************************************************************
 * Task_MainLoop()
 * Description: Tasks main loop, check the timer and execute the timer callback,
 *              and process the tasks.
 *
 * Inputs:      None
 *
 * Return:      Never return
*******************************************************************************/
void Task_MainLoop(void)
{
    // Register timer so that tasksGroup1MS() can be called every 1ms, add 0.5ms offset
    Timer_u16StartTask(SYS_TICKS_0_5_MS, SYS_TICKS_1_MS, tasksGroup1MS, NULL, 1);
    // Register timer so that tasksGroup5MS() can be called every 5ms
    Timer_u16StartTask(0, SYS_TICKS_5_MS, tasksGroup5MS, NULL, 1);

    while (true)
    {
        //Clear_TestPin_2();
        tasksProcess();
        Timer_Check();
        //Set_TestPin_2();

    }
}

/*******************************************************************************
 * tasksProcess()
 * Description: Process the task according with events
 *
 * Inputs:      None
 *
 * Return:      None
*******************************************************************************/
static void tasksProcess(void)
{
    eventType_t eventFlags = taskEventGet();    // Events will be clear after get


    if (eventFlags & ((eventType_t)1 << TASK_EVENT_CAN_RX))
    {// Execute the functions related with CAN RX here
        vid_CanRxEventCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_INV_ZERO))
    {// Execute the functions related with CAN RX here
//      Inverter_VoltCurrRmsCal();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_LINE_ZERO))
    {// Execute the functions related with CAN RX here

        Control_VoltCurrRmsCal();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_CALC_CUR_LIMIT))
    {// Execute the functions related with calculate current limit here
       // vid_calcCurLimitEventCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_1MS_GROUP))
    {
        vid_1msPreCall();
        vid_1msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_2MS_GROUP))
    {
        vid_2msPreCall();
        vid_2msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_4MS_GROUP))
    {
        vid_4msPreCall();
        vid_4msPostCall();

    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_5MS_GROUP))
    {// Execute the functions with fixed 5ms period
        vid_5msPreCall();
        vid_5msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_10MS_GROUP))
    {// Execute the functions with fixed 10ms period
        vid_10msPreCall();
        vid_10msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_20MS_GROUP))
    {// Execute the functions with fixed 20ms period
        vid_20msPreCall();
        vid_20msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_50MS_GROUP))
    {// Execute the functions with fixed 50ms period
        vid_50msPreCall();
        vid_50msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_100MS_GROUP))
    {// Execute the functions with fixed 100ms period
        vid_100msPreCall();
        vid_100msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_200MS_GROUP))
    {// Execute the functions with fixed 200ms period
        vid_200msPreCall();
        vid_200msPostCall();
    }

    if (eventFlags & ((eventType_t)1 << TASK_EVENT_1000MS_GROUP))
    {// Execute the functions with fixed 1000ms period
        vid_1000msPreCall();
        vid_1000msPostCall();
    }

//  Spi_PollingJob();
}

/*******************************************************************************
 * tasksGroup1MS()
 * Description: 1ms task group, called every 1ms from Timer_Check() function.
 *              Used to manage the task group which's period of implement is n*1ms
 *
 * Inputs:      unused -> unused now
 *
 * Return:      None
*******************************************************************************/
static void tasksGroup1MS(void* unused)
{
    static uint16_t u16taskCount = 0;
    static uint16_t au16targetedTaskCount[TASK_1MS_GROUP_TOTAL] = {TASK_1MS_GROUP_1_INTERVAL, TASK_1MS_GROUP_2_INTERVAL + 1};
    // Add some count offset (e.g. 1,5,9) to make task group to interleave implement
    uint16_t u16taskIdx;
    int16_t  s16testVal;

    u64TimerTick1ms++;
    u16taskCount++;
    Task_EventSend(TASK_EVENT_1MS_GROUP);  // Send the event

    for (u16taskIdx = 0; u16taskIdx < TASK_1MS_GROUP_TOTAL; u16taskIdx++)
    {
        // Change the count error to sign number is for the subtraction overflow
        s16testVal = (int16_t)(u16taskCount - au16targetedTaskCount[u16taskIdx]);
        if (s16testVal < 0) continue; // NOT time out, check next task

        // Task time out, execute the task group
        switch (u16taskIdx)
        {
            case TASK_1MS_GROUP_1:  // Called every 2ms
                au16targetedTaskCount[u16taskIdx] += TASK_1MS_GROUP_1_INTERVAL;
                Task_EventSend(TASK_EVENT_2MS_GROUP);
                break;

            case TASK_1MS_GROUP_2:  // Called every 4ms
                au16targetedTaskCount[u16taskIdx] += TASK_1MS_GROUP_2_INTERVAL;
                Task_EventSend(TASK_EVENT_4MS_GROUP);
                break;
        }
    }
}
/*******************************************************************************
 * tasksGroup5MS()
 * Description: 5ms task group, called every 5ms from Timer_Check() function.
 *              Used to manage the task group which's period of implement is n*5ms
 *
 * Inputs:      unused -> unused now
 *
 * Return:      None
*******************************************************************************/
static void tasksGroup5MS(void* unused)
{
    static uint16_t u16taskCount = 0;
    static uint16_t au16targetedTaskCount[TASK_5MS_GROUP_TOTAL] = \
                        {TASK_5MS_GROUP_1_INTERVAL, TASK_5MS_GROUP_2_INTERVAL + 1, TASK_5MS_GROUP_3_INTERVAL + 5, \
                         TASK_5MS_GROUP_4_INTERVAL + 7, TASK_5MS_GROUP_5_INTERVAL + 9, TASK_5MS_GROUP_6_INTERVAL + 13};
    // Add some count offset (e.g. 1,5,9) to make task group to interleave implement
    uint16_t u16taskIdx;
    int16_t  s16testVal;

    u16taskCount++;
    Task_EventSend(TASK_EVENT_5MS_GROUP);  // Send the event

    for (u16taskIdx = 0; u16taskIdx < TASK_5MS_GROUP_TOTAL; u16taskIdx++)
    {
        // Change the count error to sign number is for the subtraction overflow
        s16testVal = (int16_t)(u16taskCount - au16targetedTaskCount[u16taskIdx]);
        if (s16testVal < 0) continue; // NOT time out, check next task

        // Task time out, execute the task group
        switch (u16taskIdx)
        {
            case TASK_5MS_GROUP_1:  // Called every 10ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_1_INTERVAL;
                Task_EventSend(TASK_EVENT_10MS_GROUP);
                break;

            case TASK_5MS_GROUP_2:  // Called every 20ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_2_INTERVAL;
                Task_EventSend(TASK_EVENT_20MS_GROUP);
                break;

            case TASK_5MS_GROUP_3:  // Called every 50ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_3_INTERVAL;
                Task_EventSend(TASK_EVENT_50MS_GROUP);
                break;

            case TASK_5MS_GROUP_4:  // Called every 100ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_4_INTERVAL;
                Task_EventSend(TASK_EVENT_100MS_GROUP);
                break;

            case TASK_5MS_GROUP_5:  // Called every 200ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_5_INTERVAL;
                Task_EventSend(TASK_EVENT_200MS_GROUP);
                break;

            case TASK_5MS_GROUP_6:  // Called every 1000ms
                au16targetedTaskCount[u16taskIdx] += TASK_5MS_GROUP_6_INTERVAL;
                Task_EventSend(TASK_EVENT_1000MS_GROUP);
                break;
        }
    }
}

/*******************************************************************************
 * taskEventGet()
 * Description: Return the event flags and then clear.
 *
 * Inputs:      None
 *
 * Return:      Task event flags
*******************************************************************************/
static eventType_t taskEventGet(void)
{
    eventType_t tempEventFlags;
    ENTER_CRITICAL();
    tempEventFlags = taskEventFlags;
    taskEventFlags = 0;   // Zero the flags after reading
    EXIT_CRITICAL();
    return tempEventFlags;
}

/*******************************************************************************
 * Task_EventSend()
 * Description: Post an event to the task event flag, eventId is the bit number
 *              in the task event flag. This function only can be called in the
 *              TASK level.
 *
 * Inputs:      eventId -> The bit number of the task event flag
 *
 * Return:      None
*******************************************************************************/
void Task_EventSend(eventId_t eventId)
{
    ENTER_CRITICAL();
    taskEventFlags |= ((eventType_t)1 << eventId);
    EXIT_CRITICAL();
}

/*******************************************************************************
 * Task_EventSendISR()
 * Description: Post an event to the task event flag, eventId is the bit number
 *              in the task event flag. This function only can be called in the
 *              INTERRUPT level.
 *
 * Inputs:      eventId -> The bit number of the task event flag
 *
 * Return:      None
*******************************************************************************/
void Task_EventSendISR(eventId_t eventId)
{
    taskEventFlags |= ((eventType_t)1 << eventId);
}

/*******************************************************************************
 * vid_CanRxEventCall()
 * Description: CAN RX event callback function
*******************************************************************************/
static void vid_CanRxEventCall(void)
{
    CanApp_RxDataPush();

}

/*******************************************************************************
 * vid_1msPreCall()
 * Description: Fixed period task call
 *              Called every 1ms
*******************************************************************************/
//int16_t testFlag =0;
static void vid_1msPreCall(void)
{
    static uint16_t u16taskCount = 0;
    GpioDataRegs.GPBTOGGLE.bit.GPIO48 = 1u;        //relay open

    if(u16taskCount++%2)
    {
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x00;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x00;
    }
    else
    {
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x00;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x02;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x00;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x02;
    }

}

/*******************************************************************************
 * vid_1msPostCall()
 * Description: Fixed period task call
 *              Called every 1ms
*******************************************************************************/
static void vid_1msPostCall(void)
{
//    Control_s32BatISafetyAvgCalc();
//    Control_AdcFilter();
}

/*******************************************************************************
 * vid_2msPreCall()
 * Description: Fixed period task call
 *              Called every 2ms
*******************************************************************************/
static void vid_2msPreCall(void)
{

}

/*******************************************************************************
 * vid_2msPostCall()
 * Description: Fixed period task call
 *              Called every 2ms
*******************************************************************************/
static void vid_2msPostCall(void)
{

}

/*******************************************************************************
 * vid_4msPreCall()
 * Description: Fixed period task call
 *              Called every 4ms
*******************************************************************************/
static void vid_4msPreCall(void)
{

}

/*******************************************************************************
 * vid_4msPostCall()
 * Description: Fixed period task call
 *              Called every 4ms
*******************************************************************************/
static void vid_4msPostCall(void)
{

}

/*******************************************************************************
 * vid_5msPreCall()
 * Description: Fixed period task call
 *              Called every 5ms
*******************************************************************************/
static void vid_5msPreCall(void)
{

}

/*******************************************************************************
 * vid_5msPostCall()
 * Description: Fixed period task call
 *              Called every 5ms
*******************************************************************************/
static void vid_5msPostCall(void)
{
    CanApp_CanResetFunc(1);
    CanApp_GetRxdata(Ary_MB_Callback);//check receive data
    Safety_vidTaskPolling();

}

/*******************************************************************************
 * vid_10msPreCall()
 * Description: Fixed period task call
 *              Called every 10ms
*******************************************************************************/
static void vid_10msPreCall(void)
{

}

/*******************************************************************************
 * vid_10msPostCall()
 * Description: Fixed period task call
 *              Called every 10ms
*******************************************************************************/
static void vid_10msPostCall(void)
{

}

/*******************************************************************************
 * vid_20msPreCall()
 * Description: Fixed period task call
 *              Called every 20ms
*******************************************************************************/
static void vid_20msPreCall(void)
{

}

/*******************************************************************************
 * vid_20msPostCall()
 * Description: Fixed period task call
 *              Called every 20ms
*******************************************************************************/
static void vid_20msPostCall(void)
{
//    Boost_CalculateBoostReference();
//    SciPro_Run(&CanProtocolSystem);
}

/*******************************************************************************
 * vid_50msPreCall()
 * Description: Fixed period task call
 *              Called every 50ms
*******************************************************************************/
static void vid_50msPreCall(void)
{
//    SFT_vidTask50msPolling();
}

/*******************************************************************************
 * vid_50msPostCall()
 * Description: Fixed period task call
 *              Called every 50ms
*******************************************************************************/
static void vid_50msPostCall(void)
{
//    CanPro_Transmit250ms();
}

/*******************************************************************************
 * vid_100msPreCall()
 * Description: Fixed period task call
 *              Called every 100ms
*******************************************************************************/
static void vid_100msPreCall(void)
{
//    if(SFT_vidClaTaskRunning())
//    {
//        Device_ServiceWatchDog();
//    }
}

/*******************************************************************************
 * vid_100msPostCall()
 * Description: Fixed period task call
 *              Called every 100ms
*******************************************************************************/
static void vid_100msPostCall(void)
{
    CanPro_Transmit100ms();
}

/*******************************************************************************
 * vid_200msPreCall()
 * Description: Fixed period task call
 *              Called every 200ms
*******************************************************************************/
static void vid_200msPreCall(void)
{

}

/*******************************************************************************
 * vid_200msPostCall()
 * Description: Fixed period task call
 *              Called every 200ms
*******************************************************************************/
static void vid_200msPostCall(void)
{

}

/*******************************************************************************
 * vid_1000msPreCall()
 * Description: Fixed period task call
 *              Called every 1000ms
*******************************************************************************/

static void vid_1000msPreCall(void)
{
/*    static uint16_t Test11;
    EALLOW;
    if(Test11 == 10)
    {
        NmiIntruptRegs.NMIFLGFRC.bit.CLOCKFAIL = 1;
        NmiIntruptRegs.NMIFLGCLR.bit.CLOCKFAIL = 1;
    }
    EDIS;*/

}

/*******************************************************************************
 * vid_1000msPostCall()
 * Description: Fixed period task call
 *              Called every 1000ms
*******************************************************************************/
static void vid_1000msPostCall(void)
{

    GpioDataRegs.GPBTOGGLE.bit.GPIO56 = 1u;
}


/*******************************************************************************
 * Timer_u64Get1msTimerTick()
 * Description: Get the system timer tick.
 *
 * Inputs:      None
 *
 * Return:      Current system timer tick
*******************************************************************************/
uint64_t Timer_u64Get1msTimerTick(void)
{
    return u64TimerTick1ms;
}

/*******************************************************************************
 * Timer_bIsElasped()
 * Description: check if timer is elapsed.
 *
 * Inputs:      None
 *
 * Return:      boolean
*******************************************************************************/
bool_t Timer_bIsElasped(uint64_t u64TimerStart, uint64_t u64TimePeriod)
{
    bool_t bReturn = false;

    if ((u64TimerTick1ms - u64TimerStart) >= u64TimePeriod)
    {
        bReturn = true;
    }
    else
    {
        bReturn = false;
    }

    return bReturn;
}

/* End of file ****************************************************************/
