/*
 * PWM_Sync.c
 *
 *  Created on: Jul 14, 2025
 *      Author: uiv21045
 */
#include "pwm.h"
//#include "PWM_X.h"

__interrupt void Interrupt_CtrISRSync(void);

void vidInitPwmSyncConfig(void)
{
    /*-------ePWM7A/B-----------------*/
    //configure counter mode
    EPwm7Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;//TB_COUNT_UPDOWN;
    EPwm7Regs.TBCTL.bit.PHSEN = TB_DISABLE;
    EPwm7Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
    EPwm7Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;
    //EPwm7Regs.TBCTL.bit.SWFSYNC = 0u;

//    EPwm7Regs.EPWMSYNCINSEL.bit.SEL = 1;
    EPwm7Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;

    EPwm7Regs.TBCTL.bit.PRDLD = TB_SHADOW;          // set immediate load the active register
    //Period = 120M /Freq_PWM. Period100k = 120M/100K=1200 TBPRD = Period/2 +1 = 601;
    EPwm7Regs.TBPRD = PWM_PERIOD_140K;//PWM_PERIOD_100K;//PSFB_PEROID_NORMAL-1;
    EPwm7Regs.TBPHS.bit.TBPHS = 0u;
    EPwm7Regs.TBCTR = 0u;
    EPwm7Regs.CMPA.bit.CMPA = PWM_PERIOD_140K>>1;//PWM_PERIOD_100K/2;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%
    EPwm7Regs.CMPB.bit.CMPB = 300;//PWM_PERIOD_100K/4;
    //configure the shadow register, load CMP when CTR == 0
    EPwm7Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO_PRD;   //has no effect in immediate mode
    EPwm7Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwm7Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO_PRD;   //has no effect in immediate mode
    EPwm7Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    //configure action qualifier register
    EPwm7Regs.AQCTLA.bit.CAU = AQ_SET;              //output high level when TBTCR=CMPA rising edge
  //  EPwm7Regs.AQCTLA.bit.CAD = AQ_CLEAR;            //output low level when TBTCR=CMPA falling edge
    EPwm7Regs.AQCTLA.bit.PRD = AQ_CLEAR;            //output low level when TBTCR=CMPA rising dege
  //  EPwm7Regs.AQCTLB.bit.CAD = AQ_SET;              //output high level when TBCTR=CMPA falling edge

    //configure dead band register
    EPwm7Regs.DBCTL.bit.IN_MODE = DBA_ALL;
    EPwm7Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
    EPwm7Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm7Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay
    EPwm7Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay

//    HWREG(PIEVECTTABLE_BASE + ((INT_EPWM7 >> 16U) * 2U)) = (uint32_t)Interrupt_CtrISRSync;

    EPwm7Regs.ETSEL.bit.INTEN = 0u;             //enable PWM interrupt
    EPwm7Regs.ETSEL.bit.INTSEL = ET_CTRU_CMPA;//ET_CTR_PRDZERO;//ET_CTR_PRD;    //trigger interrupt at CTR=PRD
//    EPwm7Regs.ETSEL.bit.SOCAEN = 1u;            //enable SOC on A group
//    EPwm7Regs.ETSEL.bit.SOCASEL = ET_CTR_PRD;   //
//
//    EPwm7Regs.ETPS.bit.SOCAPRD = ET_1ST;
    EPwm7Regs.ETPS.bit.INTPRD = ET_1ST;         //generate INT on 2nd event
    EPwm7Regs.ETSEL.bit.INTEN = 1u;
}

volatile int16_t testSubState = 1;
volatile int16_t subStateFlag1 = 0;
volatile int16_t subStateFlag2 = 0;
volatile int16_t subStateFlag3 = 0;
volatile int16_t subStateFlag4 = 0;
volatile int16_t subStateFlag5 = 0;
volatile int16_t subStateFlag6 = 0;
volatile int16_t subStateFlag7 = 0;
volatile int16_t subStateFlag8 = 0;
volatile int16_t subStateFlag9 = 0;
volatile int16_t startedFlag = 0;

#define OPENLOOP 0
//#pragma CODE_SECTION(Interrupt_CtrISRSync, ".TI.ramfunc");
__interrupt void Interrupt_CtrISRSync(void)
{
    volatile static int16_t i = 0;
    volatile static int16_t delay = 0;
    Uint16 cmpaL;
    Uint16 cmpbL;
    Uint16 cmpaR;
    Uint16 cmpbR;

    Uint16 cmpaSL;
    Uint16 cmpbSL;
    Uint16 cmpaSR;
    Uint16 cmpbSR;

    cmpaL = (EPwm2Regs.TBPRD>>1) - 10;
    cmpbL = 10;
    cmpaR = (EPwm2Regs.TBPRD>>1) - 10;
    cmpbR = 10;

//    cmpaL = PWM_Output.PWM_P1_CMPA*EPwm2Regs.TBPRD;
//    cmpbL = PWM_Output.PWM_P1_CMPB*EPwm2Regs.TBPRD;
//    cmpaR = PWM_Output.PWM_P2_CMPA*EPwm2Regs.TBPRD;
//    cmpbR = PWM_Output.PWM_P2_CMPB*EPwm2Regs.TBPRD;

//    cmpaSL = PWM_Output.PWM_S1_CMPA*EPwm2Regs.TBPRD;
//    cmpbSL = PWM_Output.PWM_S1_CMPB*EPwm2Regs.TBPRD;
//    cmpaSR = PWM_Output.PWM_S2_CMPA*EPwm2Regs.TBPRD;
//    cmpbSR = PWM_Output.PWM_S2_CMPB*EPwm2Regs.TBPRD;


    EPwm6Regs.CMPB.bit.CMPB = cmpbSL;
    EPwm6Regs.CMPA.bit.CMPA = cmpaSL;

    EPwm8Regs.CMPB.bit.CMPB = cmpbSR;
    EPwm8Regs.CMPA.bit.CMPA = cmpaSR;


    delay++;
 //   delay =0 ;
    if((delay>=100) &&(startedFlag ==0))
    {
        EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x00;//0x02

        EPwm2Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x00;//0x02


        EPwm4Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x00;//0x02

        EPwm5Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x00;//0x02

        EPwm6Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm6Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm6Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm6Regs.AQCSFRC.bit.CSFB = 0x00;//0x02

        EPwm8Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm8Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm8Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm8Regs.AQCSFRC.bit.CSFB = 0x00;//0x02


        EALLOW;
        // Enable TBCLK after EPWM Initialization
        CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1u;
   //     CpuSysRegs.PCLKCR0.bit.GTBCLKSYNC = 1u;
//        EPwm1Regs.TBCTL.bit.SWFSYNC = 1u;
//        EPwm7Regs.ETSEL.bit.INTEN = 1u;
        EDIS;

        startedFlag = 1;
        delay = 0;
    }

    if(i++%20==0)
    {
        testSubState++;
    }
    if(testSubState >6)
    {
        testSubState = 1;
    }

#if 1
    if((testSubState == 1) && (subStateFlag1 == 0))//Q1/Q3 ON, Q2/Q4 complimentary 70%
    {
        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;

        EPwm2Regs.TBPHS.bit.TBPHS = 0;
        EPwm5Regs.TBPHS.bit.TBPHS = 0;

        EPwm1Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm1Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm4Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm4Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm2Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm2Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm5Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm5Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm4Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm2Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x00;//0x02

        EPwm5Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x01;//0x02
        EPwm5Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC//2
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;

        EPwm2Regs.CMPB.bit.CMPB = cmpbL;
        EPwm2Regs.CMPA.bit.CMPA = cmpaL;

        EPwm5Regs.CMPB.bit.CMPB = cmpbR;
        EPwm5Regs.CMPA.bit.CMPA = cmpaR;

        subStateFlag1 = 1;
        subStateFlag2 = 0;
        subStateFlag3 = 0;
        subStateFlag4 = 0;
        subStateFlag5 = 0;
        subStateFlag6 = 0;
    }
    else if ((testSubState == 2) && (subStateFlag2 == 0))
    {
        EPwm1Regs.CMPB.bit.CMPB = 0;
        EPwm2Regs.CMPB.bit.CMPB = 0;
        EPwm5Regs.CMPB.bit.CMPB = 0;

        EPwm1Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm1Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm4Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm4Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm2Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm2Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm5Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm5Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm2Regs.TBPHS.bit.TBPHS = EPwm2Regs.TBPRD - PWM_PRIMARY_PHS_DLY;
        EPwm5Regs.TBPHS.bit.TBPHS = EPwm5Regs.TBPRD - PWM_PRIMARY_PHS_DLY;

        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;
        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm4Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm2Regs.DBCTL.bit.OUT_MODE = 0;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x01;//0x02
        EPwm2Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC

        EPwm5Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

        subStateFlag1 = 0;
        subStateFlag2 = 1;
        subStateFlag3 = 0;
        subStateFlag4 = 0;
        subStateFlag5 = 0;
        subStateFlag6 = 0;
    }
    else if ((testSubState == 3)&&(subStateFlag3 == 0))
    {
        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;

        EPwm2Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm5Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x01;//0x02
        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC

        EPwm4Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 0;//3
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

        subStateFlag1 = 0;
        subStateFlag2 = 0;
        subStateFlag3 = 1;
        subStateFlag4 = 0;
        subStateFlag5 = 0;
        subStateFlag6 = 0;
    }
    else if ((testSubState == 4)&&(subStateFlag4 == 0))
    {
        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;
        EPwm2Regs.TBPHS.bit.TBPHS = 0;
        EPwm5Regs.TBPHS.bit.TBPHS = 0;

        EPwm1Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm1Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm4Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm4Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm2Regs.TBPHS.bit.TBPHS = 0;
        EPwm2Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm2Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm5Regs.TBPHS.bit.TBPHS = 0;
        EPwm5Regs.DBFED.bit.DBFED = 20u;         //falling edge time delay
        EPwm5Regs.DBRED.bit.DBRED = 20u;         //rising edge time delay

        EPwm2Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm5Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x0;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x0;//0x02

        EPwm4Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x0;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x0;//0x02

        EPwm1Regs.CMPB.bit.CMPB = cmpbL;
        EPwm1Regs.CMPA.bit.CMPA = cmpaL;

        EPwm4Regs.CMPB.bit.CMPB = cmpbR;
        EPwm4Regs.CMPA.bit.CMPA = cmpaR;

        subStateFlag1 = 0;
        subStateFlag2 = 0;
        subStateFlag3 = 0;
        subStateFlag4 = 1;
        subStateFlag5 = 0;
        subStateFlag6 = 0;
    }

    else if ((testSubState == 5)&&(subStateFlag5 == 0))
    {
        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;

        EPwm1Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm1Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay
        EPwm4Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm4Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm2Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm2Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 0;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x01;//0x02
//        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
//        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;

        EPwm4Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

        EPwm2Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm5Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 0;
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        subStateFlag1 = 0;
        subStateFlag2 = 0;
        subStateFlag3 = 0;
        subStateFlag4 = 0;
        subStateFlag5 = 1;
        subStateFlag6 = 0;

        EPwm1Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm1Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay
        EPwm4Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm4Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay

        EPwm2Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm2Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay
        EPwm2Regs.TBPHS.bit.TBPHS = PWM_PRIMARY_PHS_DLY;

        EPwm5Regs.DBFED.bit.DBFED = 0u;         //falling edge time delay
        EPwm5Regs.DBRED.bit.DBRED = 0u;         //rising edge time delay
        EPwm5Regs.TBPHS.bit.TBPHS = PWM_PRIMARY_PHS_DLY;

    }
    else if ((testSubState == 6)&&(subStateFlag6 == 0))
    {
        GpioDataRegs.GPATOGGLE.bit.GPIO25 = 1u;
        EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm1Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm1Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm4Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm4Regs.DBCTL.bit.OUT_MODE = 0;//3
        EPwm4Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
        EPwm4Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

        EPwm2Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
        EPwm2Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm2Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

        EPwm5Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
        EPwm5Regs.DBCTL.bit.OUT_MODE = 3;//3
        EPwm5Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
        EPwm5Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

        subStateFlag1 = 0;
        subStateFlag2 = 0;
        subStateFlag3 = 0;
        subStateFlag4 = 0;
        subStateFlag5 = 0;
        subStateFlag6 = 1;

    }
#endif

#if 0

    if(testFlag == 0xFF)
    {

                GpioDataRegs.GPASET.bit.GPIO25 = 1u;
//                EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_DOWN;//TB_COUNT_UP
//
////                EPwm1Regs.CMPA.bit.CMPA = 0;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%
////                 EPwm1Regs.CMPB.bit.CMPB = EPwm1Regs.CMPA.bit.CMPA + 300;//EPwm1Regs.CMPA.bit.CMPA - 10
//
//        //        EPwm1Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;
////                EPwm1Regs.DBCTL.bit.IN_MODE = 0;
                EPwm1Regs.DBCTL.bit.POLSEL = 0;//DB_ACTV_HIC
                EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
////                EPwm1Regs.DBCTL.bit.OUTSWAP = 0;
                EPwm1Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
                EPwm1Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

//                EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;              //output high level when TBCTR=0
//                EPwm1Regs.AQCTLA.bit.CBU = AQ_SET;            //output low level when TBTCR=CMPA

                testFlag = 0;

    }
    else if(testFlag == 1)
    {

                GpioDataRegs.GPACLEAR.bit.GPIO25 = 1u;
//                EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;//
//
////                EPwm1Regs.CMPA.bit.CMPA = 10;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%
////                 EPwm1Regs.CMPB.bit.CMPB = EPwm1Regs.CMPA.bit.CMPA + 200;//EPwm1Regs.CMPA.bit.CMPA - 10
//
//        //        EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
////                EPwm1Regs.DBCTL.bit.IN_MODE = 0;
                EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
                EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
//////                EPwm1Regs.DBCTL.bit.OUTSWAP = 0;
                EPwm1Regs.AQCSFRC.bit.CSFA = 0x00;
                EPwm1Regs.AQCSFRC.bit.CSFB = 0x00;
//                EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;              //output high level when TBCTR=0
//                EPwm1Regs.AQCTLA.bit.CBU = AQ_CLEAR;            //output low level when TBTCR=CMPA


                testFlag = 0;

    }
#endif

    //
    // A non-maskable interrupt has occurred, indicating that a hardware error
    // has occurred in the system.  You can use SysCtl_getNMIFlagStatus() to
    // to read the NMIFLG register and determine what caused the NMI.
    //
//    Timer_SystemTick(); //1ms timer increase
//    Control_InputDetect();
//    GpioDataRegs.GPACLEAR.bit.GPIO21 = 1u;
/*---
 *
 * --------------test for the PWM  openloop--------------*/
#if OPENLOOP
    {
    Device_ReloadPWM_Period_duty(1u, u16PWMGrope[0].u16Pweiod, u16PWMGrope[0].u16Duty);
    Device_ReloadPWM_Period_duty(2u, u16PWMGrope[1].u16Pweiod, u16PWMGrope[1].u16Duty);
    Device_ReloadPWM_Period_duty(3u, u16PWMGrope[2].u16Pweiod, u16PWMGrope[2].u16Duty);
    Device_ReloadPWM_Period_duty(4u, u16PWMGrope[3].u16Pweiod, u16PWMGrope[3].u16Duty);
    Device_ReloadPWM_Period_duty(5u, u16PWMGrope[4].u16Pweiod, u16PWMGrope[4].u16Duty);
    Device_ReloadPWM_Period_duty(7u, u16PWMGrope[5].u16Pweiod, u16PWMGrope[5].u16Duty);
    }
#endif
/*----------------end---------------*/
    EPwm7Regs.ETCLR.bit.INT = 1;// Clear the ePWM7_INT flag to enable further interrupts
    // Clear PIE acknowledge bit to enable this group interrupt
    PieCtrlRegs.PIEACK.all = INTERRUPT_ACK_GROUP3;    //clear PIE acknowledge bit to enable group intterupt
//    GpioDataRegs.GPASET.bit.GPIO20 = 1u;

}
