//#############################################################################
//
// FILE:   ipc_ex3_basic_sysconfig_c28x1.c
//
// TITLE: SysConfig IPC example with interrupt
//
//! \addtogroup driver_dual_example_list
//! <h1> IPC basic message passing example with interrupt </h1>
//!
//! This example demonstrates how to configure IPC and pass information from
//! C28x1 to C28x2 core without message queues.
//! It is recommended to run the C28x1 core first, followed by the C28x2 core.
//!
//! \note In the default CPU2 linker cmd file, GS4, FLASH_BANK3 and FLASH_BANK4
//! are used for allocating various CPU2 sections. The CPU1 application
//! assigns the ownership of these memory regions to CPU2 by using SysConfig.
//! Please note that CPU2 .out file can be loaded only after CPU1 completes
//! this configuration.
//!
//! The erase setting (CPU1/CPU2 On-Chip Flash -> erase setting) needs to be
//! configured as selected banks only (Choose the corresponding BANKS allocated
//! for CPUs) or necessary sectors only before loading CPU1/CPU2.out file
//! (This is applicable only for FLASH configuration)
//!
//! \b External \b Connections \n
//!  - None.
//!
//! \b Watch \b Variables \n
//!  - pass
//!
//
//#############################################################################
// 
// C2000Ware v5.04.00.00
//
// Copyright (C) 2024 Texas Instruments Incorporated - http://www.ti.com
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//
#include "driverlib.h"
#include "device.h"
#include "f28x_project.h"
#include "board.h"
#include "SigleCalculate.h"
#include "Buffer.h"
//#include "pwm.h"
//#include "PWM_X.h"

void CLA_runTest(void)
{
    fVal= 64.0f;
    CLA_forceTasks(CLA1_BASE,CLA_TASKFLAG_1);
    asm(" RPT #255 || NOP");

}


//
// Main
//
Uint32 cnt;
void main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();
    //
    // Disable pin locks and enable internal pull-ups.
    //
    Device_initGPIO();

    //
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    //
    Interrupt_initModule();

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    //
    Interrupt_initVectorTable();

    //
    // Initialize SysConfig Settings
    //
//    Board_init();

    //BootToCpu2Init();

//    Device_initCLA();
//    Device_initADC();
////    Device_initePWM();
//    Device_initeCMPSS();
    //debug pin on GPIO12

    GpioCtrlRegs.GPAPUD.bit.GPIO12 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 0u;       //normal GPIO
    GpioCtrlRegs.GPADIR.bit.GPIO12 = 1u;        //GPIO25 = output
    GpioDataRegs.GPASET.bit.GPIO12 = 1u;        //write prohibited

    GpioCtrlRegs.GPAPUD.bit.GPIO25 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAMUX2.bit.GPIO25 = 0u;       //normal GPIO
    GpioCtrlRegs.GPADIR.bit.GPIO25 = 1u;        //GPIO25 = output
    GpioDataRegs.GPASET.bit.GPIO25 = 1u;        //write prohibited

    EALLOW;
    // Disable TBCLK before EPWM Initialization
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0u;
//     CpuSysRegs.PCLKCR0.bit.GTBCLKSYNC = 0u;
    HWREGH(CLKCFG_BASE + SYSCTL_O_PERCLKDIVSEL) &= 0xFE;
    EDIS;

     vidInitPwmSyncConfig();
     vidInitPwmPrimaryBridge();
     vidInitPwmSecondaryBridge();


//     EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//     EPwm1Regs.DBCTL.bit.OUT_MODE = 3;
//     EPwm1Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
//     EPwm1Regs.AQCSFRC.bit.CSFB = 0x00;//0x02
//
//     EPwm2Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//     EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
//     EPwm2Regs.AQCSFRC.bit.CSFA = 0x00;//0x02;
//     EPwm2Regs.AQCSFRC.bit.CSFB = 0x00;//0x02
//
//     EALLOW;
//     // Enable TBCLK after EPWM Initialization
//     CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1u;
////     CpuSysRegs.PCLKCR0.bit.GTBCLKSYNC = 1u;
//     EPwm1Regs.TBCTL.bit.SWFSYNC = 1u;
     EPwm7Regs.ETSEL.bit.INTEN = 1u;
//     EDIS;

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;


    PWM_initialize();

    //Modulation1
//    PWM_Input.DucyRef = 0.5f;
//    PWM_Input.PhaShiftD1 = 0.0f;
//    PWM_Input.PhaShiftD12 = 0.0f;
//    PWM_Input.PhaShiftD2 = 0.0606f;
//    PWM_Input.PhaShiftD21 = 0.1824f;

//    //Modulation2b
//    PWM_Input.DucyRef = 0.5f;
//    PWM_Input.PhaShiftD1 = 0.0f;
//    PWM_Input.PhaShiftD12 = 0.0f;
//    PWM_Input.PhaShiftD2 = 0.1f;
//    PWM_Input.PhaShiftD21 = 0.15f;
//
//
//    PWM_step();
//    PWM_terminate();

    //test
    //Cpu1ToCpu2Buffer();
    //CLA_runTest();
    //
    // End of example. Loop forever
    //
    while(1)
    {
        cnt++;
    }
}
//
// End of File
//
