/*
 * PWM_Primary.c
 *
 *  Created on: Jul 11, 2025
 *      Author: uiv21045
 */
//
// Included Files
//
#include "pwm.h"
//#include "constants.h"

static void vidInitPwmPrimaryBridgeLeftIOConfig(void);
static void vidInitPwmPrimaryBridgeRightIOConfig(void);
static void vidInitPwmPrimaryBridgeLeftFuncConfig(void);
static void vidInitPwmPrimaryBridgeRightFuncConfig(void);

//*****************************************************************************
//
// Function to configure the ePWM.
//
//*****************************************************************************


void vidInitPwmPrimaryBridge(void)
{
    vidInitPwmPrimaryBridgeLeftIOConfig();
    vidInitPwmPrimaryBridgeLeftFuncConfig();

    vidInitPwmPrimaryBridgeRightIOConfig();
    vidInitPwmPrimaryBridgeRightFuncConfig();
}

//
// Enable PWM1 A,B on GPIO0,GPIO1
// Enable PWM2 A,B on GPIO2,GPIO3
//
static void vidInitPwmPrimaryBridgeLeftIOConfig(void)
{
    EALLOW;
    //
    // Enable PWM1A,B on GPIO0,GPIO1
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO0 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO0 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 1u;       // Configure GPIO0 as EPWM1A
    GpioCtrlRegs.GPAPUD.bit.GPIO1 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO1 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 1u;       // Configure GPIO1 as EPWM1B
    //
    // Enable PWM2A,B on GPIO2,GPIO3
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO2 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO2 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 1u;       // Configure GPIO2 as EPWM2A
    GpioCtrlRegs.GPAPUD.bit.GPIO3 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO3 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 1u;       // Configure GPIO3 as EPWM2B
    EDIS;
}

//
// Enable PWM4 A,B on GPIO6,GPIO7
// Enable PWM5 A,B on GPIO8,GPIO9
//
static void vidInitPwmPrimaryBridgeRightIOConfig(void)
{
    EALLOW;
    GpioCtrlRegs.GPAPUD.bit.GPIO6 = 1u;         // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO6 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 1u;       //Configure GPIO6 as EPWM4A
    GpioCtrlRegs.GPAPUD.bit.GPIO7 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO7 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 1u;       // Configure GPIO7 as EPWM4B
    //
    // Enable PWM5A,B on GPIO8,GPIO9
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO8 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO8 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 1u;       // Configure GPIO8 as EPWM5A
    GpioCtrlRegs.GPAPUD.bit.GPIO9 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO9 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO9= 1u;       // Configure GPIO9 as EPWM5B
    EDIS;
}

static void vidInitPwmPrimaryBridgeLeftFuncConfig(void)
{
    /*-------ePWM1A/B-----------------*/
      //configure counter mode
      EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;//
      EPwm1Regs.TBCTL.bit.PHSEN = TB_ENABLE;
      EPwm1Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
      EPwm1Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

  //    EPwm1Regs.TBCTL.bit.SWFSYNC = 0u;
//      EPwm1Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;
  //    EPwm1Regs.EPWMSYNCOUTEN.bit.SWEN = 0;
      EPwm1Regs.EPWMSYNCINSEL.bit.SEL = 7;

      EPwm1Regs.TBCTL.bit.PRDLD = TB_SHADOW;            // set SHADOW load
      //Period = 120M /Freq_PWM. Period100k = 120M/100K=1200 TBPRD = Period/2 +1 = 601;
      EPwm1Regs.TBPRD = PWM_PERIOD_140K;//PSFB_PEROID_NORMAL-1;
      EPwm1Regs.TBPHS.bit.TBPHS = 0u;
      EPwm1Regs.TBCTR = 0u;
      EPwm1Regs.CMPB.bit.CMPB = 0;//EPwm1Regs.CMPA.bit.CMPA - 10
      EPwm1Regs.CMPA.bit.CMPA = EPwm1Regs.CMPB.bit.CMPB + EPwm1Regs.TBPRD>>1;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%

//      EPwm1Regs.CMPB.bit.CMPB = 0.00249999994f*EPwm1Regs.TBPRD;//EPwm1Regs.CMPA.bit.CMPA - 10
//       EPwm1Regs.CMPA.bit.CMPA = 0.502499998f*EPwm1Regs.TBPRD;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%
//       EPwm1Regs.CMPB.bit.CMPB = 0;//EPwm1Regs.CMPA.bit.CMPA - 10
//        EPwm1Regs.CMPA.bit.CMPA = 0.5f*EPwm1Regs.TBPRD;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%




      //configure the shadow register, load CMP when CTR == 0
      EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
      EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
      EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
      EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
      //configure action qualifier register
      EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;              //output high level when TBCTR=0
      EPwm1Regs.AQCTLA.bit.CBU = AQ_SET;            //output low level when TBTCR=CMPA
  //    EPwm1Regs.AQCTLA.bit.CAD = AQ_SET;              //output high level when TBCTR=0
  //    EPwm1Regs.AQCTLA.bit.CBD = AQ_CLEAR;            //output low level when TBTCR=CMPA

      EPwm1Regs.AQSFRC.bit.RLDCSF = 1;//1
      //configure dead band register
      EPwm1Regs.DBCTL.bit.IN_MODE = 0;
//      EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//      EPwm1Regs.DBCTL.bit.OUT_MODE = 3;//3
//      EPwm1Regs.DBCTL.bit.OUTSWAP = 0;
      EPwm1Regs.DBCTL.bit.SHDWDBREDMODE = 1;         //rising edge time delay
      EPwm1Regs.DBCTL.bit.SHDWDBFEDMODE = 1;         //falling edge time delay
      EPwm1Regs.DBRED.bit.DBRED = PWM_PRIMARY_DBRED;         //rising edge time delay
      EPwm1Regs.DBFED.bit.DBFED = PWM_PRIMARY_DBFED;         //falling edge time delay


      EPwm1Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
      EPwm1Regs.DBCTL.bit.OUT_MODE = 0;
      EPwm1Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
      EPwm1Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

//      EPwm1Regs.ETSEL.bit.INTEN = 0u;             //enable PWM interrupt
//      EPwm1Regs.ETSEL.bit.INTSEL = ET_CTRU_CMPA;//ET_CTR_PRDZERO;//ET_CTR_PRD;    //trigger interrupt at CTR=PRD
//   //    EPwm7Regs.ETSEL.bit.SOCAEN = 1u;            //enable SOC on A group
//   //    EPwm7Regs.ETSEL.bit.SOCASEL = ET_CTR_PRD;   //
//   //
//   //    EPwm7Regs.ETPS.bit.SOCAPRD = ET_1ST;
//      EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;         //generate INT on 2nd event
//      EPwm1Regs.ETSEL.bit.INTEN = 1u;


      EPwm1Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;//1
      EPwm1Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;//0

      /*-------ePWM2A/B-----------------*/
      //configure counter mode
      EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;
      EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;
      EPwm2Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
      EPwm2Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

      EPwm2Regs.TBCTL.bit.PHSDIR = 0;

  //    EPwm2Regs.TBCTL.bit.SWFSYNC = 0u;
//      EPwm2Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;
      EPwm2Regs.EPWMSYNCINSEL.bit.SEL = 7;

      EPwm2Regs.TBCTL.bit.PRDLD = TB_SHADOW;            // set SHADOW load
      //Period = 120M /Freq_PWM. Period100k = 120M/100K=1200 TBPRD = Period/2 +1 = 601;
      EPwm2Regs.TBPRD = PWM_PERIOD_140K;//PSFB_PEROID_NORMAL-1;
      EPwm2Regs.TBPHS.bit.TBPHS = 0;
      EPwm2Regs.TBCTR = 0;

      EPwm2Regs.CMPB.bit.CMPB = 0;//EPwm1Regs.CMPA.bit.CMPA - 10
      EPwm2Regs.CMPA.bit.CMPA = EPwm2Regs.CMPB.bit.CMPB + EPwm2Regs.TBPRD>>1;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%

  //    EPwm2Regs.CMPB.bit.CMPB = PWM_PERIOD_100K>>1;
  //    EPwm2Regs.CMPA.bit.CMPA = EPwm2Regs.CMPB.bit.CMPB;//EPwm2Regs.CMPB.bit.CMPB -10;              // Fix duty at 50%

      //configure the shadow register, load CMP when CTR == 0
      EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
      EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
      EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
      EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
      //configure action qualifier register
  //    EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;              //output high level when TBCTR=0
  //    EPwm2Regs.AQCTLA.bit.CAD = AQ_SET;            //output low level when TBTCR=CMPA

      EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;              //output high level when TBCTR=0
      EPwm2Regs.AQCTLA.bit.CBU = AQ_CLEAR;            //output low level when TBTCR=CMPA

      //configure dead band register

      EPwm2Regs.AQSFRC.bit.RLDCSF = 1;//1
      //configure dead band register
      EPwm2Regs.DBCTL.bit.IN_MODE = 0;
//      EPwm2Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//      EPwm2Regs.DBCTL.bit.OUT_MODE = 3;
//      EPwm2Regs.DBCTL.bit.OUTSWAP = 0;
      EPwm2Regs.DBCTL.bit.SHDWDBREDMODE = 1;         //rising edge time delay
      EPwm2Regs.DBCTL.bit.SHDWDBFEDMODE = 1;         //falling edge time delay

      EPwm2Regs.DBRED.bit.DBRED = PWM_PRIMARY_DBRED;         //rising edge time delay
      EPwm2Regs.DBFED.bit.DBFED = PWM_PRIMARY_DBFED;         //falling edge time delay

      EPwm2Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
      EPwm2Regs.DBCTL.bit.OUT_MODE = 0;
      EPwm2Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
      EPwm2Regs.AQCSFRC.bit.CSFB = 0x01;//0x02


      EPwm2Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;
      EPwm2Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;//0
}


static void vidInitPwmPrimaryBridgeRightFuncConfig(void)
{
    /*-------ePWM4A/B-----------------*/
     //configure counter mode
     EPwm4Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;
     EPwm4Regs.TBCTL.bit.PHSEN = TB_ENABLE;
     EPwm4Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
     EPwm4Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

//     EPwm4Regs.TBCTL.bit.SWFSYNC = 0u;
     EPwm4Regs.EPWMSYNCINSEL.bit.SEL = 7;
//     EPwm4Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;

     EPwm4Regs.TBCTL.bit.PRDLD = TB_SHADOW;            // set SHADOW load
     //Period = 120M /Freq_PWM. Period100k = 120M/100K=1200 TBPRD = Period/2 +1 = 601;
     EPwm4Regs.TBPRD = PWM_PERIOD_140K;//PSFB_PEROID_NORMAL-1;
     EPwm4Regs.TBPHS.bit.TBPHS = 0u;
     EPwm4Regs.TBCTR = 0u;

     EPwm4Regs.CMPB.bit.CMPB = 0;//EPwm1Regs.CMPA.bit.CMPA - 10
     EPwm4Regs.CMPA.bit.CMPA = EPwm4Regs.CMPB.bit.CMPB + EPwm4Regs.TBPRD>>1;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%

     //configure the shadow register, load CMP when CTR == 0
     EPwm4Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
     EPwm4Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
     EPwm4Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
     EPwm4Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;

     //configure action qualifier register
     EPwm4Regs.AQCTLA.bit.CAU = AQ_SET;              //output high level when TBCTR=0
     EPwm4Regs.AQCTLA.bit.CBU = AQ_CLEAR;            //output low level when TBTCR=CMPA

     //configure dead band register

     EPwm4Regs.AQSFRC.bit.RLDCSF = 1;//1
     //configure dead band register
     EPwm4Regs.DBCTL.bit.IN_MODE = 0;
//     EPwm4Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//     EPwm4Regs.DBCTL.bit.OUT_MODE = 3;
//     EPwm4Regs.DBCTL.bit.OUTSWAP = 0;
     EPwm4Regs.DBRED.bit.DBRED = PWM_PRIMARY_DBRED;         //rising edge time delay
     EPwm4Regs.DBFED.bit.DBFED = PWM_PRIMARY_DBFED;         //falling edge time delay

     EPwm4Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
     EPwm4Regs.DBCTL.bit.OUT_MODE = 0;
     EPwm4Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
     EPwm4Regs.AQCSFRC.bit.CSFB = 0x01;//0x02


     EPwm4Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;
     EPwm4Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;


     /*-------ePWM5A/B-----------------*/
//     configure counter mode
     EPwm5Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;
     EPwm5Regs.TBCTL.bit.PHSEN = TB_ENABLE;
     EPwm5Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
     EPwm5Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

//     EPwm5Regs.TBCTL.bit.SWFSYNC = 0u;
//     EPwm5Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;
     EPwm5Regs.EPWMSYNCINSEL.bit.SEL = 7;

     EPwm5Regs.TBCTL.bit.PRDLD = TB_SHADOW;            // set SHADOW load
     //Period = 120M /Freq_PWM. Period100k = 120M/100K=1200 TBPRD = Period/2 +1 = 601;
     EPwm5Regs.TBPRD = PWM_PERIOD_140K;//PSFB_PEROID_NORMAL-1;
     EPwm5Regs.TBPHS.bit.TBPHS = 0u;
     EPwm5Regs.TBCTR = 0u;

     EPwm5Regs.CMPB.bit.CMPB = 0;//EPwm1Regs.CMPA.bit.CMPA - 10
     EPwm5Regs.CMPA.bit.CMPA = EPwm5Regs.CMPB.bit.CMPB + EPwm5Regs.TBPRD>>1;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%
//     EPwm5Regs.CMPB.bit.CMPB = 0.00249999994f*EPwm5Regs.TBPRD;//EPwm1Regs.CMPA.bit.CMPA - 10
//     EPwm5Regs.CMPA.bit.CMPA = 0.502499998f*EPwm5Regs.TBPRD;//(PSFB_PEROID_NORMAL-1)>>1;              // Fix duty at 50%



     //configure the shadow register, load CMP when CTR == 0
     EPwm5Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
     EPwm5Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
     EPwm5Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
     EPwm5Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;

     //configure action qualifier register
     EPwm5Regs.AQCTLA.bit.CAU = AQ_CLEAR;              //output high level when TBCTR=0AQ_CLEAR
     EPwm5Regs.AQCTLA.bit.CBU = AQ_SET;            //output low level when TBTCR=CMPA

     //configure dead band register
     EPwm5Regs.AQSFRC.bit.RLDCSF = 1;//1
     //configure dead band register
     EPwm5Regs.DBCTL.bit.IN_MODE = 0;
//     EPwm5Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//     EPwm5Regs.DBCTL.bit.OUT_MODE = 3;
//     EPwm5Regs.DBCTL.bit.OUTSWAP = 0;
//     EPwm5Regs.DBRED.bit.DBRED = PWM_PRIMARY_DBRED;         //rising edge time delay
//     EPwm5Regs.DBFED.bit.DBFED = PWM_PRIMARY_DBFED;         //falling edge time delay

     EPwm5Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
     EPwm5Regs.DBCTL.bit.OUT_MODE = 0;
     EPwm5Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
     EPwm5Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

//     EPwm5Regs.AQCSFRC.bit.CSFA = 0x02;//0x02;
//     EPwm5Regs.AQCSFRC.bit.CSFB = 0x02;//0x02

     EPwm5Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;
     EPwm5Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;
}
