/*
 * PWM_Secondary.c
 *
 *  Created on: Jul 11, 2025
 *      Author: uiv21045
 */
//
// Included Files
//
#include "pwm.h"

static void vidInitPwmSecondaryIOConfig(void);
static void vidInitPwmSecondaryFuncConfig(void);

void vidInitPwmSecondaryBridge(void)
{
    vidInitPwmSecondaryIOConfig();
    vidInitPwmSecondaryFuncConfig();
}

//
// Enable PWM6 A,B on GPIO10,GPIO11
// Enable PWM8 A,B on GPIO99,GPIO75
//
static void vidInitPwmSecondaryIOConfig(void)
{
    EALLOW;
    //
    // Enable PWM6 A,B on GPIO10,GPIO11
    //
    GpioCtrlRegs.GPAPUD.bit.GPIO10 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO10 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 1u;       // Configure GPIO10 as EPWM6A
    GpioCtrlRegs.GPAPUD.bit.GPIO11 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPAGMUX1.bit.GPIO11 = 0u;
    GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 1u;       // Configure GPIO11 as EPWM6B
    //
    // Enable PWM8A,B on GPIO99,GPIO75
    //
    GpioCtrlRegs.GPDPUD.bit.GPIO99 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPDGMUX1.bit.GPIO99 = 0u;
    GpioCtrlRegs.GPDMUX1.bit.GPIO99 = 3u;       // Configure GPIO16 as EPWM8A
    GpioCtrlRegs.GPCPUD.bit.GPIO75 = 1u;        // Pull up disabled
    GpioCtrlRegs.GPCGMUX1.bit.GPIO75 = 0u;
    GpioCtrlRegs.GPCMUX1.bit.GPIO75= 1u;        // Configure GPIO35 as EPWM8B
    EDIS;
}

static void vidInitPwmSecondaryFuncConfig(void)
{
    /*-------ePWM6A/B-----------------*/
       //configure counter mode
       EPwm6Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;//
       EPwm6Regs.TBCTL.bit.PHSEN = TB_ENABLE;
       EPwm6Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
       EPwm6Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

//       EPwm6Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;
       EPwm6Regs.EPWMSYNCINSEL.bit.SEL = 7;//EPWM7_SYNCOUT

       EPwm6Regs.TBCTL.bit.PRDLD = TB_SHADOW;
       EPwm6Regs.TBPRD = PWM_PERIOD_140K;
       EPwm6Regs.TBPHS.bit.TBPHS = 0u;
       EPwm6Regs.TBCTR = 0u;
//       EPwm6Regs.CMPB.bit.CMPB = 0;//50% duty
//       EPwm6Regs.CMPA.bit.CMPA = EPwm6Regs.CMPB.bit.CMPB + EPwm6Regs.TBPRD>>1;


//       EPwm6Regs.CMPB.bit.CMPB = EPwm6Regs.TBPRD*0.182400003f;//50% duty
//       EPwm6Regs.CMPA.bit.CMPA = EPwm6Regs.TBPRD*0.682399988f;

       EPwm6Regs.CMPB.bit.CMPB = EPwm6Regs.TBPRD*0.0f;//50% duty
       EPwm6Regs.CMPA.bit.CMPA = EPwm6Regs.TBPRD*0.5f;

       EPwm6Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
       EPwm6Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
       EPwm6Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
       EPwm6Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
       //configure action qualifier register
       EPwm6Regs.AQCTLA.bit.CAU = AQ_CLEAR;              //output high level when TBCTR=0
       EPwm6Regs.AQCTLA.bit.CBU = AQ_SET;            //output low level when TBTCR=CMPA

       EPwm6Regs.AQSFRC.bit.RLDCSF = 1;
       //configure dead band register
       EPwm6Regs.DBCTL.bit.IN_MODE = 0;
//       EPwm6Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//       EPwm6Regs.DBCTL.bit.OUT_MODE = 3;
//       EPwm6Regs.DBCTL.bit.OUTSWAP = 0;
       EPwm6Regs.DBRED.bit.DBRED = PWM_SECONDARY_DBRED;         //rising edge time delay
       EPwm6Regs.DBFED.bit.DBFED = PWM_SECONDARY_DBFED;         //falling edge time delay

       EPwm6Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
       EPwm6Regs.DBCTL.bit.OUT_MODE = 0;
       EPwm6Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
       EPwm6Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

       EPwm6Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;
       EPwm6Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;

       /*-------ePWM8A/B-----------------*/
       //configure counter mode
       EPwm8Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;
       EPwm8Regs.TBCTL.bit.PHSEN = TB_ENABLE;
       EPwm8Regs.TBCTL.bit.HSPCLKDIV = EPWM_HSCLOCK_DIVIDER_1;
       EPwm8Regs.TBCTL.bit.CLKDIV = EPWM_CLOCK_DIVIDER_1;

       EPwm8Regs.TBCTL.bit.PHSDIR = 0;

//       EPwm8Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;
       EPwm8Regs.EPWMSYNCINSEL.bit.SEL = 7;//EPWM7_SYNCOUT

       EPwm8Regs.TBCTL.bit.PRDLD = TB_SHADOW;  // set SHADO Wload
       EPwm8Regs.TBPRD = PWM_PERIOD_140K;
       EPwm8Regs.TBPHS.bit.TBPHS = 0;
       EPwm8Regs.TBCTR = 0;

//       EPwm8Regs.CMPB.bit.CMPB = 0;//50% duty
//       EPwm8Regs.CMPA.bit.CMPA = EPwm8Regs.CMPB.bit.CMPB + EPwm8Regs.TBPRD>>1;
//       EPwm8Regs.CMPB.bit.CMPB = EPwm8Regs.TBPRD*0.243000001f;//50% duty
//       EPwm8Regs.CMPA.bit.CMPA = EPwm8Regs.TBPRD*0.743000031f;

       EPwm8Regs.CMPB.bit.CMPB = EPwm8Regs.TBPRD*0.3389f;//50% duty
       EPwm8Regs.CMPA.bit.CMPA = EPwm8Regs.TBPRD*0.83889997f;


       //configure the shadow register, load CMP when CTR == 0
       EPwm8Regs.CMPCTL.bit.LOADAMODE = CC_CTR_PRD;
       EPwm8Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
       EPwm8Regs.CMPCTL.bit.LOADBMODE = CC_CTR_PRD;
       EPwm8Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;

       EPwm8Regs.AQCTLA.bit.CAU = AQ_CLEAR;
       EPwm8Regs.AQCTLA.bit.CBU = AQ_SET;

       //configure dead band register
       EPwm8Regs.AQSFRC.bit.RLDCSF = 1;
       //configure dead band register
       EPwm8Regs.DBCTL.bit.IN_MODE = 0;
//       EPwm8Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
//       EPwm8Regs.DBCTL.bit.OUT_MODE = 3;
//       EPwm8Regs.DBCTL.bit.OUTSWAP = 0;
       EPwm8Regs.DBRED.bit.DBRED = PWM_SECONDARY_DBRED;         //rising edge time delay
       EPwm8Regs.DBFED.bit.DBFED = PWM_SECONDARY_DBFED;         //falling edge time delay

       EPwm8Regs.DBCTL.bit.POLSEL = 2;//DB_ACTV_HIC
       EPwm8Regs.DBCTL.bit.OUT_MODE = 0;
       EPwm8Regs.AQCSFRC.bit.CSFA = 0x01;//0x02;
       EPwm8Regs.AQCSFRC.bit.CSFB = 0x01;//0x02

       EPwm8Regs.DBCTL2.bit.SHDWDBCTLMODE = 1u;
       EPwm8Regs.DBCTL2.bit.LOADDBCTLMODE = 1u;
}
