#include "F2837xD_Device.h"
#include "SFO_V8.h"

#define CPU_RATE 5.556L // 180MHz SYSCLK
#define DELAY_US(A)  F28x_usDelay((long)((((long double) A * 1000.0L) / (long double)CPU_RATE) - 9.0L) / 5.0L)
void F28x_usDelay(long cycle);

int MEP_ScaleFactor = 0;
volatile struct EPWM_REGS *ePWM[] = {0, &EPwm1Regs, &EPwm8Regs};

__attribute__((ramfunc)) void initFlash(void) {
	__eallow();
	Flash0CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 0;
	Flash0CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 0;
	Flash0CtrlRegs.FRDCNTL.bit.RWAIT = 0x3; // 180MHz SYSCLK
	Flash0CtrlRegs.FRD_INTF_CTRL.bit.DATA_CACHE_EN = 1;
	Flash0CtrlRegs.FRD_INTF_CTRL.bit.PREFETCH_EN = 1;
	Flash0EccRegs.ECC_ENABLE.bit.ENABLE = 0x0;
	__edis();
	__asm(" RPT #7 || NOP");
}

void initClock(void) {
	__eallow();

	ClkCfgRegs.CLKSRCCTL1.bit.INTOSC2OFF = 0;
	ClkCfgRegs.CLKSRCCTL1.bit.OSCCLKSRCSEL = 0;
	ClkCfgRegs.CLKSRCCTL1.bit.XTALOFF = 1;
	ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 0;
	__asm(" RPT #20 || NOP");

	ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 0;
	{
		int i;
		for (i = 0; i < 5; i++) {
			ClkCfgRegs.SYSPLLCTL1.bit.PLLEN = 0;
			__asm(" RPT #20 || NOP");
			ClkCfgRegs.SYSPLLMULT.all = 36;
			while (ClkCfgRegs.SYSPLLSTS.bit.LOCKS != 1);
		}
	}
	ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 2;

	{
		if (DevCfgRegs.SYSDBGCTL.bit.BIT_0 == 1) {
				ESTOP0;
			}
			Uint16 oldScsr = WdRegs.SCSR.all;
			Uint16 oldWdcr = WdRegs.WDCR.all;
			Uint16 oldWdwcr = WdRegs.WDWCR.all;

			WdRegs.WDWCR.all = 0x0;
			WdRegs.WDKEY.bit.WDKEY = 0x55;
			WdRegs.WDKEY.bit.WDKEY = 0xAA;
			WdRegs.SCSR.all = 0x0;
			WdRegs.WDCR.all = 0x28;

			DevCfgRegs.SYSDBGCTL.bit.BIT_0 = 1;
			ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 1;
			__asm(" RPT #20 || NOP");
			DevCfgRegs.SYSDBGCTL.bit.BIT_0 = 0;

			WdRegs.WDKEY.bit.WDKEY = 0x55;
			WdRegs.WDKEY.bit.WDKEY = 0xAA;
			oldWdcr |= 0x28;
			WdRegs.WDCR.all = oldWdcr;
			WdRegs.WDWCR.all = oldWdwcr;
			WdRegs.SCSR.all = oldScsr & 0xFFFE;
	}

	__asm(" RPT #200 || NOP");
	ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 1;

	__edis();
}

void main(void) {
	__disable_interrupts();
	initFlash();
	initClock();

	__eallow();
	ClkCfgRegs.PERCLKDIVSEL.bit.EPWMCLKDIV = 1;
	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
	CpuSysRegs.PCLKCR2.bit.EPWM1 = 1;
	CpuSysRegs.PCLKCR2.bit.EPWM8 = 1;
	CpuSysRegs.PCLKCR0.bit.HRPWM = 1;

	EPwm8Regs.TBCTL.bit.CLKDIV = TB_DIV1;
	EPwm8Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;
	EPwm8Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;
	EPwm8Regs.TBCTL.bit.PRDLD = TB_SHADOW;
	EPwm8Regs.TBCTL.bit.PHSEN = TB_ENABLE;

	EPwm8Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO_PRD;
	EPwm8Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
	EPwm8Regs.AQCTLA.bit.CAD = AQ_SET;
	EPwm8Regs.AQCTLA.bit.CAU = AQ_CLEAR;
	EPwm8Regs.TBPRD = 180;
	EPwm8Regs.CMPA.all = 36;

	EPwm8Regs.HRCNFG.bit.EDGMODE = HR_BEP;
	EPwm8Regs.HRCNFG.bit.CTLMODE = HR_CMP;
	EPwm8Regs.HRCNFG.bit.HRLOAD = HR_CTR_ZERO_PRD;
	EPwm8Regs.HRCNFG.bit.AUTOCONV = 1;
	EPwm8Regs.HRPCTL.bit.HRPE = 1;
	EPwm8Regs.HRPCTL.bit.TBPHSHRLOADE = 1;

	CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
	EPwm8Regs.TBCTL.bit.SWFSYNC = 1;
	__edis();

	while (SFO() != SFO_COMPLETE);

	__eallow();
	GpioCtrlRegs.GPCDIR.bit.GPIO86 = 1;
	GpioCtrlRegs.GPCDIR.bit.GPIO87 = 1;
	GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 1;
	__edis();

	for (;;) {
		/* Pulse on GPIO86 when setting CMPA to small value */
		GpioDataRegs.GPCSET.bit.GPIO86 = 1;
		__asm(" RPT #50 || NOP");
		EPwm8Regs.CMPA.bit.CMPA = 36;
		GpioDataRegs.GPCCLEAR.bit.GPIO86 = 1;

		DELAY_US(8);
		while (EPwm8Regs.TBSTS.bit.CTRDIR != 1);

		/* Pulse on GPIO87 when setting CMPA to big value */
		GpioDataRegs.GPCSET.bit.GPIO87 = 1;
		__asm(" RPT #50 || NOP");
		EPwm8Regs.CMPA.bit.CMPA = 144;
		GpioDataRegs.GPCCLEAR.bit.GPIO87 = 1;

		DELAY_US(8);
		while (EPwm8Regs.TBSTS.bit.CTRDIR != 1);
	}
}
