classdef instaSPIN < matlab.System & coder.ExternalDependency ...
        & matlab.system.mixin.internal.SampleTime & matlab.system.mixin.Propagates...
        
   % instaSPIN
    
    %#codegen
    properties (Nontunable)        
                
    end
    
    properties(Nontunable, Logical)

    end
    
    
    properties (Constant, Hidden)
        SampleTime = -1;
    end    
    
       
    methods
        % Constructor
        function obj = instaSPIN(varargin)
            %This would allow the code generation to proceed with the
            %p-files in the installed location of the support package.
            coder.allowpcode('plain');
            
            % Support name-value pair arguments when constructing the object.
            setProperties(obj,nargin,varargin{:});
        end
        
    end
    
    methods (Static, Access = protected)
        
        
        function simMode = getSimulateUsingImpl(~)
            simMode = 'Interpreted execution';
        end
        
        function isVisible = showSimulateUsingImpl
            isVisible = false;
        end
        
    end
    
    methods (Access = protected)
        function setupImpl(obj, ~)
            % Implement tasks that need to be performed only once,
            % such as pre-computed constants.
            coder.updateBuildInfo('addDefines','FAST_ROM_V1p6');
%             if ( coder.target('RtwForRapid') || coder.target('RtwForSfun') )
%                 %
%             elseif coder.target('Rtw')% done only for code gen
% %                 coder.cinclude('ctrl.h');
% %                 coder.cinclude('ctrl_obj.h');
%             end
            
        end
        
      
        function Out = stepImpl(obj, varargin)
            Out = int16(0);
            if ( coder.target('RtwForRapid') || coder.target('RtwForSfun') )
                %
            elseif coder.target('Rtw')% done only for code gen
                Out = coder.ceval('MW_instaSPIN');
            end
        end
        
        function inputname = getInputNamesImpl(~)
            inputname = 'In';
        end
        
        function InputPorts = getNumInputsImpl(~)
            InputPorts = 0;
        end
        
        function flag = isInputSizeLockedImpl(~,~)
            flag = true;
        end
        
        function flag = isInputComplexityLockedImpl(~,~)
            flag = true;
        end
        
        function c1 = isOutputComplexImpl(obj)
            c1 = false;
        end
        
        function flag = isOutputComplexityLockedImpl(~,~)
            flag = true;
        end
        
        function OutData = isOutputFixedSizeImpl(~)
            OutData = true;
        end
        
        function inputname = getOutputNamesImpl(~)
            inputname = 'Out';
        end
        
        function DataOut = getOutputDataTypeImpl(~)
            DataOut = 'int16';
        end
        
        function OutputPorts = getNumOutputsImpl(~)
            OutputPorts = 1;
        end
              
        function out = getOutputSizeImpl(~) 
            % Return size for each output port
            out = 1;
        end
        
        function stVal = getSampleTimeImpl(obj)
            stVal = obj.SampleTime;
        end
        
    end
    
    methods (Static)
        function name = getDescriptiveName()
            name = 'instaSPIN';
        end
        
        function b = isSupportedContext(context)
            b = context.isCodeGenTarget('rtw');
        end
        
        % Update the build-time buildInfo
        function updateBuildInfo(buildInfo, context)
            if context.isCodeGenTarget('rtw')
                % Include Paths
                addIncludePaths(buildInfo, fullfile('C:', 'ti','motorware','motorware_1_01_00_16'));
                addIncludePaths(buildInfo, fullfile('C:', 'ti','motorware','motorware_1_01_00_16','sw','modules','hal','boards','drv8312kit_revD','f28x','f2806x','src'));
                addIncludePaths(buildInfo, fullfile('C:', 'ti','motorware','motorware_1_01_00_16','sw','solutions','instaspin_motion','boards','drv8312kit_revD','f28x','f2806xM','src'));
                % Source Files
                srcFilePath = pwd;
                addSourceFiles(buildInfo, 'mw_instaspin.c', srcFilePath);
                buildInfo.addLinkObjects('2806xRevB_FastSpinROMSymbols_fpu32.lib',fullfile('C:','ti','motorware','motorware_1_01_00_16','sw','modules','fast','lib','32b','f28x','f2806x'),1000,true,true);
            end
        end
    end
end