//============================================================================
//============================================================================
//
// FILE:    Arduino_SPI.h
//
// TITLE:   Header file for Arduino SPI comm functions
//
// Version: 1.0
//
// Date:    27-10-2020
//
//============================================================================
//============================================================================

// Arduino SPI Input Data bit definitions:
struct  Arduino_SPI_WRITE_WORD_BITS {       // bit      description
   Uint16 DATA:11;                          // 10:0     FIFO reset
   Uint16 ADDRESS:4;                        // 14:11    Enhancement enable
   Uint16 R_W:1;                            // 15       R/W
};

union Arduino_SPI_WRITE_WORD_REG {
   Uint16                               all;
   struct Arduino_SPI_WRITE_WORD_BITS   bit;
};

// Arduino SPI Status Reister 1 bit definitions:
struct  Arduino_STATUS_REG_1_BITS {     // bit      description
   Uint16 EnableFlagArduino:1;          // 0        enable flag in (motor startup)
   Uint16 CurrentLimitArduino:1;        // 1        switch on current limit when in eco-mode
   Uint16 SpeedRefArduino:9;            // 2-10     modtag speedref fra arduino
   Uint16 Reserved:5;                   // 15:11
};

union Arduino_STATUS_REG_1 {
   Uint16                           all;
   struct Arduino_STATUS_REG_1_BITS bit;
};

// Arduino SPI Control Reister 1 bit definitions:
struct  Arduino_CONTROL_REG_1_BITS {    // bit      description
   Uint16 motorRPM:11; // 10:0 Send hastighed til Arduino
   Uint16 Reserved:5;                   // 15:11
};

union Arduino_CONTROL_REG_1 {
   Uint16                               all;
   struct Arduino_CONTROL_REG_1_BITS    bit;
};

/***************************************************************************************************/
//defines
/***************************************************************************************************/
//Arduino Register Addresses
#define Arduino_STAT_REG_1_ADDR     0x04
//#define Arduino_STAT_REG_2_ADDR     0x05
#define Arduino_CNTRL_REG_1_ADDR    0x05
//#define Arduino_CNTRL_REG_2_ADDR    0x07

/***************************************************************************************************/
//function prototypes
/***************************************************************************************************/
void Arduino_SPI_Init(volatile struct SPI_REGS *s);
Uint16 Arduino_SPI_Read(volatile struct SPI_REGS *s, Uint16 address);
Uint16 Arduino_SPI_Write(volatile struct SPI_REGS *s, Uint16 address, Uint16 data);

