/****************************************************************************************
 * Copyright:  	GoldenMaple Technologies (C) 2017
 * Project:		EECS X497.34 Course Project
 * File Name:	F2806x_Adc.h
 * Description:	F2806x Device ADC Register Definitions
 * Language:    TI TMS320F2806x C
 * Author:		Louis Zhu
 * Created:		9/15/2013
 * Notes:
 * Mod History: V1.0: Initial version developed on F28069ControlStick platform
 * 				V1.1: Modified for LaunchXL-F28069M LaunchPad
 ****************************************************************************************/

#ifndef F2806x_FLASH_H
#define F2806x_FLASH_H

#include "F2806x_Device.h"

//Macro definitions
#define RANDWAIT_INIT 	2			// Random access waitstates
#define PAGEWAIT_INIT   2			// Paged access waitstates
#define OTPWAIT_INIT 	4			// OTP waitstates

//The following variables are defined in TMS320F28069.cmd
//Note that there is no underscore prefix as they are used on C code
extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadEnd;
extern Uint16 RamfuncsLoadSize;
extern Uint16 RamfuncsRunStart;

// Flash Register Bit Definitions:

struct FOPT_BITS
{     						// bits description
	Uint16	ENPIPE:1;		// 0	Enable Pipeline Mode
	Uint16	rsvd1:15;		// 15:1	Reserved
};

union FOPT_REG
{
	Uint16 all;
	struct FOPT_BITS	bit;
};

struct FPWR_BITS
{     						// bits description
	Uint16	PWR:2;			// 1:0	Power Mode Bits
	Uint16	rsvd1:14;		// 15:2	Reserved
};

union FPWR_REG {
	Uint16 all;
	struct FPWR_BITS	bit;
};

struct FSTATUS_BITS
{     						// bits description
	Uint16	PWRS:2;			// 1:0	Power Mode Status Bits
	Uint16	STDBYWAITS:1;	// 2	Bank/Pump Sleep to Standby Wait Counter Status Bits
	Uint16	ACTIVEWAITS:1;	// 3	Bank/Pump Standby to Active Wait Counter Status Bits
	Uint16	rsvd1:4;		// 7:4	Reserved
	Uint16	V3STAT:1;		// 8	VDD3V Status Latch Bit
	Uint16	rsvd2:7;		// 15:9	Reserved
};

union FSTATUS_REG
{
	Uint16 all;
	struct FSTATUS_BITS	bit;
};

struct FSTDBYWAIT_BITS
{    						// bits description
	Uint16	STDBYWAIT:9;	// 8:0	Bank/Pump Sleep to Standby Wait Count Bits
	Uint16	rsvd1:7;		// 15:9	Reserved
};

union FSTDBYWAIT_REG
{
	Uint16 all;
	struct FSTDBYWAIT_BITS	bit;
};

struct FACTIVEWAIT_BITS
{   						// bits description
	Uint16	ACTIVEWAIT:9;	// 8:0	Bank/Pump Standby to Active Wait Count Bits
	Uint16	rsvd1:7;		// 15:9	Reserved
};

union FACTIVEWAIT_REG
{
	Uint16 all;
	struct FACTIVEWAIT_BITS	bit;
};

struct FBANKWAIT_BITS
{     						// bits description
	Uint16	RANDWAIT:4;		// 3:0	Flash Random Read Wait State Bits
	Uint16	rsvd1:4;		// 7:4	Reserved
	Uint16	PAGEWAIT:4;		// 11:8	Flash Paged Read Wait State Bits
	Uint16	rsvd2:4;		// 15:12	Reserved
};

union FBANKWAIT_REG
{
	Uint16 all;
	struct FBANKWAIT_BITS	bit;
};

struct FOTPWAIT_BITS
{     						// bits description
	Uint16	OTPWAIT:5;		// 4:0	OTP Read Wait State Bits
	Uint16	rsvd1:11;		// 15:5	Reserved
};

union FOTPWAIT_REG
{
	Uint16 all;
	struct FOTPWAIT_BITS	bit;
};

struct FLASH_REGS
{
	union	FOPT_REG		FOPT;			// Option Register
	Uint16					rsvd1;			// Reserved
	union	FPWR_REG		FPWR;			// Power Modes Register
	union	FSTATUS_REG		FSTATUS;		// Status Register
	union	FSTDBYWAIT_REG	FSTDBYWAIT;		// Pump/Bank Sleep to Standby Wait State Register
	union	FACTIVEWAIT_REG	FACTIVEWAIT;	// Pump/Bank Standby to Active Wait State Register
	union	FBANKWAIT_REG	FBANKWAIT;		// Bank Read Access Wait State Register
	union	FOTPWAIT_REG	FOTPWAIT;		// OTP Read Access Wait State Register
};

//FPWR power mode enum
enum tFpwrModeEnum
{
	FPWR_SLEEP_MODE = 0,	//pump and bank sleep mode
	FPWR_STANDBY_MODE,		//pump and bank standby mode
	Reserved,
	FPWR_ACTIVE_MODE		//pump and bank active mode
};


/*******************************************************************************************
 * Public function prototypes
 *******************************************************************************************/
void InitFlash(void);

#endif 
//===========================================================================
// End of file.
//===========================================================================
