;****************************************************************************************
;* Copyright:  	GoldenMaple Technologies (C) 2016
;* Project:		EECS X497.34 Course Project
;* File Name:	F2806x_Startup.asm
;* Description:	Startup code
;* Language:    TI TMS320F2806x C
;* Arthor:		Louis Zhu
;* Created:		12/20/2014
;* Special Notes:
;*     1 - _code_start is the first code that is executed after	exiting the boot ROM code
;* 	   2 - The codestart section in the linker cmd file is used to physically place
;* 		this code at the correct memory location.  This section should be placed 
;* 		at the location the BOOT ROM will re-direct the code to.  For example, 
;* 		for boot to FLASH this code will be located at 0x3f7ff6. 
;
;* 		In addition, the F2806x projects are setup such that the codegen
;* 		entry point is also set to the _code_start label.  This is done by linker 
;* 		option -e in the project build options.  When the debugger loads the code,
;* 		it will automatically set the PC to the "entry point" address indicated by
;* 		the -e linker option.  In this case the debugger is simply assigning the PC, 
;* 		it is not the same as a full reset of the device. 
;* 
;* 		The compiler may warn that the entry point for the project is other than
;* 		 _c_init00.  _c_init00 is the default C environment setup and is run before
;* 		main() is entered. The _code_start code will re-direct the execution 
;* 		to _c_init00 and thus there is no worry and this warning can be ignored. 
;
;* Mod History: V1.0: Initial version
;****************************************************************************************
 

;****************************************************************************
;* assemble options                                                         *
;****************************************************************************
WD_DISABLE	.set	1		;set to 1 to disable on-chip watchdog, else set to 0
                            

;****************************************************************************
;* external symbol reference                                                *
;****************************************************************************
	.ref _main, cinit
	.ref _c_int00

;****************************************************************************
;* Global symbol definition                                                 *
;****************************************************************************
    .def _code_start

;****************************************************************************
;* Declare the stack.  Size is determined by the linker option -stack.  The *
;* default value is 1K words.                                               *
;****************************************************************************
__stack:	.usect	".stack",0,0,1

;****************************************************************************
;*  INITIALIZE RESET VECTOR TO POINT AT _code_start                         *
;****************************************************************************
	.sect .reset
	.long _code_start

;***********************************************************************
;* Function: codestart section
;*
;* Description: Branch to code starting point
;***********************************************************************

    .sect ".codestart"

_code_start:
    .if WD_DISABLE == 1
        LB wd_disable       ;Branch to watchdog disable code
    .else
        LB _c_int00         ;Branch to _c_int00
    .endif

;end codestart section


;***********************************************************************
;* Function: wd_disable
;*
;* Description: Disables the watchdog timer
;***********************************************************************
    .if WD_DISABLE == 1

    .text
wd_disable:
    SETC OBJMODE        ;Set OBJMODE for 28x object code
    EALLOW              ;Enable EALLOW protected register access
    MOVZ DP, #7029h>>6  ;Set data page for WDCR register
    MOV @7029h, #0068h  ;Set WDDIS bit in WDCR to disable WD
    EDIS                ;Disable EALLOW protected register access
    LB _c_int00         ;Branch to start of boot.asm in RTS library

    .endif

;end wd_disable


	.end
	
;******************************************************
; End of file.
;******************************************************


