/****************************************************************************************
 * Copyright:  	GoldenMaple Technologies (C) 2016
 * Project:		EECS X497.34 Course Project
 * File Name:	LedDrv.c
 * Description:	F28069 ContrlStick LED Driver Functions
 * Language:    TI TMS320F2806x C
 * Author:		Louis Zhu
 * Created:		12/18/2014
 * Notes:
 * Mod History: V1.0: Initial version developed on F28069ControlStick platform
 * 				V1.1: Modified for LaunchXL-F28069M LaunchPad
 ****************************************************************************************/

#include "F2806x_Gpio.h"
#include "LedDrv.h"


/*******************************************************************************************
 * Function: DisplayD9
 *
 * Description: This function displays LED D9 per the parameter (Off, On, Blink)
 *
 * Parameters: LedPatternEnum pat
 *
 * Returns: None
 *
 * Special Notes:
 *
 *******************************************************************************************/
void DisplayD9(LedPatternEnum pat)
{
	switch (pat)
	{
	case LED_ON:
		GpioDataRegs.GPBCLEAR.bit.GPIO34 = 1;
		break;

	case LED_BLINK:
		GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;
		break;

	case LED_OFF:
	default:
		GpioDataRegs.GPBSET.bit.GPIO34 = 1;
		break;
	}
}

//--- end of file -----------------------------------------------------
