/*==================================================================================*/
/*	User specific Linker command file for running from RAM							*/
/*==================================================================================*/
/*	FILE:			F28035_RAM_Lighting_DCDC.CMD                                    */
/*                                                                                  */
/*	Description:	Linker command file for User custom sections targetted to run   */
/*					from RAM.  			                                            */
/*                                                                                  */
/*  Target:  		TMS320F28035                               						*/
/*                                                                                  */
/*	Version: 		1.00                                							*/
/*                                                                                  */
/*----------------------------------------------------------------------------------*/
/*  Copyright Texas Instruments  2008                                			    */	
/*----------------------------------------------------------------------------------*/
/*  Revision History:                                                               */
/*----------------------------------------------------------------------------------*/
/*  Date	  | Description                                                         */
/*----------------------------------------------------------------------------------*/
/*  03/14/08  | Release 1.0  		New release.                                    */
/*----------------------------------------------------------------------------------*/

MEMORY
{
PAGE 0 :
   
	BEGIN		: origin = 0x000000,	length = 0x000002             
	RAMM0		: origin = 0x000050,	length = 0x0003B0
	progRAM		: origin = 0x008600,	length = 0x001a00

	IQTABLES       : origin = 0x3FE000, length = 0x000B50    /* IQ Math Tables in Boot ROM */
	IQTABLES2      : origin = 0x3FEB50, length = 0x00008C    /* IQ Math Tables in Boot ROM */
	IQTABLES3      : origin = 0x3FEBDC, length = 0x0000AA	 /* IQ Math Tables in Boot ROM */


	RESET      	: origin = 0x3FFFC0, 	length = 0x000002
	BOOTROM    	: origin = 0x3FF27C, 	length = 0x000D44               

         
PAGE 1 : 

	BOOT_RSVD   : origin = 0x000002, 	length = 0x00004E     /* Part of M0, BOOT rom will use this for stack */
	RAMM1		: origin = 0x000480,	length = 0x000380
	dataRAM		: origin = 0x008000,	length = 0x000600	/*change length to 0x800 and DLOG size to 0x100 for 2806 */

	CLA_CPU_MSGRAM : origin = 0x001480, length = 0x000080
	CPU_CLA_MSGRAM : origin = 0x001500, length = 0x000080
}

 
SECTIONS
{

   codestart        : > BEGIN,      PAGE = 0
   ramfuncs         : > progRAM       PAGE = 0  
   .text            : > progRAM,     PAGE = 0

   .cinit           : > RAMM0,      PAGE = 0
   .pinit           : > RAMM0,      PAGE = 0
   .switch          : > RAMM0,      PAGE = 0
   .reset           : > RESET,      PAGE = 0, TYPE = DSECT
   
   .stack           : > RAMM1,      PAGE = 1

   .ebss            : > dataRAM,     PAGE = 1	
   .econst          : > dataRAM,     PAGE = 1      
/*	.econst          : > RAMM1,     PAGE = 1*/
   .esysmem         : > RAMM1,      PAGE = 1

   IQmath           : > progRAM,   PAGE = 0
   IQmathTables     : > IQTABLES, 	PAGE = 0, TYPE = NOLOAD

   Cla1ToCpuMsgRAM  : > CLA_CPU_MSGRAM, PAGE = 1
   CpuToCla1MsgRAM  : > CPU_CLA_MSGRAM, PAGE = 1

}
   
SECTIONS
{
	Net_terminals:	> dataRAM,PAGE = 1
	ISR_data:		> dataRAM,PAGE = 1
	Controller:		> dataRAM,PAGE = 1
	Controller2:	> dataRAM,PAGE = 1
		/*DataLogTST: 	> dataRAM,PAGE = 1*/
	/*GraphData: 		> dataRAM,PAGE = 1*/
}
    




 
