;----------------------------------------------------------------------------------
;	FILE:			Lighting_DCDC-ISR.ASM
;
;	Description:	Led Backlighting Sepic closed loop control system + current
;					controlled LED strings, with ADC s/w drivers, and a 
;					2-pole/2-zero compensation/control law.
;
;					This file is split into an Initialization and Run-time component.
;					Run-time section is run on an interrupt which is triggered by a 
;					PWM event.
;
;	Version: 		2.0
;
;   Target:  		TMS320F2803x
;
;----------------------------------------------------------------------------------
;  Copyright Texas Instruments  2004-2009
;----------------------------------------------------------------------------------
;  Revision History:
;----------------------------------------------------------------------------------
;  Date	     | Description
;----------------------------------------------------------------------------------
; 29-Jun-09 | Release 1.0  		Internal release (DAF)
; 08-Sep-09 | Release 2.0		Internal release (BRL)
;----------------------------------------------------------------------------------

;----------------------------------------------------------------------------------
	;include Device specific PeripheralAddress_ASM
	;sets DSP_DEVICE for device specific ISR code and gives peripheral addresses
	.include "PeripheralAddress_ASM.h"


	;include C header file - sets INCR_BUILD (used in conditional builds)
	.cdecls C,NOLIST, "Lighting_DCDC-Settings.h"


	; MACRO includes
	.include "ADC_NchDrv.asm"
	.include "ControlLaw2P2Z_Led.asm"
;	.include "DataLogTST.asm"
;	.include "BuckSingle_PwmDrv.asm"
	.include "BuckDual_PwmDrv.asm"
	.include "BuckSingleHR_PwmDrv.asm"


;**********************************************************************************
; Declare Public functions for External Reference
;**********************************************************************************
				.def 	_ISR_Init
				.def 	_ISR_Run

;**********************************************************************************
; Variable declaration
;**********************************************************************************	
; All Terminal modules initially point to the ZeroNet to ensure a known
; start state. Pad extra locations to accomodate unwanted ADC results.
ZeroNet			.usect "Net_terminals",8,1,1
DummyNet	 	.usect "Net_terminals",7,1,1
IsrClkCtr		.usect "Net_terminals",1
tsPtr			.usect "ISR_data",2,1,1

;_DLogBuffer1	.usect "GraphData",50,1,1

				; Used by C environment
				;----------------------
;				.def 	_DLogBuffer1

				.text
;---------------------------------------------------------
; ISR Initialisation
;---------------------------------------------------------
_ISR_Init:

; Clear the ZeroNet
	MOVL 	XAR2,#ZeroNet
	RPT		#7 ; 8 times
	||MOV	*XAR2++, #0

	;---------------------------------------------------------
	.if(INCR_BUILD = 1)
		BuckSingleHR_DRV_INIT 1	; EPWM1A
		BuckDual_DRV_INIT	2	; EPWM2A, 2B
		BuckDual_DRV_INIT	3	; EPWM3A, 3B
		BuckDual_DRV_INIT	4	; EPWM4A, 4B
		BuckDual_DRV_INIT	5	; EPWM5A, 5B

		ADC_NchDRV_INIT 2
	.endif
	;---------------------------------------------------------
	.if(INCR_BUILD = 2)
		ADC_NchDRV_INIT	4		; 1 Channel, (i.e. N=1)
		ControlLaw_2P2Z_INIT 1
		BuckSingleHR_DRV_INIT 1	; EPWM1A
		BuckDual_DRV_INIT	2	; EPWM2A, 2B
		BuckDual_DRV_INIT	3	; EPWM3A, 3B
		BuckDual_DRV_INIT	4	; EPWM4A, 4B
		BuckDual_DRV_INIT	5	; EPWM5A, 5B
	.endif
	;---------------------------------------------------------
	.if(INCR_BUILD = 3)
		; Initialize the time slicer
		MOVW	DP, #tsPtr												  ;
		MOV 	@tsPtr,#1	

		ADC_NchDRV_INIT	12		; 1 Channel, (i.e. N=1)
		ControlLaw_2P2Z_INIT 1	; SEPIC
		ControlLaw_2P2Z_INIT 2	; LED String 0
		ControlLaw_2P2Z_INIT 3
		ControlLaw_2P2Z_INIT 4
		ControlLaw_2P2Z_INIT 5
		ControlLaw_2P2Z_INIT 6
		ControlLaw_2P2Z_INIT 7
		ControlLaw_2P2Z_INIT 8
		ControlLaw_2P2Z_INIT 9	; LED String 8

		BuckSingleHR_DRV_INIT 1	; EPWM1A
		BuckDual_DRV_INIT	2	; EPWM2A, 2B
		BuckDual_DRV_INIT	3	; EPWM3A, 3B
		BuckDual_DRV_INIT	4	; EPWM4A, 4B
		BuckDual_DRV_INIT	5	; EPWM5A, 5B
	.endif
	;---------------------------------------------------------


	LRETR

			.sect "ramfuncs"

;---------------------------------------------------------
; ISR Run
;---------------------------------------------------------
_ISR_Run:	;(13 cycles to get to here from ISR trigger)
	;CONTEXT_SAVE
	PUSH AR1H:AR0H ; 32-bit
	PUSH XAR2 ; 32-bit
	PUSH XAR3 ; 32-bit
	PUSH XAR4 ; 32-bit
;-- Comment these to save cycles --------
	PUSH XAR5 ; 32-bit
	PUSH XAR6 ; 32-bit
	PUSH XAR7 ; 32-bit
;----------------------------------------
	PUSH XT	  ; 32-bit
	NOP		

	;---------------------------------------------------------
	.if(INCR_BUILD = 1)
		BuckSingleHR_DRV 1			; EPWM1A
		BuckDual_DRV	2			; EPWM2A, 2B
		BuckDual_DRV	3			; EPWM3A, 3B
		BuckDual_DRV	4			; EPWM4A, 4B
		BuckDual_DRV	5			; EPWM5A, 5B

		ADC_NchDRV		2		; 1 Channel, (i.e. N=1)
	.endif
	;---------------------------------------------------------
	.if(INCR_BUILD = 2)
		ADC_NchDRV		4		; 1 Channel, (i.e. N=1)
		ControlLaw_2P2Z 1
		BuckSingleHR_DRV 1		; EPWM1A
		BuckDual_DRV	2		; EPWM2A, 2B
		BuckDual_DRV	3		; EPWM3A, 3B
		BuckDual_DRV	4		; EPWM4A, 4B
		BuckDual_DRV	5		; EPWM5A, 5B
;ADC_Reset:  ;not needed on Piccolo
		;NOP
		;MOVW 	DP,#ADCTRL2>>6		; Reset ADC SEQ
		;MOV 	@ADCTRL2,#0x4101	; RST_SEQ1=1, SOCA-SEQ1=1, SOCB-SEQ2=1
	.endif
	;---------------------------------------------------------
	.if(INCR_BUILD = 3)
		;ISR will always run the Sepic controller, but will only run two LED string controllers 
		;  each time an interrupt fires 
		ADC_NchDRV		12		; Convert 12 Adc Channels, (i.e. N=12)
		ControlLaw_2P2Z 1		; Perform calculations for SEPIC controller
		BuckSingleHR_DRV 1		; update EPWM1A duty cycle

		;LED control is "time-sliced" to save cycles. This can be done because the LED 
		;  control does not need to run at 100kHz
		MOVW	DP, #tsPtr
		CMP		@tsPtr, #1
		B		TS1, EQ
		CMP		@tsPtr, #2
		B		TS2, EQ
		CMP		@tsPtr, #3
		B		TS3, EQ
		CMP		@tsPtr, #4
		B		TS4, EQ
		CMP		@tsPtr, #5
		B		TS5, GEQ
												  
		MOV 	@tsPtr,#1
		LB		TS_SKIP
TS1:
		ControlLaw_2P2Z 2
		ControlLaw_2P2Z 3
		BuckDual_DRV	2		; EPWM2A, 2B
		LB 		TS_SKIP
TS2:
		ControlLaw_2P2Z 4
		ControlLaw_2P2Z 5
		BuckDual_DRV	3		; EPWM3A, 3B
		LB 		TS_SKIP
TS3:
		ControlLaw_2P2Z 6
		ControlLaw_2P2Z 7		
		BuckDual_DRV	4		; EPWM4A, 4B
		LB 		TS_SKIP
TS4:
		ControlLaw_2P2Z 8
		ControlLaw_2P2Z 9
		BuckDual_DRV	5		; EPWM5A, 5B
		LB 		TS_SKIP
TS5:	; DO NOTHING

TS_SKIP:
		MOVW	DP, #tsPtr
		INC		@tsPtr
		CMP		@tsPtr, #5		; if new value of tsPtr is 6 or greater reset tsPtr to 1
		B		TS_FIN, LEQ		
		MOV		@tsPtr,	#1

TS_FIN:
		

;ADC_Reset:
;		NOP
;		MOVW 	DP,#ADCTRL2>>6		; Reset ADC SEQ
;		MOV 	@ADCTRL2,#0x4101	; RST_SEQ1=1, SOCA-SEQ1=1, SOCB-SEQ2=1
	.endif
;	;---------------------------------------------------------


;===================================
EXIT_ISR
;===================================
; Interrupt management before exit
	MOVW 	DP,#ETCLR1>>6
	MOV 	@ETCLR1,#0x01			; Clear EPWM1 Int flag
	MOVW 	DP,#PIEACK>>6			; Acknowledge PIE interrupt Group 3
	MOV 	@PIEACK,#PIEACK_GROUP3

; Restore context & return
	POP XT
;-- Comment these to save cycles ---
	POP XAR7
	POP XAR6
	POP XAR5
;-----------------------------------
	POP XAR4
	POP XAR3
	POP XAR2
	POP AR1H:AR0H

	IRET						

