using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.IO;

namespace GUI_Template
{
    public class CommsManager
    {
        private int[] echobyte = new int[4];

        private System.IO.Ports.SerialPort comPort;

        public bool comValid;
        public bool isReceiving;
        public int[] dataRxedBuffer;
        volatile public bool dataRxedBufferFilled;

        public byte[] cmdNum;
        public byte[] itemNum;
        public int[] data;
        public int[] data2;
        public int[] amountToGet;       
        public Object[] ctrl;

        private int couldNotRunCommsTaskCount = 0;
        private int retryCount = 0;

        private int _ptrWorkingAt;
        public int ptrWorkingAt
        {
            get
            { return _ptrWorkingAt; }
            set
            {
                if (value > 95) _ptrWorkingAt = 0;
                else _ptrWorkingAt = value;
            }
        }
        private int _ptrWriteAt;
        public int ptrWriteAt
        {
            get
            { return _ptrWriteAt; }
            set
            {
                if (value > 95) _ptrWriteAt = 0;
                else _ptrWriteAt = value;
            }
        }

        public bool IsOpen
        {
            get { return comPort.IsOpen; }
        }
        public string PortName
        {
            get { return comPort.PortName; }
            set { comPort.PortName = value; }
        }
        public int BaudRate
        {
            get { return comPort.BaudRate; }
            set { comPort.BaudRate = value; }
        }
        
        private Lighting_DCDC mainForm;
        private Thread RunCommsThread;
        private Thread TryNewCommsThread;


        #region Constructors

        public CommsManager(Lighting_DCDC parentForm)
        {
            cmdNum = new byte[96];
            itemNum = new byte[96];
            data = new int[96];
            data2 = new int[96];
            amountToGet = new int[96];
            ctrl = new Object[96];
            isReceiving = false;
            //comPort = commsPort;
            _ptrWorkingAt = 0;
            _ptrWriteAt = 0;
            mainForm = parentForm;
            comPort = new System.IO.Ports.SerialPort();
  
            comPort.PortName = Properties.Settings.Default.ComPortName;
            comPort.BaudRate = Convert.ToInt32(Properties.Settings.Default.ComBaudRate);
            comPort.ReceivedBytesThreshold = 600;
            comPort.ReadTimeout = 1000;
            comPort.WriteTimeout = 1000;
            comPort.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(commsPort_DataReceived);
            RunCommsThread = new Thread(new ThreadStart(RunCommsTask));
            TryNewCommsThread = new Thread(new ThreadStart(TryNewCommsTask));
            dataRxedBufferFilled = false;

            comPort.RtsEnable = true;
            comPort.DtrEnable = true;
        }
        #endregion


        //---Writes 4 bytes of data across the SCI and echo checks---
        private void DataWrite(byte cmd, byte item, byte datHigh, byte datLow)
        {
            try
            {
                comPort.Write(new byte[] { cmd }, 0, 1);
                echobyte[3] = comPort.ReadByte();
                //label1.Text = echobyte3.ToString();          //Debug
                if (echobyte[3] != cmd)
                {
                    throw new InvalidProgramException();
                }

                comPort.Write(new byte[] { item }, 0, 1);
                echobyte[2] = comPort.ReadByte();
                //label1.Text = label1.Text + " " + echobyte2.ToString();     //Debug
                if (echobyte[2] != item)
                {
                    throw new InvalidProgramException();
                }

                comPort.Write(new byte[] { datLow }, 0, 1);  //host expects LSB then MSB
                echobyte[0] = comPort.ReadByte();
                //label1.Text = label1.Text + " " + echobyte1.ToString();     //Debug
                if (echobyte[0] != datLow)
                {
                    throw new InvalidProgramException();
                }

                comPort.Write(new byte[] { datHigh }, 0, 1);
                echobyte[1] = comPort.ReadByte();
                //label1.Text = label1.Text + " " + echobyte0.ToString();     //Debug
                if (echobyte[1] != datHigh)
                {
                    throw new InvalidProgramException();
                }
            }

            catch (Exception err)
            {
                //lblStatus.Text = "Unhandled Exception";
                comValid = false;
                //err.Message;
            }
        }

        //---Check if a communication is occurring through the serialport
        public void TryNewCommsTask()
        {
            if (ptrWorkingAt == ptrWriteAt + 1)
            {
                isReceiving = true;
                mainForm.Invoke(new EventHandler(delegate
                {
                    mainForm.connectionLost();
                }));
            }

            // if serialport is currently not busy
            else if (isReceiving == false && ptrWorkingAt != ptrWriteAt)
            {
                isReceiving = true;

                couldNotRunCommsTaskCount = 0;
                retryCount = 0;

                RunCommsThread = new Thread(new ThreadStart(RunCommsTask));
                RunCommsThread.Start();
            }
            else    
            {
                // try to retry if communications have halted
                couldNotRunCommsTaskCount++;
                if (couldNotRunCommsTaskCount > 20)     
                {
                    isReceiving = true;

                    RunCommsThread = new Thread(new ThreadStart(RunCommsTask));
                    RunCommsThread.Start();
                    couldNotRunCommsTaskCount = 0;
                    retryCount++;
                    if (retryCount > 5) //if retry has failed multiple times tell user
                    {
                        mainForm.Invoke(new EventHandler(delegate
                        {
                            mainForm.connectionLost();
                        }));
                    }
                }
            }
        }


        //---Sends data across the serialport
        private void RunCommsTask()
        {          
            #region attempt to free up some bandwidth
            if (cmdNum[ptrWorkingAt] == 3)// || cmdNum[ptrWorkingAt] == 5)  //for slider and Getarray controls
            {
                int skipAmountAttempted = ptrWriteAt - ptrWorkingAt; //try to skip up to 12 commands
                if (skipAmountAttempted > 0)
                {
                    if (skipAmountAttempted > 15)
                    {
                        skipAmountAttempted = 15;
                    }

                    for (int i = 1; i <= skipAmountAttempted; i++)
                    {
                        if (cmdNum[ptrWorkingAt] != cmdNum[ptrWorkingAt + i] || itemNum[ptrWorkingAt] != itemNum[ptrWorkingAt + 1] || i >= skipAmountAttempted)
                        {
                            ptrWorkingAt = ptrWorkingAt + i - 1;
                            break;
                        }
                    }
                }
            }
            #endregion

            int ptr = ptrWorkingAt;
            if (cmdNum[ptr] >= 0 && cmdNum[ptr] <= 3)   // set variable
            {
                byte[] byteBuffer = BitConverter.GetBytes(data[ptr]);
                DataWrite(cmdNum[ptr], itemNum[ptr], byteBuffer[1], byteBuffer[0]);
                if (comValid == true)
                {
                    TaskComplete();
                    TryNewCommsTask();
                }
                else
                {
                    mainForm.Invoke(new EventHandler(delegate
                    {
                        mainForm.connectionLost();
                    }));
                }
            }
            else if (cmdNum[ptr] == 4 || cmdNum[ptr] == 5)   //get variable or array
            {
                comPort.ReceivedBytesThreshold = amountToGet[ptr] * 2;
                byte[] byteBuffer = BitConverter.GetBytes(amountToGet[ptr]);
                DataWrite(cmdNum[ptr], itemNum[ptr], byteBuffer[1], byteBuffer[0]);
                if (comValid == false)
                {
                    mainForm.Invoke(new EventHandler(delegate
                    {
                        mainForm.connectionLost();
                    }));
                }
            }
            else if (cmdNum[ptr] == 6)   //get memory (untested)
            {
                if (amountToGet[ptr] > 0)
                {
                    comPort.ReceivedBytesThreshold = amountToGet[ptr];
                }
                byte[] byteBuffer = BitConverter.GetBytes(data[ptr]);
                DataWrite(cmdNum[ptr], itemNum[ptr], byteBuffer[1], byteBuffer[0]);
                byteBuffer = BitConverter.GetBytes(data2[ptr]);
                DataWrite(cmdNum[ptr], itemNum[ptr], byteBuffer[1], byteBuffer[0]);
                if (comValid == false)
                {
                    mainForm.Invoke(new EventHandler(delegate
                    {
                        mainForm.connectionLost();
                    }));
                }
            }
        }


        //---Check if the serialport is valid
        public bool TestConnection()
        {
            comValid = true;

            //DataWrite sets comValid to false if write is not echoed properly
            DataWrite(0x00, 0x00, 0x00, 0x02);  //try to blink LED 

            return comValid;
        }


        //---Syncronizes Client and Target and open communications
        public bool SciConnect()
        {
            string[] s = System.IO.Ports.SerialPort.GetPortNames();
            for (int i = 0; i < s.Length; i++)
            {
                if (s[i] == Properties.Settings.Default.ComPortName)
                {
                    comPort.Open();

                    while (comPort.IsOpen == false) { }

                    comPort.DiscardOutBuffer();
                    comPort.DiscardInBuffer();

                    //necessary for some SerialPorts
                    DataWrite(0x00, 0x00, 0x00, 0x00); //initialise data transfer
                    DataWrite(0x00, 0x00, 0x00, 0x00); //initialise data transfer                

                    comValid = true;
                    DataWrite(0x00, 0x00, 0x00, 0x02);  //try to blink LED and receive errors

                    if (comValid == false)
                    {
                        comPort.Close();
                    }

                    return comValid;
                }
            }
            return false;
        }


        //---Generic get task
        public void NewGetTask(Object _ctrl, byte _cmdNum, byte _itemNum, int _data, int _amountToGet)
        {
            cmdNum[ptrWriteAt] = _cmdNum;
            itemNum[ptrWriteAt] = _itemNum;
            data[ptrWriteAt] = _data;
            amountToGet[ptrWriteAt] = _amountToGet;
            ctrl[ptrWriteAt] = _ctrl;

            ptrWriteAt++;

            TryNewCommsTask();
        }


        //---Generic set task
        public void NewSetTask(Object _ctrl, byte _cmdNum, byte _itemNum, int _data)
        {
            cmdNum[ptrWriteAt] = _cmdNum;
            itemNum[ptrWriteAt] = _itemNum;
            data[ptrWriteAt] = _data;
            ctrl[ptrWriteAt] = _ctrl;

            ptrWriteAt++;

            TryNewCommsTask();
        }


        //---Once task is complete allow a new task to begin
        public void TaskComplete()
        {
            ptrWorkingAt++;
            isReceiving = false;
        }


        //---Close the comport
        public void Close()
        {
            if (comPort.IsOpen == true)
            {
                comPort.Close();
            }
        }


        //---Try to open the comport.  Comport can fail if it is currently in use elsewhere
        public bool Open()
        {
            try
            {
                if (comPort.IsOpen == false)
                {
                    comPort.Open();
                    return true;
                }
                return false;
            }
            catch (Exception err)
            {
                return false;
            }
        }


        //---When data is received call the control who owns it to see what to do with the data
        private void commsPort_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            int numBytes = comPort.BytesToRead;
            if (numBytes == comPort.ReceivedBytesThreshold)
            {
                byte[] byteBuffer = new byte[numBytes];
                comPort.Read(byteBuffer, 0, numBytes);

                if ((ctrl[ptrWorkingAt]) is GUI_Template.GuiGetVar)
                {
                    ((GuiGetVar)ctrl[ptrWorkingAt]).ReadBuffer(byteBuffer);
                }
                else if ((ctrl[ptrWorkingAt]) is GUI_Template.GuiGetArray)
                {
                    ((GuiGetArray)ctrl[ptrWorkingAt]).ReadBuffer(byteBuffer);
                }
                else if ((ctrl[ptrWorkingAt]) is GUI_Template.GuiGraphTSArray)
                {
                    ((GuiGraphTSArray)ctrl[ptrWorkingAt]).ReadBuffer(byteBuffer);
                }
                else if ((ctrl[ptrWorkingAt]) is GUI_Template.GuiGetMemory)
                {
                    ((GuiGetMemory)ctrl[ptrWorkingAt]).ReadBuffer(byteBuffer);
                }
                else if (dataRxedBufferFilled == false)
                {
                    dataRxedBuffer = new int[numBytes];
                    for (int i = 0; i < byteBuffer.Length / 2; i++)
                    {
                        dataRxedBuffer[i] = (byteBuffer[2 * i] + byteBuffer[2 * i + 1] * 256);
                    }
                    dataRxedBufferFilled = true;
                    TaskComplete();
                }
                while (TryNewCommsThread.IsAlive == true) { }
                TryNewCommsThread = new Thread(new ThreadStart(TryNewCommsTask));
                TryNewCommsThread.Start();
            }
        }


        //---allow a different form to write data through the serialport
        public void WriteString(string text)
        {
            char[] temp = new char[1];
            temp = (text.ToCharArray(0, 1));
            comPort.Write(temp, 0, 1);
        }


        //---allow a different form to write data through the serialport
        public byte[] WriteBytes(byte[] text)
        {
               byte[] k = new byte[256];

               byte[] bytebuffer = new byte[text.Length];
               bytebuffer = text;
                
            for (int i = 0; i<bytebuffer.Length; i++)
            {
                comPort.Write(bytebuffer, i, 1);
                k[i] = ReadByte();
                if (text[i] != k[i])
                {
                    return null;
                }
            }
            return k;      
        }

        //---allow a different form to read data through the serialport
        public byte ReadByte()
        {
            byte temp = 0;
            try
            {
                temp = (byte)comPort.ReadByte();
            }
            catch(Exception err)
            {
            }
            return temp;
        }


        //---Deletes all tasks
        public void ClearCommands()
        {
            for (int i = 0; i < 96; i++)
            {
                cmdNum[i] = 0x00;
            }
            ptrWorkingAt = 0;
            ptrWriteAt = 0;

            couldNotRunCommsTaskCount = 0;
            retryCount = 0;
        }


        //---load a .a00 file, send errors 
        public string LoadProgramFromFile(string port, string path, System.Windows.Forms.ProgressBar prb)
        {
            try
            {
                char oldChar = 'X';
                prb.Value = 0;

                this.Close();

                int oldBaud = this.BaudRate;

                this.PortName = port;
                this.BaudRate = 38400;

                this.Open();

                this.WriteString("A");
                int temp = Convert.ToInt32(this.ReadByte());
                if (temp == 65)
                {
                    // Create an instance of StreamReader to read from a file.
                    // The using statement also closes the StreamReader.
                    using (StreamReader sr = new StreamReader(path))
                    {
                        byte[] echoedBytes = new byte[256];
                        byte[] toBeTxedBytes = new byte[256];
                        char readChar;
                        int i = 0;

                        while (sr.EndOfStream != true)
                        {
                            readChar = (char)(sr.Read());
                            if ((readChar >= 'A' && readChar <= 'F') || (readChar >= '0' && readChar <= '9'))
                            {
                                if (oldChar != 'X')
                                {
                                    byte b = (byte)(Convert.ToInt32(readChar.ToString(), 16) + (Convert.ToInt32(oldChar.ToString(), 16) * 16));

                                    oldChar = 'X';
                                    toBeTxedBytes[i] = b;
                                    i++;
                                }
                                else
                                {
                                    oldChar = readChar;
                                }
                            }
                            else
                            {
                                oldChar = 'X';
                            }
                            if (i == 256)
                            {
                                echoedBytes = this.WriteBytes(toBeTxedBytes);
                                if (echoedBytes == null)
                                {
                                    throw new InvalidProgramException();
                                }
                                if (prb.Value >= 100)
                                {
                                    prb.Value = 0;
                                }
                                prb.Value = prb.Value + 2;
                                i = 0;
                            }
                        }
                        if (i != 0)
                        {
                            byte[] byteBufferRemaining = new byte[i];
                            for (int p = 0; p < i; p++)
                            {
                                byteBufferRemaining[p] = toBeTxedBytes[p];
                            }
                            echoedBytes = this.WriteBytes(byteBufferRemaining);
                            if (echoedBytes == null)
                            {
                                throw new InvalidProgramException();
                            }
                            prb.Value = 100;

                            this.Close();
                            this.BaudRate = oldBaud;
                            return ("Program Successfully Loaded");
                        }
                    }
                    this.Close();
                    this.BaudRate = oldBaud;
                    return ("Error: Program Did Not Load. Please Try Again.");
                }
                else
                {
                    this.Close();
                    this.BaudRate = oldBaud;
                    return ("Error: Improper COM Port, Power is Off, Program was Already Loaded, or SCI Boot Jumper is Not Placed.");
                }
                

            }
            catch (Exception err)
            {
                this.Close();
                return ("Error: Program Did Not Load. Please Try Again.");
            }
        }
    }
}
