using System;
using System.Collections.Generic;
using System.Text;

namespace GUI_Template
{
    public class GuiGraphTSArray : Object
    {
        private int[] _dataArray;
        private int _dataArraySize;
        
        private byte _cmdNum;
        private byte _itemNum;
        public bool isGraphing;
        public byte[] byteBuffer;
        
        private System.Windows.Forms.Panel pnlGraph;

        private float delta;
        private float pointAtX;
        private System.Drawing.Pen redPen;
        private System.Drawing.Pen blackPen;
        private System.Drawing.Graphics formGraphics;

        public CommsManager commsMngr;


        #region Constructors

        public GuiGraphTSArray(int sizeOfBuffer, byte itemNumber, System.Windows.Forms.Panel drawingPanel)
        {
            _dataArraySize = sizeOfBuffer;
            _dataArray = new int[_dataArraySize];
            _itemNum = itemNumber;
            _cmdNum = 0x05;
            pnlGraph = drawingPanel;

            redPen = new System.Drawing.Pen(System.Drawing.Color.Red);
            blackPen = new System.Drawing.Pen(System.Drawing.Color.Black);
            CreateGraphics();
        }

        #endregion


        public void CreateGraphics()
        {
            formGraphics = pnlGraph.CreateGraphics();
            delta = (float)pnlGraph.Size.Width / (float)_dataArraySize;
            isGraphing = false;
            GraphBuffer();
        }


        public void RequestBuffer()
        {
            //byte[] amountToGet = BitConverter.GetBytes(bufferSize);
            //int[] RxVarData = new int[2];

            int ptr = commsMngr.ptrWriteAt;
            commsMngr.cmdNum[ptr] = _cmdNum;
            commsMngr.itemNum[ptr] = _itemNum;
            commsMngr.amountToGet[ptr] = _dataArraySize;
            commsMngr.data[ptr] = 65535;
            commsMngr.ctrl[ptr] = this;
            commsMngr.ptrWriteAt++;
            commsMngr.TryNewCommsTask();            
        }


        public void ReadBuffer(byte[] buffer)
        {
            byteBuffer = buffer;

            commsMngr.TaskComplete();

            for (int i = 0; i < _dataArraySize; i++)
            {
                _dataArray[i] = byteBuffer[i * 2] + byteBuffer[2 * i + 1] * 256;
                if (_dataArray[i] > 32768)
                {
                    _dataArray[i] = (_dataArray[i] - 65536);
                }
            }
            GraphBuffer();
        }


        public void GraphBuffer()
        {
            if (isGraphing == false)
            {
                isGraphing = true;
                pointAtX = 0;
                formGraphics.Clear(System.Drawing.Color.White);
                formGraphics.DrawLine(redPen, 0, pnlGraph.Size.Height / 2 - (_dataArray[0] * (pnlGraph.Size.Height / 2) / 32767), 0 + delta, pnlGraph.Size.Height / 2 - (_dataArray[1] * (pnlGraph.Size.Height / 2) / 32767));
                pointAtX = pointAtX + delta;
                for (int i = 2; i < _dataArraySize; i++)
                {
                    formGraphics.DrawLine(redPen, pointAtX, pnlGraph.Size.Height / 2 - (_dataArray[i - 1] * (pnlGraph.Size.Height / 2) / 32767), pointAtX + delta, pnlGraph.Size.Height / 2 - (_dataArray[i] * (pnlGraph.Size.Height / 2) / 32767));
                    pointAtX = pointAtX + delta;
                }
                formGraphics.DrawLine(blackPen, 0, pnlGraph.Size.Height / 2, pnlGraph.Size.Width, pnlGraph.Size.Height / 2);
                isGraphing = false;
            }
        }
    }
}
