using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace GUI_Template
{
    //using system.globalization with cultureinfo.invariantculture fixes regional issues

    public partial class Lighting_DCDC : Form
    {
        //---global variables---
        GuiSetBtn[] btnGroup;
        GuiSetTxt[] txtGroup;
        GuiSetSldr[] sldrGroup;

        GuiGetVar[] varGroup;
        GuiGetArray[] arrayGroup;
        //public GuiGraphTSArray[] TSGraphGroup;
        GuiGetMemory[] memoryGroup;

        bool autoUpdateOn = false;
        bool graphOn = false;
        bool powerCycled = false;

        //GraphForm grphForm;
        ProjectProperties propsForm;

        public CommsManager commsMngr;

        int guiSetBtnSize = 0;
        int guiSetTxtSize = 2;
        int guiSetSldrSize = 10;

        int guiGetVarSize = 3;
        int guiGetArraySize = 1;
        int guiGetTSGraphSize = 0;
        int guiGetMemorySize = 0;

        //---initialization---
        public Lighting_DCDC()
        {      
            InitializeComponent();
            EnableCtrls(false);

            commsMngr = new CommsManager(this);

            //grphForm = new GraphForm(this);
            propsForm = new ProjectProperties(this,commsMngr);

            commsMngr.Close();

            MainTimer.Enabled = true;
            MainTimer.Stop();
            GraphTimer.Enabled = true;
            GraphTimer.Stop();

            btnGroup = new GuiSetBtn[guiSetBtnSize];
            txtGroup = new GuiSetTxt[guiSetTxtSize];
            sldrGroup = new GuiSetSldr[guiSetSldrSize];

            varGroup = new GuiGetVar[guiGetVarSize];
            arrayGroup = new GuiGetArray[guiGetArraySize];
            //TSGraphGroup = new GuiGraphTSArray[guiGetTSGraphSize];
            memoryGroup = new GuiGetMemory[guiGetMemorySize];

            //---Set Controls---
            //btns
            //btnGroup[0] = new GuiSetBtn(btnEnableCH1, 0x00);
            //btnGroup[1] = new GuiSetBtn(btnEnableCH2, 0x01);
            //btnGroup[2] = new GuiSetBtn(btnStartUp, "Stop All", "Start All", 0x02);
            //btnGroup[3] = new GuiSetBtn(btnActiveLoad, 0x03);
            //btnGroup[4] = new GuiSetBtn(btnScopeACMode, 0x04);

            //txts
            //txtGroup[0] = new GuiSetTxt(txtSlewStepCH1, btnSlewStepCH1, 13, 0.0002, 2, 0x00);
            txtGroup[1] = new GuiSetTxt(txtLEDSlewRate, btnLEDSlewRate, 0, 1, 500, 0x01);
            //txtGroup[2] = new GuiSetTxt(txtOnDelayCH1, btnOnDelayCH1, 0, 0, 30000, 0x02);
            //txtGroup[3] = new GuiSetTxt(txtOnDelayCH2, btnOnDelayCH2, 0, 0, 30000, 0x03);
            //txtGroup[4] = new GuiSetTxt(txtOffDelayCH1, btnOffDelayCH1, 0, 0, 30000, 0x04);
            //txtGroup[5] = new GuiSetTxt(txtOffDelayCH2, btnOffDelayCH2, 0, 0, 30000, 0x05);
            //txtGroup[6] = new GuiSetTxt(txtScopeGain, btnScopeGain, 0x06);


            //sldrs
            sldrGroup[0] = new GuiSetSldr(sldrVsetSepic, txtVsetSepic, lblMinVsetSepic, lblMaxVsetSepic, 0x00, 9);
            //sldrGroup[1] = new GuiSetSldr(sldrDutySetSepic, txtDutySetSepic, lblMinDutySetSepic, lblMaxDutySetSepic, 0x01, 0);
            sldrGroup[2] = new GuiSetSldr(sldrIsetLed1, txtIsetLED1, lblMinIsetLED1, lblMaxIsetLED1, 0x02, 14);
            sldrGroup[3] = new GuiSetSldr(sldrIsetLed2, txtIsetLED2, lblMinIsetLED2, lblMaxIsetLED2, 0x03, 14);
            sldrGroup[4] = new GuiSetSldr(sldrIsetLed3, txtIsetLED3, lblMinIsetLED3, lblMaxIsetLED3, 0x04, 14);
            sldrGroup[5] = new GuiSetSldr(sldrIsetLed4, txtIsetLED4, lblMinIsetLED4, lblMaxIsetLED4, 0x05, 14);
            sldrGroup[6] = new GuiSetSldr(sldrIsetLed5, txtIsetLED5, lblMinIsetLED5, lblMaxIsetLED5, 0x06, 14);
            sldrGroup[7] = new GuiSetSldr(sldrIsetLed6, txtIsetLED6, lblMinIsetLED6, lblMaxIsetLED6, 0x07, 14);
            sldrGroup[8] = new GuiSetSldr(sldrIsetLed7, txtIsetLED7, lblMinIsetLED7, lblMaxIsetLED7, 0x08, 14);
            sldrGroup[9] = new GuiSetSldr(sldrIsetLed8, txtIsetLED8, lblMinIsetLED8, lblMaxIsetLED8, 0x09, 14);
            

            //---Get Controls---
            //vars
            //varGroup[0] is the board's FlashID
            varGroup[1] = new GuiGetVar(txtGetVin, 0x01, 8);
            varGroup[2] = new GuiGetVar(txtGetVSepic, 0x02, 9);

            //arrays
            arrayGroup[0] = new GuiGetArray(new TextBox[8] {txtGetILed1, txtGetILed2, txtGetILed3, txtGetILed4, txtGetILed5, txtGetILed6, txtGetILed7, txtGetILed8}, 0x00, 14);
            //arrayGroup[1] = new GuiGetArray(new TextBox[2] {txtGetVSepic, txtTGetCH2}, 0x01, 6);
            //arrayGroup[2] = new GuiGetArray(new TextBox[2] { txtGetILed2, txtGetILed3 }, 0x02, 9);

            //Time-sequenced graphs (block of data from target)
            //TSGraphGroup[0] = new GuiGraphTSArray(300, 0x05, grphForm.graphPane);

            //memory gets
            //memoryGroup[0] = new GuiGetMemory(textBox1, textBox2, 0x00);


            #region Initialize common components among the ctrl groups (ex. commsMngr reference)

            for (int i = 0; i < guiSetBtnSize; i++)
            {
                if (btnGroup[i] != null)
                {
                    btnGroup[i].commsMngr = commsMngr;
                }
            }

            for (int i = 0; i < guiSetTxtSize; i++)
            {
                if (txtGroup[i] != null)
                {
                    txtGroup[i].commsMngr = commsMngr;
                }
            }

            for (int i = 0; i < guiSetSldrSize; i++)
            {
                if (sldrGroup[i] != null)
                {
                    sldrGroup[i].commsMngr = commsMngr;
                }
            }

            for (int i = 0; i < guiGetVarSize; i++)
            {
                if (varGroup[i] != null)
                {
                    varGroup[i].commsMngr = commsMngr;
                }
            }
            for (int i = 0; i < guiGetArraySize; i++)
            {
                if (arrayGroup[i] != null)
                {
                    arrayGroup[i].commsMngr = commsMngr;
                }
            }
            /*for (int i = 0; i < guiGetTSGraphSize; i++)
            {
                if (TSGraphGroup[i] != null)
                {
                    TSGraphGroup[i].commsMngr = commsMngr;
                }
            }*/
            for (int i = 0; i < guiGetMemorySize; i++)
            {
                if (memoryGroup[i] != null)
                {
                    memoryGroup[i].commsMngr = commsMngr;
                }
            }

            #endregion
        }


        //----------------------------------------------------------
        #region Main Form Event Handlers and Timers
        //----------------------------------------------------------

        //---Connect to the target via SCI and change displays to show this---
        public void Connect()
        {
            if (commsMngr.SciConnect() == false)
            {
                pnlConnect.BackColor = System.Drawing.Color.Red;
                lblStatus.Text = "Could Not Connect:  Please Check Connections";
                btnConnect.Text = "Connect";
            }
            else
            {
                #region Connected Successfully
                commsMngr.ClearCommands();
                commsMngr.isReceiving = false;

                EnableCtrls(true);

                commsMngr.ptrWriteAt = 0;
                commsMngr.ptrWorkingAt = 0;

                //Set Gui Controls to default settings
                Properties.Settings.Default.Reload();
                SetDefault();

                MainTimer.Start();

                #region Check Flash ID
                Application.DoEvents();
                System.Threading.Thread.Sleep(50);

                commsMngr.NewGetTask(null, 0x04, 0x00, 0xFF, 1);

                while (commsMngr.dataRxedBufferFilled == false)
                {
                    Application.DoEvents();
                    System.Threading.Thread.Sleep(20);
                }
                commsMngr.dataRxedBufferFilled = false;

                if (commsMngr.dataRxedBuffer[0] != 0x5001)
                {
                    Disconnect();
                    //pnlMotorCtrls.Enabled = false;
                    //pnlMotorType.Enabled = false;
                    lblStatus.Text = "Target code incompatible with the GUI";
                    autoUpdateOn = false;
                    pnlConnect.BackColor = System.Drawing.Color.Red;
                }
                #endregion

                lblStatus.Text = "Connected";
                pnlConnect.BackColor = System.Drawing.Color.Green;

                btnConnect.Text = "Disconnect";
                cmbMainUpdateRate_SelectedIndexChanged(this, new EventArgs());

                System.Threading.Thread.Sleep(200);
                chbMergeLedSliders.Checked = false;
                commsMngr.NewSetTask(null, 0x01, 0x00, 0);

                #endregion
            }
            //if (graphOn == true)        //restart graph if it is still open
            //{
            //    GraphTimer.Start();
            //}
        }


        //---Boot to the target and display status/errors---
        public void Boot()
        {
            string portName = propsForm.PortName;
            string hexPath = propsForm.HexPath;

            if (portName == null)
            {
                lblStatus.Text = "Error: COM Port is Invalid.";
                pnlConnect.BackColor = System.Drawing.Color.Red;
            }
            else if (hexPath.Length < 6)
            {
                lblStatus.Text = "Error: Please load a valid .a00 file";
                pnlConnect.BackColor = System.Drawing.Color.Red;
            }
            else if (hexPath.Substring(hexPath.Length - 4) != ".a00")
            {
                lblStatus.Text = "Error: Please load a valid .a00 file";
                pnlConnect.BackColor = System.Drawing.Color.Red;
            }
            else if (powerCycled == true)
            {
                lblStatus.Text = "Loading Program...";
                Application.DoEvents();
                lblStatus.Text = commsMngr.LoadProgramFromFile(portName, hexPath, prbConnectStatus);
                if (lblStatus.Text.StartsWith("Error")) pnlConnect.BackColor = System.Drawing.Color.Crimson;
                else pnlConnect.BackColor = System.Drawing.Color.SeaGreen;
                powerCycled = false;
            }
            else
            {
                lblStatus.Text = "Please Power Cycle Board then Push \"Connect\"";
                lblStatus.ForeColor = System.Drawing.Color.Black;
                Application.DoEvents();
                powerCycled = true;
            }
        }


        //---Disconnect from the target and change displays to show this---
        public void Disconnect()
        {
            if (commsMngr.comValid == true && commsMngr.IsOpen == true)
            {
                autoUpdateOn = false;       //stop automatically getting variables from target 
                MainTimer.Stop();
                //GraphTimer.Stop();

                //Allow SerialPort to finish backlogged commands
                for (int i = 0; commsMngr.ptrWorkingAt != commsMngr.ptrWriteAt; i++)
                {
                    Application.DoEvents();                 //allow main thread to update GUI items (textboxes, etc)
                    System.Threading.Thread.Sleep(20);      // 50 ms
                    if (i > 100)
                    {
                        commsMngr.isReceiving = false;
                        commsMngr.TryNewCommsTask();
                    }
                }
                Application.DoEvents();
            }

            
            commsMngr.Close();
            btnConnect.Text = "Connect";
            lblStatus.Text = "Disconnected";
            pnlConnect.BackColor = System.Drawing.Color.Red;
            EnableCtrls(false);
        }


        //---Lost Connection so Disconnect and warn user---
        public void connectionLost()
        {
            MainTimer.Stop();
            commsMngr.Close();
            commsMngr.ptrWorkingAt = commsMngr.ptrWriteAt;
            pnlConnect.BackColor = System.Drawing.Color.Yellow;
            System.Threading.Thread.Sleep(200);
            lblStatus.Text = "Connection Lost : Board May Not Be Properly Turned Off";
            btnConnect.Text = "Connect";
            EnableCtrls(false);
        }


        //---Choose whether to disconnect, boot or connect then do this---
        public void btnConnect_Click(object sender, EventArgs e)
        {
            pnlConnect.BackColor = System.Drawing.Color.Yellow;
            //comErrorFound = false;

            if (commsMngr.IsOpen == true)
            {
                Disconnect();
            }
            else
            {
                //Connect Sequence               
                bool bootOnConnect = Properties.Settings.Default.BootOnConnect;

                if (bootOnConnect == true)
                {
                    Boot();
                    Application.DoEvents();
                }

                if (bootOnConnect == false || (lblStatus.Text.StartsWith("Error") == false && lblStatus.Text.StartsWith("Please") == false))
                {
                    Connect();
                }
            }
        }


        //---Enables and Disables Controls on the TabPages
        private void EnableCtrls(bool status)
        {
            int showedTabpageIndex;
            foreach (Control ctrl in tabControl1.Controls)
            {
                ctrl.Enabled = status;
            }

            showedTabpageIndex = tabControl1.SelectedIndex;
            if (status == true)
            {
                foreach (TabPage tabpage in tabControl1.TabPages)
                {
                    tabpage.Show();
                }
                tabControl1.SelectedIndex = 0;
            }
        }


        //---Get variables/arrays/data from host---
        private void GetData()
        {
            // note: varGroup[0] is skipped because it is the flash ID
            for (int i = 1; i < varGroup.Length; i++)
            {
                varGroup[i].RequestBuffer();
            }
            for (int i = 0; i < arrayGroup.Length; i++)
            {
                arrayGroup[i].RequestBuffer();
            }
        }


        //---(After [interval] ms this event triggers)---
        //---Blink LED and update the Get Group if autoUpdateOn is enabled---
        private void MainTimer_Tick(object sender, EventArgs e)
        {
            //toggle an LED
            //NewSetTask(ctrl who sent cmd, cmd#, item#, data)
            commsMngr.NewSetTask(null, 0x00, 0x00, 2);

            if (autoUpdateOn == true && this.tabControl1.SelectedIndex == 0)
            {
                //update the "get" group
                GetData();
            }

            commsMngr.TryNewCommsTask();


            //lblStatus.Text = lblStatus.Text + "Tick";    //debug
        }


        //---Change update rate when user changes the value---
        private void cmbMainUpdateRate_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbMainUpdateRate.SelectedIndex == -1)
            {
                cmbMainUpdateRate.SelectedIndex = 0;
            }
            else if (cmbMainUpdateRate.SelectedIndex == 0)
            {
                autoUpdateOn = false;
                MainTimer.Interval = 1000;   // time between update (in ms)
            }
            else
            {
                MainTimer.Interval = (int)(Convert.ToDouble(cmbMainUpdateRate.SelectedItem.ToString()) * 1000);
                autoUpdateOn = true;
            }
        }


        //---Sets all 'Set' Controls to their default state
        private void SetDefault()
        {
            int defaultValIndex = cmbMainUpdateRate.Items.IndexOf(Properties.Settings.Default.VariableUpdateInterval);
            if (defaultValIndex != -1)
            {
                cmbMainUpdateRate.SelectedIndex = defaultValIndex;
            }
            else cmbMainUpdateRate.SelectedIndex = 0;
            /*defaultValIndex = cmbGraphUpdateRate.Items.IndexOf(Properties.Settings.Default.GraphUpdateInterval);
            if (defaultValIndex != -1)
            {
                cmbGraphUpdateRate.SelectedIndex = defaultValIndex;
            }
            else cmbGraphUpdateRate.SelectedIndex = 0;
            */
            for (int i = 0; i < guiSetBtnSize; i++)
            {
                if (btnGroup[i] != null)
                {
                    btnGroup[i].SetDefault();
                }
            }

            for (int i = 0; i < guiSetTxtSize; i++)
            {
                if (txtGroup[i] != null)
                {
                    txtGroup[i].SetDefault();
                }
            }

            for (int i = 0; i < guiSetSldrSize; i++)
            {
                if (sldrGroup[i] != null)
                {
                    sldrGroup[i].SetDefault();
                }
            }
        }


        //---Restore Old Settings (internal storage or the settings stored in "[Project].exe.config")
        private void btnResetDefaults_Click(object sender, EventArgs e)
        {
            Properties.Settings.Default.Reload();

            if (commsMngr.IsOpen == true)
            {
                SetDefault();
            }
            else
            {
                propsForm.SetDefault();
            }
        }


        //---Save new Settings to Internal Storage
        private void btnSaveDefaults_Click(object sender, EventArgs e)
        {
            if (cmbMainUpdateRate.SelectedItem != null)
            {
                Properties.Settings.Default.VariableUpdateInterval = cmbMainUpdateRate.SelectedItem.ToString();
            }
            Properties.Settings.Default.Save();
        }


        //---Close sci and peripheral forms in case user closes form---
        private void TwoChannelBuck_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (btnConnect.Text == "Disconnect")
            {
                btnConnect_Click(this, new EventArgs());
            }
            propsForm.Close();
            //grphForm.Close();
            commsMngr.Close();
        }


        //***************************************
        #region Graph and Graph Timer code
        /*
        //Show the GraphForm and start the graph's timer
        public void btnShowGraph_Click(object sender, EventArgs e)
        {
            if (btnShowGraph.Text == "Show Graph")
            {
                grphForm.Show();
                btnShowGraph.Text = "Hide Graph";
                graphOn = true;
                GraphTimer.Interval = (int)(Convert.ToDouble(cmbGraphUpdateRate.SelectedItem.ToString()) * 1000);
                GraphTimer.Start();
            }
            else
            {
                GraphTimer.Stop();
                grphForm.TopMost = false;
                grphForm.Hide();
                btnShowGraph.Text = "Show Graph";
                graphOn = false;
            }
        }


        //Call GetGraphData each time the graph timer ticks
        private void GraphTimer_Tick(object sender, EventArgs e)
        {
            if (graphOn == true)
            {
                GetGraphData();
            }
        }


        //Request Data Buffer from the target
        private void GetGraphData()
        {
            for (int i = 0; i < TSGraphGroup.Length; i++)
            {
                TSGraphGroup[i].RequestBuffer();
            }
        }
        

        //Change the graph's update rate when the user changes it
        private void cmbGraphUpdateRate_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbGraphUpdateRate.SelectedIndex == -1)
            {
                cmbGraphUpdateRate.SelectedIndex = 0;
            }
            else
            {
                GraphTimer.Interval = (int)(Convert.ToDouble(cmbGraphUpdateRate.SelectedItem.ToString()) * 1000);
            }
        }
        */
        #endregion
        //***************************************

        //Begin ProjectProperties Form
        private void btnSetupConnection_Click(object sender, EventArgs e)
        {
            Disconnect();
            Properties.Settings.Default.Reload();
            propsForm.Refresh();
            powerCycled = false;
            propsForm.Show();
        }


        #endregion



        //----------------------------------------------------------

        #region Individual Event Handlers
        //---------------------------------------------------------

        #region Button Set Event Handlers

        private void GenericEventHandler_SetBtn_BtnClick(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            btnGroup[temp].SetButton();
        }

        //**Instructions specific to this control
        //Start Up controls channel 1 enable and channel 2 enable in code
        /*private void btnStartUp_Click(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            btnGroup[temp].SetButton();

            
            if (btnGroup[temp].value == 1)
            {
                btnGroup[0].value = 1;
                //btnEnableCH1.Text = "On";
                //btnEnableCH1.ForeColor = System.Drawing.Color.Green;
                btnGroup[1].value = 1;
                btnEnableCH2.Text = "On";
                btnEnableCH2.ForeColor = System.Drawing.Color.Green;
            }
            else
            {
                //btnGroup[0].value = 0;
                //btnEnableCH1.Text = "Off";
                //btnEnableCH1.ForeColor = System.Drawing.Color.Red;
                //btnGroup[1].value = 0;
                //btnEnableCH2.Text = "Off";
                //btnEnableCH2.ForeColor = System.Drawing.Color.Red;
            }
            //**
        }*/

        #endregion



        #region Text Set Event Handlers

        private void GenericEventHandler_SetTxt_TxtChanged(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            txtGroup[temp].CheckValidity();
        }

        private void GenericEventHandler_SetTxt_TxtKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                int temp = (int)((Control)sender).Tag;
                txtGroup[temp].SetText();
            }
        }

        private void GenericEventHandler_SetTxt_BtnClick(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            txtGroup[temp].SetText();
        }

        #endregion



        #region Slider Set Event Handlers
        private void GenericEventHandler_SetSldr_SldrScroll(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            sldrGroup[temp].SetSlider();
        }

        private void GenericEventHandler_SetSldr_TxtKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                int temp = (int)((Control)sender).Tag;
                sldrGroup[temp].SetText();
            }
        }

        private void GenericEventHandler_SetSldr_TxtChanged(object sender, EventArgs e)
        {
            int temp = (int)((Control)sender).Tag;
            sldrGroup[temp].CheckValidity();
        }
        #endregion

        #endregion


        private void chbMergeLedSliders_CheckedChanged(object sender, EventArgs e)
        {
            if (chbMergeLedSliders.Checked == true)
            {
                commsMngr.NewSetTask(null, 0x01, 0x00, 1);

                pnlLEDControl2.Enabled = false;
                pnlLEDControl3.Enabled = false;
                pnlLEDControl4.Enabled = false;
                pnlLEDControl5.Enabled = false;
                pnlLEDControl6.Enabled = false;
                pnlLEDControl7.Enabled = false;
                pnlLEDControl8.Enabled = false;

                pnlLedLabel2.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel3.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel4.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel5.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel6.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel7.BackColor = System.Drawing.Color.LightGray;
                pnlLedLabel8.BackColor = System.Drawing.Color.LightGray;

                lblString1LblforPanel.Text = "String 1 - 8:";

                Application.DoEvents();
            }
            else
            {
                commsMngr.NewSetTask(null, 0x01, 0x00, 0);

                pnlLedLabel2.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel3.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel4.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel5.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel6.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel7.BackColor = System.Drawing.Color.DimGray;
                pnlLedLabel8.BackColor = System.Drawing.Color.DimGray;

                pnlLEDControl2.Enabled = true;
                pnlLEDControl3.Enabled = true;
                pnlLEDControl4.Enabled = true;
                pnlLEDControl5.Enabled = true;
                pnlLEDControl6.Enabled = true;
                pnlLEDControl7.Enabled = true;
                pnlLEDControl8.Enabled = true;

                lblString1LblforPanel.Text = "String 1:";

                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed2, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed3, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed4, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed5, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed6, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed7, null);
                GenericEventHandler_SetSldr_SldrScroll(sldrIsetLed8, null);

                Application.DoEvents();
            }
        }

        //-----------------------------------------------------------
    }
}