/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

#ifndef USE_PERIPHERAL_FRAMES
#define USE_PERIPHERAL_FRAMES
#endif

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// MCANA -> myMCAN0 Pinmux
//
//
// MCANA_RX - GPIO Settings
//
#define GPIO_PIN_MCANA_RX 65
#define myMCAN0_MCANRX_GPIO 65
#define myMCAN0_MCANRX_PIN_CONFIG GPIO_65_MCANA_RX
//
// MCANA_TX - GPIO Settings
//
#define GPIO_PIN_MCANA_TX 64
#define myMCAN0_MCANTX_GPIO 64
#define myMCAN0_MCANTX_PIN_CONFIG GPIO_64_MCANA_TX

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for myMCAN0_INT1 -> INT_MCANA_1
#define myMCAN0_INT1 INT_MCANA_1
__attribute__((interrupt("INT"))) extern void MCANIntr1ISR(void);

// Interrupt Settings for myMCAN0_INT0 -> INT_MCANA_0
#define myMCAN0_INT0 INT_MCANA_0
__attribute__((interrupt("INT"))) extern void MCANIntr0ISR(void);

//*****************************************************************************
//
// MCAN Configurations
//
//*****************************************************************************
#define myMCAN0_BASE MCANA_DRIVER_BASE
#define ESM_EVENT_myMCAN0 ESM_EVENT_MCANA
//
// Defines
//
#define myMCAN0_MCAN_STD_ID_FILT_START_ADDR     (0)
#define myMCAN0_MCAN_STD_ID_FILTER_NUM          (1)
#define myMCAN0_MCAN_EXT_ID_FILT_START_ADDR     (48)
#define myMCAN0_MCAN_EXT_ID_FILTER_NUM          (1)
#define myMCAN0_MCAN_TX_BUFF_START_ADDR         (148)
#define myMCAN0_MCAN_TX_BUFF_SIZE               (10)
#define myMCAN0_MCAN_FIFO_1_START_ADDR          (748)
#define myMCAN0_MCAN_FIFO_1_NUM                 (10)
#define myMCAN0_MCAN_TX_EVENT_START_ADDR        (255)
#define myMCAN0_MCAN_TX_EVENT_SIZE              (10)
#define myMCAN0_MCAN_RX_BUFF_START_ADDR         (948)
#define myMCAN0_MCAN_FIFO_0_START_ADDR          (548)
#define myMCAN0_MCAN_FIFO_0_NUM                 (10)

#define myMCAN0_MCAN_INTR_LINE_NUM_1_INT (MCAN_INTR_MASK_ALL)
void myMCAN0_init();


//*****************************************************************************
//
// RTDMA1 MPU Configurations
//
//*****************************************************************************


//*****************************************************************************
//
// RTDMA2 MPU Configurations
//
//*****************************************************************************


//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	INTERRUPT_init();
void	MCAN_SYSCFG_init();
void	PinMux_init();
void	PERCONFIG_init();
void	RTDMA1_MPU_init();
void	RTDMA2_MPU_init();
void	GPIO_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
