
//------------------------------------------------------------------------------------------------------------------------------------------
#include "F28x_Project.h"
#include "F2837xD_device.h"
#include "F2837xD_Examples.h"
#include "device.h"
#include "driverlib.h"
#include "stdio.h"
//------------------------------------------------------------------------------------------------------------------------------------------
__interrupt void cpu_epwm1_isr(void);
void ConfigureADC(void);
void SetupADCSoftware(void);
void ADC_Calibration(void);
void InitDaca(void); // DAC A Configure
void InitEPwm1(void);
//------------------------------------------------------------------------------------------------------------------------------------------
volatile Uint16 DAC1=0,i=0,I_SENSE;
float I_SENSE1,data[2000],data1[2000],data2[2000],data3[2000],data4[2000],data5[2000],data6[2000],data7[2000],data8[2000],data9[2000],data10[2000],data11[2000],data12[2000];

//------------------------------------------------------------------------------------------------------------------------------------------
void main(void)
{




    // Initialisation
    Device_init();
    Device_initGPIO();
    InitDaca(); // Configure DAC A

    EALLOW;
    GpioCtrlRegs.GPAMUX1.bit.GPIO2=0;
    GpioCtrlRegs.GPADIR.bit.GPIO2=1;
    EDIS;

    EALLOW;
    CpuSysRegs.PCLKCR2.bit.EPWM1=1; // EPWM1 Module clock is turned ON
    EDIS;

//    InitEPwm1Gpio(); // Make GPIO0 and GPIO1 to act as EPWM

//    EALLOW;
//    ClkCfgRegs.PERCLKDIVSEL.bit.EPWMCLKDIV=0; // 0-To make EPWM clock = SYSCLK = 200 Mhz, 1-EPWM clock = SYSCLK/2
//    EDIS;

    Interrupt_initModule(); //Initializes the PIE control registers by setting them to a known state.

    Interrupt_initVectorTable();      //! Initializes the PIE vector table by setting all vectors to a default handler function.

    DINT;
    IER = 0x0000;
    IFR = 0x0000;

    EALLOW;
    Interrupt_register(INT_EPWM1, &cpu_epwm1_isr);
    EDIS;

    IER |= M_INT3;
    Interrupt_enable(INT_EPWM1);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP3);

    EINT; // Enable Global interrupt INTM
    ERTM; // Enable Global real-time interrupt DBGM

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 0;
    EDIS;

    InitEPwm1();

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;

    ConfigureADC(); // Configure the ADCs and power them up
    SetupADCSoftware(); // Setup the ADCs for software conversions

    while(1)
    {
//        while(AdcaRegs.ADCINTFLG.bit.ADCINT1 == 0); // Wait for ADC SOC to complete, then acknowledge flag
//        AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
//        AdcaRegs.ADCINTOVFCLR.bit.ADCINT1 = 1;
//          data;

     }
}
//------------------------------------------------------------------------------------------------------------------------------------------
__interrupt void cpu_epwm1_isr(void)
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3; // Acknowledge interrupt

    ADC_Calibration(); // Converting the ADC values to original (actual) values

    data[i]= I_SENSE1;

    if (i>1999)
    {
        i=0;
    }



    i=i+1;

    GpioDataRegs.GPATOGGLE.bit.GPIO2=1;

//    I_SENSE = (Uint16)(3.3+I_SENSE1)/6.6*4095;
    DacaRegs.DACVALS.bit.DACVALS = I_SENSE;

    EPwm1Regs.ETCLR.bit.INT = 1; // Clears the ETFLG[INT] flag bit and enable further interrupts pulses to be generated

//   Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP3);
}
//------------------------------------------------------------------------------------------------------------------------------------------
void ADC_Calibration(void)
{
//    I_SENSE = AdcaResultRegs.ADCRESULT1;
    I_SENSE1 = ((float)AdcaResultRegs.ADCRESULT1-32768)/32767*3.3;
}


//------------------------------------------------------------------------------------------------------------------------------------------
void InitDaca(void)
{
    EALLOW;
    // Configure DAC A control registers
    DacaRegs.DACCTL.bit.DACREFSEL = 1;
    DacaRegs.DACCTL.bit.LOADMODE = 0;

    // Enable DAC A output
    DacaRegs.DACOUTEN.bit.DACOUTEN = 1;
    DacaRegs.DACVALS.bit.DACVALS = I_SENSE;

    DELAY_US(100); // Delay for buffered DAC to power up
    EDIS;
}
//------------------------------------------------------------------------------------------------------------------------------------------
void InitEPwm1()
{
    // Setup TBCLK
    EPwm1Regs.TBPRD = 199; // Set timer period
    EPwm1Regs.TBPHS.bit.TBPHS = 0x0000; // Phase is 0
    EPwm1Regs.TBCTR = 0x0000; // Clear counter

    // Set Compare values
    EPwm1Regs.CMPA.bit.CMPA = 10; // Set compare A value

    // Setup counter mode
    EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP; // Count up and down
    EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE; // Disable phase loading
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0; // Clock ratio to SYSCLKOUT
    EPwm1Regs.TBCTL.bit.CLKDIV = 0;

//    // Setup shadowing
//    EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;
//    EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
//    EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO; // Load on Zero
//    EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    // Set actions
    EPwm1Regs.AQCTLA.bit.CAU = AQ_TOGGLE; // Set PWM1A on event A, up count
    EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;

//    EPwm1Regs.DBCTL.all = 0x0000;
//    EPwm1Regs.DBCTL.bit.OUT_MODE = 3; // Enable dead-band module
//    EPwm1Regs.DBCTL.bit.POLSEL = 2; // Active Hi complementary
//    EPwm1Regs.DBFED.all = 200; // FED = 200 TBCLKs --> 1 us
//    EPwm1Regs.DBRED.all = 200; // RED = 200 TBCLKs --> 1 us

    EPwm1Regs.TBCTL.bit.SYNCOSEL = 1;

    EPwm1Regs.ETSEL.bit.INTEN = 1; // Enable ePWM1 Interrupt generation
    EPwm1Regs.ETSEL.bit.INTSEL = 2; // Enable event time-base counter equal to CMPA when the timer is incrementing
    EPwm1Regs.ETPS.bit.INTPRD = 1; //Generate interrupt on 1st event

    EALLOW;
    EPwm1Regs.ETSEL.bit.SOCASEL = 1; // Generate SOCA event on ePWM1 timer zero
    EPwm1Regs.ETPS.bit.SOCAPRD = 1; // Generate pulse on 1st event. Generates SOCA event on EVERY ePWM1 timer zero
    EPwm1Regs.ETSEL.bit.SOCAEN = 1; // Enable EPWMxSOCA pulse
    EPwm1Regs.ETCLR.bit.SOCA = 1;
    EDIS;

}
//------------------------------------------------------------------------------------------------------------------------------------------
void ConfigureADC(void)
{
    EALLOW;
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6; //set ADCCLK divider to 100MHz/2
    AdcaRegs.ADCCTL2.bit.RESOLUTION=1;
    AdcaRegs.ADCCTL2.bit.SIGNALMODE=1;
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS= 1; // Set pulse positions to late
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1; // power up the ADCs
    EDIS;

    DELAY_US(1000); // Delay for 1ms to allow ADC time to power up
}
//------------------------------------------------------------------------------------------------------------------------------------------
void SetupADCSoftware(void)
{
//    Uint16 acqps;

     // Select the channels to convert and end of conversion flag
    EALLOW;

    AdcaRegs.ADCSOC1CTL.bit.CHSEL = 2; // SOC1 will convert pin A2
    AdcaRegs.ADCSOC1CTL.bit.ACQPS = 63; // Sample window is acqps + 1 SYSCLK cycles
    AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 5; // SOC1 will begin conversion on ePWM1 SOCA
    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 1; //EOC1 will set INT1 flag
    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1; //enable INT1 flag
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //make sure INT1 flag is cleared

    EDIS;
}
