//----------------------------------------------------------------------------------
//	FILE:			{ProjectName}-Settings.h
//
//	Description:    This file contains the definitions for this project
//
//	Type: 			Device Independent
//
//----------------------------------------------------------------------------------
//  Copyright Texas Instruments  2010
//----------------------------------------------------------------------------------
//  Revision History:
//----------------------------------------------------------------------------------
//  Date	  | Description / Status
//----------------------------------------------------------------------------------
// 8 April 2013 - MB
//----------------------------------------------------------------------------------

#ifndef _PROJSETTINGS_H
#define _PROJSETTINGS_H

//**********************************************************************************
//  NOTE: WHEN CHANGING THIS FILE PLEASE REBUILD ALL
//**********************************************************************************

//==================================================================================
// Incremental Build options for System check-out
//==================================================================================
// BUILD 1 	 Open Loop Check the Inverter and the DC-DC Flyback Stage, software test for SPLL
// BUILD 2   Closed Current Loop Inverter with forced/internal sine angle and Closed Current Loop DC-DC Flyback
// BUILD 3   Complete Closed loop operation test
// if BUILD==3 and 2 then
// GRID_CONNECT 0 without the Grid (Resistive load at the inverter output, forced sine angle)
// GRID_CONNECT 1 with the Grid
// MPPT 0 MPPT is off you can use a DC power supply instead of the PV panel, a fixed current will be commanded
// MPPT 1 MPPT is on, connect only a PV panel or a PV panel emulator
#define INCR_BUILD 3
#define GRID_CONNECT 1
#define MPPT 0
		
//==================================================================================
// System Settings
//----------------------------------------------------------------------------------
//Add any system specific setting below

#ifndef CPU_FREQ
#define CPU_FREQ 60000000
#endif

#define GRID_FREQ	60
#define PI 3.141592653589
#define INV_FREQ    50000.0
#define INV_DEADBAND 20
#define INV_PWM_PERIOD (CPU_FREQ/(INV_FREQ*2))
#define OFFSET_GRIDCURRENT_MEAS _IQ24(0.553)


#define FLYBACK_FREQ    100000.0
#define FLYBACK_DEADBAND_RED 3
#define FLYBACK_DEADBAND_FED 5
#define FLYBACK_PWM_PERIOD (CPU_FREQ/(FLYBACK_FREQ*2))
#define OFFSET_PV_SENSEVOLT_MEAS _IQ24(0.3939)
#define OFFSET_PV_SENSECURR_MEAS _IQ24(0.03)
#define OFFSET_DC_BUS_MEAS _IQ24(0.008)
#define PV_CURR_SENSE_MAX 15.0
#define PV_VOL_SENSE_MAX 138.0
#define VBUS_VOL_SENSE_MAX 418.0

#define AC_PEAK_SENSE 418
#define DC_BUS_REF_60HZ _IQ24(0.657) // 0.657 corresponds to 0.657*418=275V DC bus regulation
#define DC_BUS_RELAY_CONNECT_VOLT_60HZ _IQ24(0.598) //0.598 corresponds to 0.598*418=250V
#define DC_BUS_INV_START_VOLT_60HZ _IQ24(0.669) //0.669*418=280V
#define DC_BUS_UNDERVOLTAGE_LIMIT_60HZ _IQ24(0.526) // 0.526 corresponds to 0.526*418=220V
#define DC_BUS_OVERVOLTAGE_LIMIT_60HZ _IQ24(0.95) // 0.897 corresponds to 0.897*418 = 397V

#define DC_BUS_RELAY_CONNECT_VOLT_50HZ _IQ24(0.8373) //0.8373*418=350V
#define DC_BUS_REF_50HZ _IQ24(0.9210) // 0.9210*418=385V DC bus regulation
#define DC_BUS_INV_START_VOLT_50HZ _IQ24(0.922) // 0.922*418= 386
#define DC_BUS_UNDERVOLTAGE_LIMIT_50HZ _IQ24(0.8373) //0.85*418=350
#define DC_BUS_OVERVOLTAGE_LIMIT_50HZ _IQ24(0.998) // 0.998*418=417

#define INV_UNDERVOLT_LIMIT
#define INV_OVERVOLT_LIMIT
#define GRID_OVER_UNDER_FREQ_LIMIT 3 // 3Hz tolerance wrt to center grid frequency
#define GRID_OVER_UNDER_VRMS_LIMIT 35
#define UNIVERSAL_GRID_MAX_FREQ 64
#define UNIVERSAL_GRID_MIN_FREQ 46
#define UNIVERSAL_GRID_MAX_VRMS 240
#define UNIVERSAL_GRID_MIN_VRMS 90
#define CAP_MIN_FREQ_MEAS 40

#define VPV_MIN		_IQ7(15.0)

#define ISR_FREQUENCY 50000.0

// SPLL Settings
//#define ISR_FREQ_20KHZ
#define ISR_FREQ_50KHZ

#define B0_LPF (166.7618719)
#define B1_LPF (-166.4785831)
#define A1_LPF (-1.0)

#define HistorySize 8
//#define DLOG_SIZE   200

#define Isqrt2 _IQ24(0.70710678)	// 1/sqrt(2)
#define Gv_Inv _IQ15(1500)		// 3.3/0.083
#define KvInv _IQ15(313.5)				// 3.3/0.083
#define VdcRef	 _IQ24(0.75)

/**
 * ADC trigger-source definitions.
 */
#define ADCTRIG_SOFT		0
#define ADCTRIG_CPU_TINT0	1
#define ADCTRIG_CPU_TINT1	2
#define ADCTRIG_CPU_TINT2	3
#define ADCTRIG_XINT2		4
#define ADCTRIG_EPWM1_SOCA	5
#define ADCTRIG_EPWM1_SOCB	6
#define ADCTRIG_EPWM2_SOCA	7
#define ADCTRIG_EPWM2_SOCB	8
#define ADCTRIG_EPWM3_SOCA	9
#define ADCTRIG_EPWM3_SOCB	10
#define ADCTRIG_EPWM4_SOCA	11
#define ADCTRIG_EPWM4_SOCB	12
#define ADCTRIG_EPWM5_SOCA	13
#define ADCTRIG_EPWM5_SOCB	14
#define ADCTRIG_EPWM6_SOCA	15
#define ADCTRIG_EPWM6_SOCB	16
#define ADCTRIG_EPWM7_SOCA	17
#define ADCTRIG_EPWM7_SOCB	18

#endif //_PROJSETTINGS_H

