/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * #file           : main.c
  * #brief          : High-Frequency Micro-Inverter Test Project
  * #author         : Pranav Ananthakumar
  * #mcu            : TMS320F280049
  * #date           : 25-08-2022
  ******************************************************************************
  * #copyright Havells India 2022
  * #attention
  *
  * * <h2><center>&copy; Copyright (c) 2022 Havells India Ltd.
  * All rights reserved.</center></h2>
  *
  * This software component is property of Havells India Ltd
  ******************************************************************************
  */
#include "F28x_Project.h"
#include <math.h>
#include "epwm.h"
#include "sysctl.h"
#include "stdlib.h"
#include "string.h"

#define EPWM_TBPRD                              500                 // TBPRD Count Value 100Khz PWM
#define DB_FED                                  30                  // Falling edge delay of 0.6us
#define DB_RED                                  30                  // Rising edge delay of 0.6us
#define GPIO_MUX_POS0                           0                   // Digital pin mux setting for GPIO functionality
#define OMEGA                                   5.48311356          // 2 * pi * 50

void configEPWM5(void);

void initADC(void);
void initADCSOC(void);

__interrupt void ADC_A1_ISR(void);

float gf16Sine;

void main(void)
{


        memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize);

		gf16Sine = 0.0;

        //
        // Initialize device clock and peripherals
        //
        InitSysCtrl();
        //
        // Initialize GPIO

        InitGpio();

        GPIO_SetupPinMux(12, GPIO_MUX_CPU1, GPIO_MUX_POS0);
        GPIO_SetupPinOptions(12, GPIO_OUTPUT, GPIO_PUSHPULL);

        DINT; // Disable interrupts

        InitPieCtrl();

        IER = 0x0000;
        IFR = 0x0000;
        //
        // Initialize the PIE vector table with pointers to the shell Interrupt
        // Service Routines (ISR).
        //
        InitPieVectTable();
        //
        // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
        //
        //
        // Map ISR functions
        //

        EALLOW;
        //PieVectTable.EPWM1_TZ_INT = &epwm1_TZ_ISR;            // ePWM1 trip-zone interrupt mapped
        PieVectTable.ADCA1_INT = &ADC_A1_ISR;                   // ADCA1 ISR interrupt mapped
        EDIS;

        //
        // Enable global Interrupts and higher priority real-time debug events:
        //
        IER |= M_INT1 | M_INT2;                                 // Enable group 1 and group 2 and group 3 interrupts

        EINT; // Enable interrupts
        ERTM; // Enable Global realtime interrupt DBGM

        //
        // Enable PIE interrupt
        //
        PieCtrlRegs.PIEIER1.bit.INTx1 = 1;                      // ADCA1 interrupt

        configEPWM5();                                          // PWM configuration to trigger ADC at 100 kHz i.e. 10 us

        initADC();
        initADCSOC();

        while(1)
        {

        }
}

__interrupt void ADC_A1_ISR(void)                               // ADC A1 interrupt running at 10 us
{
   // GpioDataRegs.GPBTOGGLE.bit.GPIO44 = 1;
   // GpioDataRegs.GPBCLEAR.bit.GPIO44 = 1;


    gf16Sine = sin(M_PI);

    //
    // Clear the interrupt flag
    //
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    //
    // Check if overflow has occurred
    //
    if(1 == AdcaRegs.ADCINTOVF.bit.ADCINT1)
    {
        AdcaRegs.ADCINTOVFCLR.bit.ADCINT1 = 1; //clear INT1 overflow flag
        AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //clear INT1 flag
    }
    //
    // Acknowledge the interrupt
    //
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

void configEPWM5(void)
{
    EALLOW;

        EPwm5Regs.TBPRD = 5000; //period-1;             // PWM frequency = 1 / period
        EPwm5Regs.TBPHS.bit.TBPHS = 0;  // phase = 0 // same as EPwm1
        EPwm5Regs.TBCTR = 0;

        EPwm5Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;
        EPwm5Regs.TBCTL.bit.PHSEN = TB_DISABLE;
        EPwm5Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;
        EPwm5Regs.TBCTL.bit.CLKDIV = TB_DIV1;

        EPwm5Regs.ETSEL.bit.SOCAEN = 1;     // Disable SOC on A group
        EPwm5Regs.ETSEL.bit.SOCASEL = 4;    // Select SOC on up-count
        EPwm5Regs.ETPS.bit.SOCAPRD = 1;     // Generate pulse on 1st event

        EPwm5Regs.CMPA.bit.CMPA=EPWM_TBPRD/2;

    EDIS;

}

void initADC()
{
    // Setup VREF as internal
    SetVREF(ADC_ADCA, ADC_INTERNAL, ADC_VREF3P3);
    SetVREF(ADC_ADCC, ADC_INTERNAL, ADC_VREF3P3);
    EALLOW;
    //
    // Set ADCCLK divider to /4
    //
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
    AdccRegs.ADCCTL2.bit.PRESCALE = 6;
    //
    // Set pulse positions to late
    //
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1; // Interrupt pulse generation occurs at the end of the conversion, 1 cycle prior to the ADC result latching into its result register
    AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;
    //
    // Power up the ADC and then delay for 1 ms
    //
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    EDIS;
}

void initADCSOC()
{
    // Select the channels to convert and the end of conversion
    EALLOW;

    // SOC0 will convert pin A1  0:A0  1:A1  2:A2  3:A3 4:A4   5:A5   6:A6   7:A7 8:A8   9:A9   A:A10  B:A11 C:A12  D:A13  E:A14  F:A15

    AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;                          // Channel A0
    AdcaRegs.ADCSOC0CTL.bit.ACQPS = 9;                          // Sample window is 10 SYSCLK cycles
    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 0x0D;                     // Trigger on ePWM5 SOCA

    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;                      // End of EOC0 will set INT1 flag
    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;                        // Enable INT1 flag
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;                      // Make sure INT1 flag is cleared

    EDIS;
}
