-a -c -w
-stack 0x500
-heap  32

MEMORY
   {
   PAGE 0 :
      RESET                : origin = 0x3FFFC0, length = 0x000002

      APP_CODEAREA         : origin = 0x86000,  length = 0x3A000

   PAGE 1 :
      RAMLS6               : origin = 0x00B000, length = 0x000800    // CLA Program Memory
      RAMLS7               : origin = 0x00B800, length = 0x000800    // CLA Data Memory
      RAMGS0               : origin = 0x00C000, length = 0x003000

      CLA1_MSGRAMLOW       : origin = 0x001480, length = 0x000080
      CLA1_MSGRAMHIGH      : origin = 0x001500, length = 0x000080
   }

SECTIONS
   {

   GROUP                : > APP_CODEAREA     PAGE = 0,   ALIGN(4)
      {
      .cinit
      .text
      }

   .reset               : > RESET            PAGE = 0,   TYPE = DSECT
   .ebss                : > RAMGS0           PAGE = 1

   Cla1ToCpuMsgRam      : > CLA1_MSGRAMLOW               TYPE = NOINIT
   CpuToCla1MsgRam      : > CLA1_MSGRAMHIGH              TYPE = NOINIT

   Cla1Prog             :  LOAD = APP_CODEAREA,
                           RUN = RAMLS6,
                           LOAD_START(_Cla1funcsLoadStart),
                           LOAD_END(_Cla1funcsLoadEnd),
                           RUN_START(_Cla1funcsRunStart),
                           LOAD_SIZE(_Cla1funcsLoadSize),
                           ALIGN(8)


   .scratchpad          : > RAMLS7
   .bss_cla	            : > RAMLS7
   }
