//###########################################################################
// FILE:   CPU_Base.c
// CCS Project:
// TITLE:  National Grid Project - Deliverable 1 base code
// Current Version date: 26/06/2018
// Authors: Ed Christopher - Jordi Espina - Behzad Ahmadi -
//
// This file contains definitions of parameters and functions
//
//###########################################################################

#ifndef BOARD_DELFINO28379D_H_
#define BOARD_DELFINO28379D_H_


#include "F28x_Project.h"     // Device Header file and Examples Include File
#include "F2837xD_Device.h"     // Device header File
#include "F2837xD_Ipc_drivers.h"
#include <math.h>
#include <stdio.h>
#include <float.h>
#include "Data_Capture.h"
#include "Host_Comm_v2.h"


//FPGA Memory

#define ASRAM_CS2_START_ADDR 0x00100000

#define ASRAM_CS3_START_ADDR 0x00300000
#define ASRAM_CS3_MEM_SIZE   0x100000

#define FPGA_REG_00 0x00300000
#define FPGA_REG_01 0x00300001
#define FPGA_REG_02 0x00300002
#define FPGA_REG_03 0x00300003
#define FPGA_REG_04 0x00300004
#define FPGA_REG_05 0x00300005
#define FPGA_REG_06 0x00300006
#define FPGA_REG_07 0x00300007
#define FPGA_REG_08 0x00300008
#define FPGA_REG_09 0x00300009
#define FPGA_REG_10 0x0030000A
#define FPGA_REG_11 0x0030000B
#define FPGA_REG_12 0x0030000C
#define FPGA_REG_13 0x0030000D
#define FPGA_REG_14 0x0030000E
#define FPGA_REG_15 0x0030000F
#define FPGA_REG_16 0x00300010
#define FPGA_REG_17 0x00300011
#define FPGA_REG_18 0x00300012
#define FPGA_REG_19 0x00300013
#define FPGA_REG_20 0x00300014
#define FPGA_REG_21 0x00300015
#define FPGA_REG_22 0x00300016
#define FPGA_REG_23 0x00300017
#define FPGA_REG_24 0x00300018
#define FPGA_REG_25 0x00300019
#define FPGA_REG_26 0x0030001A
#define FPGA_REG_27 0x0030001B
#define FPGA_REG_28 0x0030001C
#define FPGA_REG_29 0x0030001D
#define FPGA_REG_30 0x0030001E
#define FPGA_REG_31 0x0030001F

#define FPGA_REG_32 0x00300020
#define FPGA_REG_33 0x00300021
#define FPGA_REG_34 0x00300022
#define FPGA_REG_35 0x00300023
#define FPGA_REG_36 0x00300024
#define FPGA_REG_37 0x00300025
#define FPGA_REG_38 0x00300026
#define FPGA_REG_39 0x00300027
#define FPGA_REG_40 0x00300028
#define FPGA_REG_41 0x00300029
#define FPGA_REG_42 0x0030002A
#define FPGA_REG_43 0x0030002B
#define FPGA_REG_44 0x0030002C
#define FPGA_REG_45 0x0030002D
#define FPGA_REG_46 0x0030002E
#define FPGA_REG_47 0x0030002F
#define FPGA_REG_48 0x00300030
#define FPGA_REG_49 0x00300031
#define FPGA_REG_50 0x00300032
#define FPGA_REG_51 0x00300033
#define FPGA_REG_52 0x00300034
#define FPGA_REG_53 0x00300035
#define FPGA_REG_54 0x00300036
#define FPGA_REG_55 0x00300037
#define FPGA_REG_56 0x00300038
#define FPGA_REG_57 0x00300039
#define FPGA_REG_58 0x0030003A
#define FPGA_REG_59 0x0030003B
#define FPGA_REG_60 0x0030003C
#define FPGA_REG_61 0x0030003D
#define FPGA_REG_62 0x0030003E
#define FPGA_REG_63 0x0030003F

#define FPGA_REG_64 0x00300040
#define FPGA_REG_65 0x00300041
#define FPGA_REG_66 0x00300042
#define FPGA_REG_67 0x00300043
#define FPGA_REG_68 0x00300044
#define FPGA_REG_69 0x00300045
#define FPGA_REG_70 0x00300046
#define FPGA_REG_71 0x00300047
#define FPGA_REG_72 0x00300048
#define FPGA_REG_73 0x00300049
#define FPGA_REG_74 0x0030004A
#define FPGA_REG_75 0x0030004B
#define FPGA_REG_76 0x0030004C
#define FPGA_REG_77 0x0030004D
#define FPGA_REG_78 0x0030004E
#define FPGA_REG_79 0x0030004F
#define FPGA_REG_80 0x00300050
#define FPGA_REG_81 0x00300051
#define FPGA_REG_82 0x00300052
#define FPGA_REG_83 0x00300053
#define FPGA_REG_84 0x00300054
#define FPGA_REG_85 0x00300055
#define FPGA_REG_86 0x00300056
#define FPGA_REG_87 0x00300057
#define FPGA_REG_88 0x00300058
#define FPGA_REG_89 0x00300059

#define FPGA_REG_90  0x0030005A
#define FPGA_REG_91  0x0030005B
#define FPGA_REG_92  0x0030005C
#define FPGA_REG_93  0x0030005D
#define FPGA_REG_94  0x0030005E
#define FPGA_REG_95  0x0030005F
#define FPGA_REG_96  0x00300060
#define FPGA_REG_97  0x00300061
#define FPGA_REG_98  0x00300062
#define FPGA_REG_99  0x00300063
#define FPGA_REG_100 0x00300064
#define FPGA_REG_101 0x00300065
#define FPGA_REG_102 0x00300066
#define FPGA_REG_103 0x00300067
#define FPGA_REG_104 0x00300068
#define FPGA_REG_105 0x00300069
#define FPGA_REG_106 0x0030006A
#define FPGA_REG_107 0x0030006B
#define FPGA_REG_108 0x0030006C
#define FPGA_REG_109 0x0030006D
#define FPGA_REG_110 0x0030006E
#define FPGA_REG_111 0x0030006F
#define FPGA_REG_112 0x00300070
#define FPGA_REG_113 0x00300071
#define FPGA_REG_114 0x00300072
#define FPGA_REG_115 0x00300073

#define FPGA_REG_116 0x00300074
#define FPGA_REG_117 0x00300075
#define FPGA_REG_118 0x00300076
#define FPGA_REG_119 0x00300077
#define FPGA_REG_120 0x00300078
#define FPGA_REG_121 0x00300079

// ##########################################################################
//												Parameters		   			#
// ##########################################################################


// ##########################################################################
//                                              Constants                   #
// ##########################################################################

#define pi		3.14159265358979323846
#define pi_3	1.04719755119659774615
#define pi_2_3	2.09439510239319549231
#define pi2		6.28318530717958647692


// ##########################################################################
//												Functions		   			#
// ##########################################################################

/********************************************************************************
						 shared global function prototypes
*********************************************************************************/

extern void Board_interrupts_EN(void);	// Enable Necessary interrupts in the board
extern void Board_interrupts_Assign(void); // Assign interrupt routines to CPU
extern void Initialise_CPU1(void);
extern void Initialise_Timer(void);

/********************************************************************************
						 interrupt routines
*********************************************************************************/

interrupt void CPU1_Main_Int(void);
interrupt void cpu_timer0_isr(void);
interrupt void scibRxFifoIsr(void);
interrupt void scicRxFifoIsr(void);

#endif /* BOARD_DELFINO28379D_H_ */
