//###########################################################################
// FILE:   CPU_Base.c
// CCS Project:
// TITLE:  National Grid Project - Deliverable 1 base code
// Current Version date: 26/06/2018
// Authors: Ed Christopher - Jordi Espina - Behzad Ahmadi -

// This program contains the functions related to the DSP-FPGA development board
//
//
//###########################################################################
// Library used:
// $TI Release: F2837xD Support Library v210 $
//###########################################################################

// ##################################################################################################
//											Include Files			  								#
// ##################################################################################################
#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837xD_Ipc_drivers.h"
#include "Board_Delfino28379D.h"
#include "F2837xD_spi.h"
//#include "SCI_Code_V1.h"
#include "EMIF.h"




// ##################################################################################################
//											Globals					  								#
// ##################################################################################################
int send_TX = 0;
extern Uint16 counter;
Uint16  ErrCount = 0;

// ##################################################################################################
//								 Initialisation program CPU1										#
// ##################################################################################################
void Initialise_CPU1(void)
{


/********************************************************************************
		Initialising uPP Vectors and Transmit RAM
*********************************************************************************/

 // Disable CPU interrupts
 DINT;

/********************************************************************************
     Initialisation of read/write pin between DSP-FPGA
*********************************************************************************/
   InitGpio();

#ifdef _DEMOBRD

   EALLOW;
   GpioCtrlRegs.GPADIR.bit.GPIO31 = 1;  //LED LaunchpadXL
   GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;  //LED LaunchpadXL
   GpioCtrlRegs.GPBDIR.bit.GPIO56 = 1;  //SCI-C LaunchpadXL
   GpioCtrlRegs.GPEDIR.bit.GPIO139 = 0; //SCI-C LaunchpadXL
   GpioCtrlRegs.GPADIR.bit.GPIO18 = 1;  //SCI-B LaunchpadXL
   GpioCtrlRegs.GPADIR.bit.GPIO19 = 0; //SCI-B LaunchpadXL
   EDIS;

   //### Leds on Launchpad XL
   // LED for testing when connected to demo board
   GPIO_SetupPinOptions(31, GPIO_OUTPUT, GPIO_PUSHPULL);
   GPIO_SetupPinMux(31, GPIO_MUX_CPU1, 0);

   GPIO_SetupPinOptions(34, GPIO_OUTPUT, GPIO_PUSHPULL);
   GPIO_SetupPinMux(34, GPIO_MUX_CPU1, 0);

      //## SCIC on Lanuchpad XL
   // SCI for user display and testing when connected to demo board
   GPIO_SetupPinMux(56, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(56, GPIO_OUTPUT, GPIO_ASYNC);

   GPIO_SetupPinMux(139, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(139, GPIO_INPUT, GPIO_PUSHPULL);

       //## SCIB on Lanuchpad XL
    // SCI for TERMINAL and testing when connected to demo board
    GPIO_SetupPinMux(18, GPIO_MUX_CPU1, 2);
    GPIO_SetupPinOptions(18, GPIO_OUTPUT, GPIO_ASYNC);

    GPIO_SetupPinMux(19, GPIO_MUX_CPU1, 2);
    GPIO_SetupPinOptions(19, GPIO_INPUT, GPIO_PUSHPULL);



#else
   EALLOW;
   GpioCtrlRegs.GPADIR.bit.GPIO0 = 1;   //LED on NG Control Brd
   GpioCtrlRegs.GPADIR.bit.GPIO1 = 1;   //LED on NG Control Brd
   GpioCtrlRegs.GPCDIR.bit.GPIO84 = 1;  //LED on NG Control Brd
   GpioCtrlRegs.GPCDIR.bit.GPIO91 = 1;  //LED on NG Control Brd

   GpioCtrlRegs.GPCDIR.bit.GPIO67 = 0;   //User button A on NG Control Brd
   GpioCtrlRegs.GPCDIR.bit.GPIO68 = 0;   //User button B on NG Control Brd
   GpioCtrlRegs.GPBDIR.bit.GPIO53 = 0;   //User button C on NG Control Brd
   GpioCtrlRegs.GPBDIR.bit.GPIO55 = 0;   //User button D on NG Control Brd

   GpioCtrlRegs.GPBDIR.bit.GPIO56 = 1;  //SCI-C TX
   GpioCtrlRegs.GPBDIR.bit.GPIO57 = 0;  //SCI-C RX

   GpioCtrlRegs.GPADIR.bit.GPIO22 = 1;  //SCI-B TX
   GpioCtrlRegs.GPADIR.bit.GPIO23 = 0;  //SCI-B RX

   EDIS;

   GPIO_SetupPinMux(56, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(56, GPIO_OUTPUT, GPIO_ASYNC);

   GPIO_SetupPinMux(57, GPIO_MUX_CPU1, 6);
   GPIO_SetupPinOptions(57, GPIO_INPUT, GPIO_PUSHPULL);

   GPIO_SetupPinMux(22, GPIO_MUX_CPU1, 3);
   GPIO_SetupPinOptions(22, GPIO_OUTPUT, GPIO_ASYNC);

   GPIO_SetupPinMux(23, GPIO_MUX_CPU1, 3);
   GPIO_SetupPinOptions(23, GPIO_INPUT, GPIO_PUSHPULL);

   // Edwin's Initialisation of GPIO to enable PWM

   GPIO_SetupPinMux(141, GPIO_MUX_CPU1, 0);
   GPIO_SetupPinOptions(141, GPIO_INPUT, GPIO_PULLUP | GPIO_QUAL3); // Enable internal pull-up resistor



   EDIS;


#endif

   //#######

 //  GPIO_SetupPinOptions(160, GPIO_OUTPUT,GPIO_PUSHPULL);
 //  GPIO_SetupPinMux(160, GPIO_MUX_CPU1, 0);
 //  GPIO_SetupPinOptions(161, GPIO_OUTPUT,GPIO_PUSHPULL);
 //  GPIO_SetupPinMux(161, GPIO_MUX_CPU1, 0);
 //  GPIO_SetupPinOptions(154, GPIO_OUTPUT,GPIO_PUSHPULL);
//   GPIO_SetupPinMux(154, GPIO_MUX_CPU1, 0);
 //  GPIO_SetupPinOptions(173, GPIO_OUTPUT,GPIO_PUSHPULL);
 //  GPIO_SetupPinMux(173, GPIO_MUX_CPU1, 0);


#ifdef _DEMOBRD

#else
   GpioDataRegs.GPACLEAR.bit.GPIO1 = 0;// turn off LED
   GpioDataRegs.GPACLEAR.bit.GPIO0 = 0;// turn off LED
   GpioDataRegs.GPCCLEAR.bit.GPIO84 = 0;// turn off LED
   GpioDataRegs.GPCCLEAR.bit.GPIO91 = 0;// turn off LED
#endif

   // ----- GPIOs managed by CPU1
//   GPIO_SetupPinMux(73, GPIO_MUX_CPU1, 3);				// XCLK out Multiplexer set

//   ClkCfgRegs.CLKSRCCTL3.bit.XCLKOUTSEL = 0x0; 			//0:PllSysClk 1:PllRAWClk 2:CPU1 SysClock
//   ClkCfgRegs.XCLKOUTDIVSEL.bit.XCLKOUTDIV = 0x3; 		// XCLKOUT Divide Select: 0: /1, 1: /2, 2: /4, 3: /8
//   GPIO_SetupPinMux(73, GPIO_MUX_CPU1, 3);				// XCLK out Multiplexer set

  // EALLOW;
  // GpioDataRegs.GPBSET.bit.GPIO38 = 1;
  // EDIS;

 //  GPIO_SetupPinOptions(83, GPIO_INPUT, GPIO_INPUT);	// External interrupt ADC as Input
  // GPIO_SetupPinOptions(85, GPIO_INPUT, GPIO_INPUT); 	// External interrupt ADC as Input



/********************************************************************************
	Initialise the PIE control registers to their default state.
	The default state is all PIE interrupts disabled and flaLS are cleared.
	This function is found in the F2837xD_PieCtrl.c file.
*********************************************************************************/

   InitPieCtrl();



/********************************************************************************
   * Initialise asynchronous EMIF for Memory and FPGA interface
*********************************************************************************/

#ifdef _DEMOBRD

#else
   Config_EMIF();
#endif

/********************************************************************************
    * Initialise asynchronous EMIF for Memory and FPGA interface
*********************************************************************************/

   Initialise_Timer(); // Timer for serial comms interrupt


/********************************************************************************
	Disable CPU interrupts and clear all CPU interrupt flags:
*********************************************************************************/
//   EALLOW;
//   IER = 0x0000;
//   IFR = 0x0000;
 //  EDIS;

 //  Board_interrupts_Assign(); // Assigns the interrupts routines to CPU interrupts

/********************************************************************************
	Interrupt vector assignments
*********************************************************************************/
 //  Board_interrupts_EN();	// Enable Interrupts used for the controller board

 //  EnableInterrupts();	// Enable PIE & CPU level Interrupts.

}


void Initialise_Timer(void)
{
    //
    // Initialize the Device Peripheral. This function can be
    // found in F2837xD_CpuTimers.c
    //
       InitCpuTimers();   // For this example, only initialize the Cpu Timers

    //
    // Configure CPU-Timer 0 to __interrupt every 500 milliseconds:
    // 60MHz CPU Freq, 50 millisecond Period (in uSeconds)
    //
       ConfigCpuTimer(&CpuTimer0, 200, 500);
    //
    // To ensure precise timing, use write-only instructions to write to the entire
    // register. Therefore, if any of the configuration bits are changed in
    // ConfigCpuTimer and InitCpuTimers (in F2837xD_cputimervars.h), the below
    // settings must also be updated.
    //
     //  CpuTimer0Regs.TCR
       CpuTimer0Regs.TCR.all = 0x4000;
       //CpuTimer0Regs.TCR.all = 0x4001;

       //CpuTimer0Regs.TCR.bit.TSS = 1; //Disable timer
       CpuTimer0Regs.TCR.bit.TSS = 0; //Enable timer

}
