//###########################################################################
// FILE:   Board_Interrupts.c
// TITLE:  NGID project Development board program
// Current Version date: 03/10/19
// Authors: Ed Christopher, Davide Gottardo
//
// This program contains the functions related to the DSP-FPGA development board:
// -	Necessary interrupts are activated
// -	Interrupts routine functions are defined
//
//###########################################################################
// Library used:
// $TI Release: F2837xD Support Library v210 $
//###########################################################################

// ##################################################################################################
//											Include Files			  								#
// ##################################################################################################

#include "Board_Delfino28379D.h" // Custom Project Header File
#include "NG_Converter_support.h"
#include "Data_Capture2.h"

#include "utils.h"
#include "Debug.h"
#include <stdio.h>
#include <DCLF32.h> // Digital Control Lib
#include <stdint.h> // Include for int32_t data type
#include <math.h>

#include "mpc_pll.h" // Edwin added this

// ##################################################################################################
// 											Globals					  								#
// ##################################################################################################
//***** Data Capture variables

Uint16 Sampling_On = 0;
Uint16 DataCapComplete = 0;
Uint16 cap_samp = 0;
Uint16 Cap_Done_Mess = 0;

float *pData;
float *Cap_Vars[32];

float *Var_List_Loc[32];

Uint16 Curr_Samp_Inst = 0;
Uint16 NoSpINT = 0;
Uint16 Tot_No_Of_INTS = 0;

//*****************

//*** COM Port Communication Variables


extern Uint16 com_b_active;
extern Uint16 com_c_active;
extern Uint16 com_allowed;

//***********

Uint16 REG_06 = 0;
Uint16 REG_13 = 0;
Uint16 REG_14 = 0;
Uint16 REG_15 = 0;
volatile Uint16 PWM_En = 0;


// Variables for DISPLAY Update

Uint16 Dial_Data[4];
Uint16 Phase_V[4];
Uint16 Phase_I[4];

float kQ=1,kP=1;

extern float Para_Float[50];
extern int16 Para_Int[50];
//*********************

char test[10];

/*
 * VARIABLES USED FOR GRAPHIC DISPLAY OUTPUT
 */
float R=0,S=0,Q=0,Vdc=0;  //the active power is called R because P is already used
//float Va,Vb,Vc,Vn,Vnx;
//float Ia,Ib,Ic,In;
//float Vaux1,Iaux1,Vaux2,Iaux2;

struct ADCreadings_struct{
    float Vdc;
    float Va,Vb,Vc,Vn,Vnx,Vaux1,Vaux2;
    float Ia,Ib,Ic,In,Iaux1,Iaux2;
} AdcReadings;

struct Park_struct{
    float Vd, Vq, V0;
    float Id, Iq, I0;
} Park;


float VdLP=0,VqLP=0,V0LP=0;
float DCYa=0,DCYb=0,DCYc=0;

struct PLL_vars_struct{
    float theta;
    float sinTheta,cosTheta;
} PLL_vars;

/*
 * VARIABLES USED FOR DATA CAPTURE

Uint16 capture[10];
Uint16 captureCounter=0;
bool CAPTURE_FLAG=1;*/

struct CAPTURE_struct{
    Uint16 data[16];
    Uint16 counter;
    bool flag;
} CAPTURE;


//CAPTURE.counter=0;
//CAPTURE.flag=1;


#define nRMS 11 //number of RMS calculations
Uint16 RMScont[nRMS]={0,1,2,3,4,5,6,7,8,9,10};   // initialized this way so that the sqrt operation in the RMS function does not happen at the same time for all channels
float  RMSacc[nRMS] ={0,0,0,0,0,0,0,0,0,0,0};
//float TAU_RMS=1e-4,kRMS=5;


float Va2t=0,Vb2t=0,Vc2t=0,Vaux1_2t=0,Vaux2_2t=0;
float Ia2t=0,Ib2t=0,Ic2t=0,In2t=0,Iaux1_2t=0,Iaux2_2t=0;

float VaRMS,VbRMS,VcRMS;
float IaRMS,IbRMS,IcRMS,InRMS;
float Vaux1RMS,Vaux2RMS;
float Iaux1RMS,Iaux2RMS;


extern struct TRIPS_STRUCT TRIPS;

//float VdREF=.45;


/*
 * CONTROLLERS                  // This is where i will need to change the PI controller parameters
 */
float Id_REF=0,Iq_REF=0;
float VdSS=0,VqSS=0,V0SS=0;    //current controller effort
DCL_PI PI_Id={ 0.1f, 0.1, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };
DCL_PI PI_Iq={ 0.1f, 0.1, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };
DCL_PI PI_I0={ 0.1f, 0.0, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };

//DCL_PI PI_Id={ 1.212f, 1.125, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };
//DCL_PI PI_Iq={ 1.212f, 1.125, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };
//DCL_PI PI_I0={ 1.212f, 1.125, 0.0f, 800.0f, -800.0f, 1.0f, 0.0f, 1.0f, -1.0f, NULL_ADDR, NULL_ADDR };

float Tmodule1,Tmodule2; //temperature of the modules, read via internal termistor
float tauTemp=1e-4; //time constant for temperature reading low-pass


double alphaLP=1e-4;
//double alphaLP=1.59e-3;

float fREF=50; //frequency of reference waveform for park
extern float curr_FSW;

// ##################################################################################################
//									Enabling Interrupts function   					  				#
// ##################################################################################################
void Board_interrupts_EN(void)
{
/********************************************************************************
 More information about PIE mapping: See SPRUX5C.pdf page 88
*********************************************************************************/
   PieCtrlRegs.PIECTRL.bit.ENPIE = 1;          // Enable the PIE block


/********************************************************************************
						 Group12 Interrupts
*********************************************************************************/
  IER |= M_INT1; //Enable group 1 interrupts
  IER |= M_INT9; //Enable group 9 interrupts
  IER |= M_INT8; //Enable group 8 interrupts
//  IER |= M_INT6; //Enable group 6 interrupts

  EALLOW;                                  // Allows writing to protected registers.
  PieCtrlRegs.PIEIER1.bit.INTx4 = 1;       // XINT1 in group 1 is activated
  PieCtrlRegs.PIEIER1.bit.INTx7 = 1;       // Enable TINT0 in the PIE: Group 1 __interrupt 7
  //PieCtrlRegs.PIEIER9.bit.INTx3 = 1;     // PIE Group 9, INT3 SCIB RX
  PieCtrlRegs.PIEIER8.bit.INTx5 = 1;       // PIE Group 8, INT5 SCIC RX
  EDIS;                                    // Disallows writing to protected registers.

/********************************************************************************
					 External Interrupt Connection
*********************************************************************************/
// ------ Connecting the external interrupts to input module
//  Only CPU1 has access to these registers.
//  Other configurations can be done by CPU2
  EALLOW;
  InputXbarRegs.INPUT4SELECT = 62; // GPIO 62 is connected to input select 4
  EDIS;
/********************************************************************************
			 External interrupts
*********************************************************************************/
  // Connecting the external pins to Xbar module is done by CPU1 (CPU2 has no access to those settings)
  // Configure XINT1

  XintRegs.XINT1CR.bit.POLARITY = 1;          // Rising edge interrupt

// Enable XINT1
  XintRegs.XINT1CR.bit.ENABLE = 1;            // Enable XINT1

}

void Board_interrupts_Assign(void)
{
    InitPieVectTable();

    EALLOW;
	PieVectTable.XINT1_INT  = &CPU1_Main_Int;		 // CPU1 Interrupt //Group 1 interrupt 1.4
	//PieVectTable.SCIB_RX_INT = &scibRxFifoIsr;     // Group 9 interrupt 9.3
	PieVectTable.SCIC_RX_INT = &scicRxFifoIsr;
	PieVectTable.TIMER0_INT = &cpu_timer0_isr;       // Group 1 interrupt 1.7
	EDIS;
}

// ##################################################################################################
//									CPU1 Interrupts 	   					  		                #
// ##################################################################################################

//
// scibTxFifoIsr - SCIB Receive FIFO ISR
//
//#pragma CODE_SECTION(scibRxFifoIsr, ".TI.ramfunc");
/*interrupt void scibRxFifoIsr(void)
{
    //Uint16 i;
    ScibRegs.SCIFFRX.bit.RXFFIENA = 0;
    ScibRegs.SCIFFRX.bit.RXFFINTCLR=1;          // Clear SCI Interrupt flag
    ScibRegs.SCIFFRX.bit.RXFFOVRCLR=1;          // Clear Overflow flag
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP9;    // 0x100;       // Issue PIE ACK
    GpioDataRegs.GPCSET.bit.GPIO84 = 1;
    com_b_active = 1;

 }*/

//
// scicRxFifoIsr - SCIC Receive FIFO ISR

//#pragma CODE_SECTION(scicRxFifoIsr, ".TI.ramfunc");
interrupt void scicRxFifoIsr(void)
{

    ScicRegs.SCIFFRX.bit.RXFFIENA = 0;
    ScicRegs.SCIFFRX.bit.RXFFINTCLR=1;   // Clear SCI Interrupt flag
    ScicRegs.SCIFFRX.bit.RXFFOVRCLR=1;   // Clear Overflow flag
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP8;   ;//0x100;       // Issue PIE ACK

    com_c_active = 1;
}


//
// scicTxFifoIsr - SCIC Transmit FIFO ISR
//
interrupt void scicTxFifoIsr(void)
{

    ScicRegs.SCIFFTX.bit.TXFFINTCLR=1;   // Clear SCI Interrupt flag
    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP9;   ;//0x100;       // Issue PIE ACK
}



/*
 * USE TO SAMPLE DATA FROM ADC BETWEEN EACH INTERRUPT
 */
//#pragma CODE_SECTION(cpu_timer0_isr, ".TI.ramfunc");
interrupt void cpu_timer0_isr(void)
{
   CpuTimer0.InterruptCount++;

   PieCtrlRegs.PIEACK.all |= PIEACK_GROUP1;
}




float TAU_RMS=2e-4,kRMS=5;


// Define the structure
struct Data_struct {
    float arrayVa[500]; // Array to hold Va readings
    float arrayVb[500]; // Array to hold Vb readings
    float arrayVc[500]; // Array to hold Vc readings

    float arrayDCYa[500];
    float arrayDCYb[500];
    float arrayDCYc[500];

    //int arrayIa[500];
    //uint16_t arrayIb[500];
    //uint16_t arrayIc[500];

    float arrayVdc[500];
    //uint16_t arrayVnx[500];

    //uint16_t arrayId[500];
    //uint16_t arrayIq[500];

    //uint16_t arrayVdSS[500];
    //uint16_t arrayVqSS[500];
    //uint16_t arrayV0SS[500];


    //float arrayPLL[500];

    //float arrayVd[500];

    //float arrayMPC_PLL[500];

}data;

// Edwin's Function to send captured data to the terminal
void sendCapturedDataToTerminal(float Va, float Vb, float Vc, float DCYa, float DCYb, float DCYc, float Vdc) {
    char dataString[200];
    int j;

    // Format the string to include labels and values
    snprintf(dataString, sizeof(dataString),
             "%.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f\r\n",
             Va, Vb, Vc, DCYa, DCYb, DCYc, Vdc);


    // Iterate over each character in the dataString array until the null terminator '\0'
    //This initializes the loop with j set to 0.
    //Then, it checks if the character at index j in dataString is not equal to '\0',
    //the null terminator that marks the end of a string.
    //If this condition is true, the loop continues; if false, the loop terminates.

    for (j = 0; dataString[j] != '\0'; j++) {
        SCIC_write_char(dataString[j]); // Function to send data to terminal
    }
}

/********************************************************************************
							 External Interrupt IRQ1 (ADC Interrupt)
*********************************************************************************/


//#pragma CODE_SECTION(CPU1_Main_Int, ".TI.ramfunc");

float IaLP,IbLP,IcLP,InLP,Iaux1LP,Iaux2LP;
float VaLP,VbLP,VcLP;
int k;
volatile Uint16 CAPTUREFLAG = 0;

extern Uint16 OLD_CURRENTS[6];
extern float wErr;

interrupt void CPU1_Main_Int(void)          //XINT_1.4
{
    // Watchdog
    *(Uint16 *)FPGA_REG_00 |= 0x0002;       //Enable Watchdog
    *(Uint16 *)FPGA_REG_00 |= 0x0001;       //Reset Watchdog

    readTripsStatus();

    //read_currents(&AdcReadings.Ia,&AdcReadings.Ib,&AdcReadings.Ic,&AdcReadings.In,&AdcReadings.Iaux1,&AdcReadings.Iaux2,curr_FSW);

/*...................................ADC READINGS (VOLTAGE & CURRENT)....................................................................*/

    AdcReadings.Ia=ADCprocess3(ADC_IA);
    AdcReadings.Ib=ADCprocess3(ADC_IB);
    AdcReadings.Ic=ADCprocess3(ADC_IC);
    AdcReadings.In=ADCprocess3(ADC_IN);
    AdcReadings.Iaux1=ADCprocess3(ADC_IAUX1);
    AdcReadings.Iaux2=ADCprocess3(ADC_IAUX2);


    lowpass(AdcReadings.Ia,&IaLP,alphaLP);
    lowpass(AdcReadings.Ib,&IbLP,alphaLP);
    lowpass(AdcReadings.Ic,&IcLP,alphaLP);
    lowpass(AdcReadings.In,&InLP,alphaLP);
    lowpass(AdcReadings.Iaux1,&Iaux1LP,alphaLP);
    lowpass(AdcReadings.Iaux2,&Iaux2LP,alphaLP);

    AdcReadings.Vdc=ADCprocess3(ADC_VHTP_VHTN);

    AdcReadings.Vnx=ADCprocess3(ADC_VNX_VHTN);

    AdcReadings.Va=ADCprocess3(ADC_VA_VNX)+AdcReadings.Vnx;
    //AdcReadings.Va = AdcReadings.Vn;    // Va is wired to Vn on hardware
    AdcReadings.Vb=ADCprocess3(ADC_VB_VNX)+AdcReadings.Vnx;
    AdcReadings.Vc=ADCprocess3(ADC_VC_VNX)+AdcReadings.Vnx;
    AdcReadings.Vn=ADCprocess3(ADC_VN_VNX)+AdcReadings.Vnx;

    AdcReadings.Vaux1=ADCprocess3(ADC_VAUX1_VHTN);
    AdcReadings.Vaux2=ADCprocess3(ADC_VAUX2_VHTN);

    lowpass(ADCprocess3(ADC_TEMP1),&Tmodule1,tauTemp);
    lowpass(ADCprocess3(ADC_TEMP2),&Tmodule2,tauTemp);

    // Apply low-pass filter to AdcReadings
    lowpass(AdcReadings.Va, &VaLP, alphaLP);
    lowpass(AdcReadings.Vb, &VbLP, alphaLP);
    lowpass(AdcReadings.Vc, &VcLP, alphaLP);

/*...................................TRIPS STATUS....................................................................*/

    if(TRIPS.STATUS!=4)
    {
        CAPTURE.flag=0; //if tripped, stop capturing
        PWM_En=0;
    }


    if(!GpioDataRegs.GPCDAT.bit.GPIO67)  // Control board user button A
    {

    }

    if(!GpioDataRegs.GPCDAT.bit.GPIO68)  // Control board user button B
    {

    }


    if(*(Uint16 *)FPGA_REG_60 | *(Uint16 *)FPGA_REG_61 | *(Uint16 *)FPGA_REG_62 | *(Uint16 *)FPGA_REG_63)
        GpioDataRegs.GPASET.bit.GPIO1 = 1;      // Set LED to show Reset Button status
    else
        GpioDataRegs.GPACLEAR.bit.GPIO1 = 1;

 /*...................................PLL....................................................................*/

    PLL(Park.Vq/VaRMS, 1e-3/curr_FSW, &PLL_vars.sinTheta,&PLL_vars.cosTheta,&PLL_vars.theta); // This is correct

/*...................................VOLTAGE TRANSFORMATIONS....................................................................*/

    dq0(AdcReadings.Va, AdcReadings.Vb, AdcReadings.Vc, &Park.Vd, &Park.Vq, &Park.V0, PLL_vars.sinTheta, PLL_vars.cosTheta); //get Vd,Vq
    lowpass(Park.Vd,&VdLP,0.01);
    lowpass(Park.Vq,&VqLP,0.01);
    //lowpass(Park.V0,&V0LP,0.01);

 /*...................................CURRENT REFERENCES & TRANSFORMATIONS....................................................................*/

    dq0(AdcReadings.Ia, AdcReadings.Ib, AdcReadings.Ic, &Park.Id, &Park.Iq, &Park.I0, PLL_vars.sinTheta, PLL_vars.cosTheta);    //get Id, Iq, I0

    Id_REF=Para_Float[58-50];
    Iq_REF=Para_Float[59-50];

 /*...................................PWM....................................................................*/

    if(PWM_En)
     {
         *(Uint16 *)FPGA_REG_08 = 1<<5 | 1<<8 | 1<<9 | 1<<10;     // ENABLE PWM phase A,B,C

         /*
          * CURRENT CONTROLLERS Id, Iq (Output is VdSS & VqSS, )
          */
         VdSS= DCL_runPI_C1(&PI_Id, Id_REF, Park.Id);
         VqSS= DCL_runPI_C1(&PI_Iq, Iq_REF, Park.Iq);
         //V0SS= DCL_runPI_C1(&PI_I0, 0, Park.I0);      // Zero Sequence
         lowpass(AdcReadings.Vdc/2,&V0SS,0.001);


         //CAPTURE.flag=1; //capture data
     }

     else{
         *(Uint16 *)FPGA_REG_08 = 0;    //DISABLE PWM output

         //RESET CURRENT PIs
         PI_Id.i10=Park.Vd;
         PI_Iq.i10=Park.Vq;
         VdSS=Park.Vd;
         VqSS=Park.Vq;
         V0SS=Park.V0;

     }

     INVdq0(VdSS/AdcReadings.Vdc,VqSS/AdcReadings.Vdc,V0SS/AdcReadings.Vdc,&DCYa,&DCYb,&DCYc,PLL_vars.sinTheta,PLL_vars.cosTheta);
     Modulator(DCYa,DCYb,DCYc,0,0,0);  // Normalised PWM modulating signals

/*.......................................................................................................*/
// Trip Test from user button
     if(!GpioDataRegs.GPBDAT.bit.GPIO53)  // Control board user button C
     {
//         GpioDataRegs.GPCSET.bit.GPIO84 = 1;      // Set LED to show Manual Trip test active
         *(Uint16 *)FPGA_REG_11 |= 0x0001;          // Set Trip 1 in group B
     }
     else
     {
//         GpioDataRegs.GPCCLEAR.bit.GPIO84 = 1;
         *(Uint16 *)FPGA_REG_11 &= 0xFFFE;
     }

/*..............................MPC_PLL.....................................................................*/

     Valfa_pll = (AdcReadings.Vn*2-AdcReadings.Vb-AdcReadings.Vc)/3;    /*V-ABC Transformation to Alfa Beta*/

     Vbeta_pll = (AdcReadings.Vb-AdcReadings.Vc)*sqrt1on3;

     // Iterations
        theta_iteration[0] = 0.0f;           // Initial theta

        for (m = 1; m <= 8; m++) {

            // Use findMaxTheta for the first iteration, findMinTheta for subsequent iterations
            theta_iteration[m] = (m == 1) ? findMaxTheta(Valfa_pll, Vbeta_pll, m) : findMinTheta(Valfa_pll, Vbeta_pll, m);
        }

        // Final angle adjustment
        if (theta_iteration[8] < 0) {
            theta_iteration[8] += 2 * PI;

        }


/*...................................DATA CAPTURE....................................................................*/

   if (CAPTUREFLAG == 1){

               data.arrayVa[k] = (AdcReadings.Vn);
               data.arrayVb[k] = (AdcReadings.Vb);
               data.arrayVc[k] = (AdcReadings.Vc);

               data.arrayDCYa[k] = (DCYa);
               data.arrayDCYb[k] = (DCYb);
               data.arrayDCYc[k] = (DCYc);

               //data.arrayIa[k]  = (AdcReadings.Ia * 100);
               //data.arrayIb[k]  = (0x7FFF + AdcReadings.Ib * 100);
               //data.arrayIc[k]  = (0x7FFF + AdcReadings.Ic * 100);

               data.arrayVdc[k] = (AdcReadings.Vdc);
               //data.arrayVnx[k] = (0x7FFF + AdcReadings.Vnx * 10);

               //data.arrayId[k]  = (0x7FFF + Park.Id * 100);
               //data.arrayIq[k]  = (0x7FFF + Park.Iq * 100);

               //data.arrayVdSS[k]  = (0x7FFF + VdSS * 10);
               //data.arrayVqSS[k]  = (0x7FFF + VqSS * 10);
               //data.arrayV0SS[k]  = (0x7FFF + V0SS * 10);


            //data.arrayPLL[k] = PLL_vars.theta;
           //data.arrayVd[k] = Park.Vd;

             //data.arrayMPC_PLL[k] = theta_iteration[8];


             // Increment k
             k++;

             // Check if k exceeds 500
             if (k >= 500){

                 // Stop capturing data
                 CAPTUREFLAG = 0;

                 // Reset Counter ready for next capture
                 k = 0;

             }
     }


     else {

              CAPTUREFLAG = 0;
              k = 0;
          }

 /*.......................................................................................................*/
     /*
      * CALCULATE RMS FOR DISPLAY OUTPUT
      */

     lowpass(AdcReadings.Va*AdcReadings.Va/2,&Va2t,TAU_RMS);
/*   lowpass(Vb*Vb/2,&Vb2t,TAU_RMS);
     lowpass(Vc*Vc/2,&Vc2t,TAU_RMS);
     lowpass(Vaux1*Vaux1/2,&Vaux1_2t,TAU_RMS);
     lowpass(Vaux2*Vaux2/2,&Vaux2_2t,TAU_RMS);

     lowpass(Ia*Ia,&Ia2t,TAU_RMS);
     lowpass(Ib*Ib,&Ib2t,TAU_RMS);
     lowpass(Ic*Ic,&Ic2t,TAU_RMS);
     lowpass(In*In,&In2t,TAU_RMS);
     lowpass(Iaux1*Iaux1_2t,&Iaux1RMS,TAU_RMS);
     lowpass(Iaux2*Iaux2_2t,&Iaux2RMS,TAU_RMS);
*/
     VaRMS=sqrt(Va2t);
/*     VbRMS=sqrt(Vb2t);
     VcRMS=sqrt(Vc2t);
     Vaux1RMS=sqrt(Vaux1_2t);
     Vaux2RMS=sqrt(Vaux2_2t);

     IaRMS=sqrt(Ia2t);
     IbRMS=sqrt(Ib2t);
     IcRMS=sqrt(Ic2t);
     InRMS=sqrt(In2t);
     Iaux1RMS=sqrt(Iaux1_2t);
     Iaux2RMS=sqrt(Iaux2_2t);

     lowpass((Vd*Id+Vq*Iq),&R,alphaLP);
     lowpass((Vd*Iq-Vq*Id),&Q,alphaLP);
     lowpass(sqrt(R*R+Q*Q),&S,alphaLP);*/



    PieCtrlRegs.PIEACK.all |= PIEACK_GROUP1;

 /*......................ORIGINAL DATA CAPTURE CODE.........................................................................*/

         /*if(CAPTURE.flag)
         {
             CAPTURE.data[0] = (int)(0x7FFF + AdcReadings.Va * 10);
             CAPTURE.data[1] = (int)(0x7FFF + AdcReadings.Vb * 10);
             CAPTURE.data[2] = (int)(0x7FFF + AdcReadings.Vc * 10);
             CAPTURE.data[3] = (int)(0x7FFF + AdcReadings.Ia * 100);
             CAPTURE.data[4] = (int)(0x7FFF + AdcReadings.Ib * 100);
             CAPTURE.data[5] = (int)(0x7FFF + AdcReadings.Ic * 100);
             CAPTURE.data[6] = (int)(0x7FFF + AdcReadings.Vdc * 10);
             CAPTURE.data[7] = (int)(0x7FFF + AdcReadings.Vnx * 10);
             CAPTURE.data[8] = (int)(0x7FFF + Park.Id * 100);
             CAPTURE.data[9] = (int)(0x7FFF + Park.Iq * 100);
             CAPTURE.data[10] = (int)(0x7FFF + VdSS * 10);
             CAPTURE.data[11] = (int)(0x7FFF + VqSS * 10);
             CAPTURE.data[12] = (int)(0x7FFF + V0SS * 10);
             CAPTURE.data[13] = (int)(0x7FFF + DCYa * 100);
             CAPTURE.data[14] = (int)(0x7FFF + DCYb * 100);
             CAPTURE.data[15] = (int)(0x7FFF + DCYc * 100);



             //saveData(CAPTURE.data,sizeof(CAPTURE.data),&CAPTURE.counter);


             CAPTURE.counter++;
             if(CAPTURE.counter>200){
                 PWM_En=1;

             }
             else{
                //PWM_En=0;
             }
             if(CAPTURE.counter>4096){
                 CAPTURE.counter=0;
                 CAPTURE.flag=0;      //stop capturing data
                 //PWM_En=0;
             }


         }*/

}

//###################################################################################################



