//###########################################################################
// FILE:   CPU_Base.c
// CCS Project:
// TITLE:  National Grid Project - Deliverable 1 base code
// Current Version date: 20/08/2019
// Authors: Ed Christopher - Jordi Espina - Behzad Ahmadi - Davide Gottardo
//
//###########################################################################


// ##################################################################################################
//                                          Include Files                                           #
// ##################################################################################################

#include "CPU1_Base.h"
//#include "ymodem.h"

#include "Data_Capture2.h"

// ##################################################################################################
//                                          Globals                                                 #
// ##################################################################################################

extern Uint16 State_ADC;
extern Uint16 counter;
//extern volatile Uint16 PWM_En;
Uint16 LoopCount;
Uint16 ErrorCount;


// SCIB Variables
Uint16 Syncd = 0; //Global SCIB syncd state
Uint16 ack_en =0;
//Uint16 CMD_RECEIVED = 0;
Uint16 com_b_active = 0;
Uint16 com_allowed = 1;
Uint16 COM_B_CMD = 0;
char COM_B_DATA[20];
char *COM_B_DATAptr;

//SCIC Variables
Uint16 com_c_active = 0;
Uint16 COM_C_CMD = 0;
char COM_C_DATA[20];
char *COM_C_DATAptr;

// Variables for Capture
Uint16 test1 = 0;
float test2 = 0.232;
float Ic_1 = 0.564;
Uint16 Ia_en = 1;


volatile int Edwinflag = 0;
extern volatile Uint16 CAPTUREFLAG;
int step = 0;
int index = 0;



// Define the structure
extern struct Data_struct {
    float arrayVa[500]; // Array to hold Va readings
    float arrayVb[500]; // Array to hold Vb readings
    float arrayVc[500]; // Array to hold Vc readings

    float arrayDCYa[500];
    float arrayDCYb[500];
    float arrayDCYc[500];

    //int arrayIa[500];
    //uint16_t arrayIb[500];
    //uint16_t arrayIc[500];

    float arrayVdc[500];
    //uint16_t arrayVnx[500];

    //uint16_t arrayId[500];
    //uint16_t arrayIq[500];

    //uint16_t arrayVdSS[500];
    //uint16_t arrayVqSS[500];
    //uint16_t arrayV0SS[500];


    //float arrayPLL[500];

    //float arrayVd[500];

    //float arrayMPC_PLL[500];

}data;

// ##################################################################################################
//                                          Main program                                            #
// ##################################################################################################
#pragma CODE_SECTION(CommsLoop, ".TI.ramfunc");
void CommsLoop(void){
    Uint16 i=0;

    /* Serial Host Comms, triggered by SCI interrupt. Other com activity is disabled until current command is processed
     * There is a process for serial port terminal comms and LCD comms                                                  */

    /*if(com_b_active && com_allowed)
    {

        com_allowed=0;

        Host_Comms();

        COM_B_CMD = 0;

        COM_B_DATAptr = COM_B_DATA;

        for(i=0;i<20;i++)
        {
            *COM_B_DATAptr++ = 0;
        }
        com_allowed=1;
        com_b_active=0;
        ScibRegs.SCIFFRX.bit.RXFFIENA = 1;
    }*/

    if(com_c_active && com_allowed)
    {
        com_allowed=0;

        SCIC_write_char('B');

        LCD_Comms();

        COM_C_CMD = 0;

        COM_C_DATAptr = COM_C_DATA;

        for(i=0;i<20;i++)
        {
            *COM_C_DATAptr++ = 0;
        }
        com_allowed=1;
        com_c_active=0;
        ScicRegs.SCIFFRX.bit.RXFFIENA = 1;
    }
}


void main(void)
{
    InitSysCtrl();
    //
    // Call Flash Initialization to setup flash waitstates
    // This function must reside in RAM
    //
    Initialise_CPU1();


  //  SendChar=0;


    #ifdef _DEMOBRD
        //GpioDataRegs.GPADAT.bit.GPIO31 = 1;
        //GpioDataRegs.GPBDAT.bit.GPIO34 = 0;
    #else
  //      GpioDataRegs.GPACLEAR.bit.GPIO0 = 1;      //LED0
  //      GpioDataRegs.GPACLEAR.bit.GPIO1 = 1;      //LED1
  //      GpioDataRegs.GPCCLEAR.bit.GPIO84 = 1;     //LED2


    GpioDataRegs.GPCSET.bit.GPIO91 = 1;             //LED3


    GpioCtrlRegs.GPCDIR.bit.GPIO67 = 0;   //User button A on NG Control Brd
    GpioCtrlRegs.GPCDIR.bit.GPIO68 = 0;   //User button B on NG Control Brd
    GpioCtrlRegs.GPBDIR.bit.GPIO53 = 0;   //User button C on NG Control Brd
    GpioCtrlRegs.GPBDIR.bit.GPIO55 = 0;   //User button D on NG Control Brd
    #endif


        EALLOW;

        GpioCtrlRegs.GPADIR.bit.GPIO6  = 1; //heatsink right fan control port
        GpioCtrlRegs.GPADIR.bit.GPIO7  = 1; //precharge res. fan control port
        GpioCtrlRegs.GPADIR.bit.GPIO8  = 1; //heatsink left fan control port
        GpioCtrlRegs.GPADIR.bit.GPIO9  = 1; //gate driver fan control port
        GpioCtrlRegs.GPBDIR.bit.GPIO33 = 1; //precharge resistor bypass relay control port
        GpioCtrlRegs.GPBDIR.bit.GPIO36 = 1; //enable/disable diff transceivers control port // Green light on the desk

        EDIS;

        /********************************************************************************
            Disable CPU interrupts and clear all CPU interrupt flags:
        *********************************************************************************/
           EALLOW;
           IER = 0x0000;        // Interrupt Enable Routine
           IFR = 0x0000;        // Interrupt Flag Routine
           EDIS;

           Board_interrupts_Assign();       // Assigns the interrupts routines to CPU interrupts

           Board_interrupts_EN();           // Enable Interrupts used for the controller board

           EnableInterrupts();              // Enable PIE & CPU level Interrupts.
        /********************************************************************************
        *********************************************************************************/

           while(Initialise_FPGA()) continue;   //Initialise FPGA program

           //SCIB_open();  //Serial Terminal Port

           SCIC_open();  //LCD Port now UART

           converterStart();


   for(;;){


       CommsLoop();

        step = 0;

        while (Edwinflag == 0){


        }

        step = 1;

        if (Edwinflag == 1){

            CAPTUREFLAG = 1;

        }

        step = 2;

        while (CAPTUREFLAG == 1){

        }

        step = 3;

        //loop index directly corresponds to the current iteration of the loop.
        //This makes index an effective and straightforward way to access each element of data.array sequentially from the first element (data.array[0]) to the last element within the bounds of the loop (data.array[500] in this case).
        //This approach is used when you want to iterate over a sequence of elements in an array, sending each element to the terminal one by one.
        //It ensures that each iteration of the loop sends the next element in the array.

        for (index = 0; index<500; index++){

            //sendCapturedDataToTerminal(data.arrayVa[index], data.arrayVb[index], data.arrayVc[index], data.arrayIa[index], data.arrayIb[index], data.arrayIc[index], data.arrayVdc[index], data.arrayVnx[index], data.arrayId[index], data.arrayIq[index], data.arrayVdSS[index], data.arrayVqSS[index], data.arrayV0SS[index], data.arrayDCYa[index], data.arrayDCYb[index], data.arrayDCYc[index]);

            //sendCapturedDataToTerminal(data.arrayPLL[index]);
            //sendCapturedDataToTerminal(data.arrayMPC_PLL[index]);

            sendCapturedDataToTerminal(data.arrayVa[index], data.arrayVb[index], data.arrayVc[index], data.arrayDCYa[index], data.arrayDCYb[index], data.arrayDCYc[index], data.arrayVdc[index]);

        }

        Edwinflag = 0;

        step = 4;

     }
}




