/*
 * Debug.C
 *
 *  Created on: 9 Sep 2019
 *      Author: Davide
 */


#include "Debug.h"

#include "NG_Converter_support.h"

extern Uint16 ADC_UP_LIMITS[26];
extern Uint16 ADC_LOW_LIMITS[26];


extern float Id, Iq, I0;

float Ic_DEBUG,Ic_DEBUG,Ic_DEBUG;
float IdLP,IqLP,I0LP;

float ADC_ReadingsDEBUG[26];
float LPtauDEBUG=1e-4;


void setTripsLimitsDEBUG(void){
    /*
     * Signal must be higher than the upper limit or lower than the lower limit to trigger trip.
     *
     * Setting positive trip to 0xFFFF or negative trip to 0x0000 makes the trip condition impossible.
     *
     */
    int i;

    for(i=0;i<26;i++){
            ADC_LOW_LIMIT_FPGA(i) =ADC_LOW_LIMITS[i];
            ADC_UP_LIMIT_FPGA(i)  =ADC_UP_LIMITS[i];
    }
}


void watchVariablesDEBUG(void){
    //watch park currents

    lowpass(Id, &IdLP, LPtauDEBUG);
    lowpass(Iq, &IqLP, LPtauDEBUG);
    lowpass(I0, &I0LP, LPtauDEBUG);


}



