//###########################################################################
//
// FILE:   F2837xD_Emif.c
//
// TITLE:  F2837xD EMIF Initialization & Support Functions.
//
//###########################################################################
// $TI Release: F2837xD Support Library v210 $
// $Release Date: Tue Nov  1 14:46:15 CDT 2016 $
// $Copyright: Copyright (C) 2013-2016 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

//
// Included Files
//
#include "F2837xD_device.h"
#include "F2837xD_Examples.h"

// ##################################################################################################
//                                          Defines                                                #
// ##################################################################################################

//EMIF Asynchronous Memory

//
extern Uint16  ErrCount;

//
// Emif1Initialize - This function initializes the EMIF1 to a known state.
//
void Emif1Initialize(void)
{
    EALLOW;
    //
    // Perform a Module soft reset on EMIF
    //
#ifdef CPU1
    DevCfgRegs.SOFTPRES1.all = 0x1;
   __asm (" nop");
    DevCfgRegs.SOFTPRES1.all = 0x0;
#endif
    EDIS;
}


// ASync_wait_config - Async wait configuration function
//
void ASync_wait_config(Uint16 inst, Uint16 wait_count, Uint16 wait_polarity)
{
    if (inst == 0)
    {
        //
        // 7:0 Maximum Extended Wait cycles.
        //
        Emif1Regs.ASYNC_WCCR.bit.MAX_EXT_WAIT = wait_count;

        //
        // 28 Wait Polarity for pad_wait_i[0].
        //
        Emif1Regs.ASYNC_WCCR.bit.WP0 = wait_polarity;
    }
}

//
// ASync_cs3_config - Async CS3 Configuration
//
void ASync_cs3_config(Uint16 inst, Uint16 async_mem_data_width,
                      Uint16 turn_around_time, Uint16 r_hold_time,
                      Uint16 r_strobe_time, Uint16 r_setup, Uint16 w_hold,
                      Uint16 w_strobe, Uint16 w_setup, Uint16 extend_wait,
                      Uint16 strobe_sel)
{
    //
    // 1:0 Asynchronous Memory Size.
    // 3:2 Turn Around cycles.
    // 6:4 Read Strobe Hold cycles.
    // 12:7 Read Strobe Duration cycles.
    // 16:13 Read Strobe Setup cycles.
    // 19:17 Write Strobe Hold cycles.
    // 25:20 Write Strobe Duration cycles.
    // 29:26 Write Strobe Setup cycles.
    // 30 Extend Wait mode.
    // 31 Select Strobe mode.
    //
    Emif1Regs.ASYNC_CS3_CR.bit.ASIZE = async_mem_data_width;
    Emif1Regs.ASYNC_CS3_CR.bit.TA= turn_around_time;
    Emif1Regs.ASYNC_CS3_CR.bit.R_HOLD= r_hold_time;
    Emif1Regs.ASYNC_CS3_CR.bit.R_STROBE = r_strobe_time;
    Emif1Regs.ASYNC_CS3_CR.bit.R_SETUP = r_setup;
    Emif1Regs.ASYNC_CS3_CR.bit.W_HOLD = w_hold;
    Emif1Regs.ASYNC_CS3_CR.bit.W_STROBE = w_strobe;
    Emif1Regs.ASYNC_CS3_CR.bit.W_SETUP  = w_setup;
    Emif1Regs.ASYNC_CS3_CR.bit.EW = extend_wait;
    Emif1Regs.ASYNC_CS3_CR.bit.SS = strobe_sel;
}


#ifdef CPU1
//
// setup_emif1_pinmux_async_16bit - function for EMIF1 GPIO pin setup
//
void setup_emif1_pinmux_async_16bit(Uint16 cpu_sel)
{
    Uint16 i;

    GPIO_SetupPinMux(31,0,2);  //EMIF WR
    GPIO_SetupPinMux(34,0,2);  //EMIF cs2
    GPIO_SetupPinMux(35,0,2);  //EMIF cs3
    GPIO_SetupPinMux(37,0,2);  //EMIF oe

    GPIO_SetupPinMux(38,0,2);  //EMIF A0
    GPIO_SetupPinMux(39,0,2);  //EMIF A1
    GPIO_SetupPinMux(40,0,2);  //EMIF A2
    GPIO_SetupPinMux(41,0,2);  //EMIF A3
    GPIO_SetupPinMux(44,0,2);  //EMIF A4
    GPIO_SetupPinMux(45,0,2);  //EMIF A5
    GPIO_SetupPinMux(46,0,2);  //EMIF A6
    GPIO_SetupPinMux(47,0,2);  //EMIF A7
    GPIO_SetupPinMux(48,0,2);  //EMIF A8
    GPIO_SetupPinMux(49,0,2);  //EMIF A9
    GPIO_SetupPinMux(50,0,2);  //EMIF A10
    GPIO_SetupPinMux(51,0,2);  //EMIF A11
    GPIO_SetupPinMux(52,0,2);  //EMIF A12
    GPIO_SetupPinMux(86,0,2);  //EMIF A13
    GPIO_SetupPinMux(87,0,2);  //EMIF A14
    GPIO_SetupPinMux(88,0,2);  //EMIF A15
    GPIO_SetupPinMux(89,0,2);  //EMIF A16
    GPIO_SetupPinMux(90,0,2);  //EMIF A17
    GPIO_SetupPinMux(92,0,3);  //EMIF BA1

    for (i=69; i<=85; i++)
    {
        if (i != 84)
        {
            GPIO_SetupPinMux(i,cpu_sel,2); //EMIF Data pins
            GPIO_SetupPinOptions(i,0,0x31); // GPIO_ASYNC||GPIO_PULLUP
        }
    }
}

#endif // CPU1
void Config_EMIF(void)
    {

    Emif1Initialize();

    //
    //Configure to run EMIF1 on half Rate (EMIF1CLK = CPU1SYSCLK/2)
    //
      EALLOW;
      ClkCfgRegs.PERCLKDIVSEL.bit.EMIF1CLKDIV = 0x1;
      EDIS;

      EALLOW;
    //
    // Grab EMIF1 For CPU1
    //
      Emif1ConfigRegs.EMIF1MSEL.all = 0x93A5CE71;
      if(Emif1ConfigRegs.EMIF1MSEL.all != 0x1)
      {
          ErrCount++;
      }

    //
    //Disable Access Protection (CPU_FETCH/CPU_WR/DMA_WR)
    //
      Emif1ConfigRegs.EMIF1ACCPROT0.all = 0x0;
      if(Emif1ConfigRegs.EMIF1ACCPROT0.all != 0x0)
      {
          ErrCount++;
      }

    //
    // Commit the configuration related to protection. Till this bit remains set
    // content of EMIF1ACCPROT0 register can't be changed.
    //
      Emif1ConfigRegs.EMIF1COMMIT.all = 0x1;
      if(Emif1ConfigRegs.EMIF1COMMIT.all != 0x1)
      {
         ErrCount++;
      }

    //
    // Lock the configuration so that EMIF1COMMIT register can't be
    // changed any more.
    //
      Emif1ConfigRegs.EMIF1LOCK.all = 0x1;
      if(Emif1ConfigRegs.EMIF1LOCK.all != 1)
      {
          ErrCount++;
      }

      EDIS;

    //
    //Configure GPIO pins for EMIF1
    //
      setup_emif1_pinmux_async_16bit(0);

    //
    //Configure the access timing for CS3 space
    //
      Emif1Regs.ASYNC_CS3_CR.all =  (EMIF_ASYNC_ASIZE_16    | // 16Bit Memory
                                                              // Interface
                                     EMIF_ASYNC_TA_3        | // Turn Around time
                                                              // of 2 Emif Clock
                                     EMIF_ASYNC_RHOLD_2     | // Read Hold time
                                                              // of 1 Emif Clock
                                     EMIF_ASYNC_RSTROBE_8   | // Read Strobe time
                                                              // of 4 Emif Clock
                                     EMIF_ASYNC_RSETUP_2    | // Read Setup time
                                                              // of 1 Emif Clock
                                     EMIF_ASYNC_WHOLD_2     | // Write Hold time
                                                              // of 1 Emif Clock
                                     EMIF_ASYNC_WSTROBE_2   | // Write Strobe time
                                                              // of 1 Emif Clock
                                     EMIF_ASYNC_WSETUP_2    | // Write Setup time
                                                              // of 1 Emif Clock
                                     EMIF_ASYNC_EW_DISABLE  | // Extended Wait
                                                              // Disable.
                                     EMIF_ASYNC_SS_DISABLE    // Strobe Select Mode
                                                              // Disable.
                                    );

      Emif1Regs.ASYNC_CS2_CR.all =  (EMIF_ASYNC_ASIZE_16    | // 16Bit Memory
                                                                    // Interface
                                           EMIF_ASYNC_TA_3        | // Turn Around time
                                                                    // of 2 Emif Clock
                                           EMIF_ASYNC_RHOLD_2     | // Read Hold time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_RSTROBE_8   | // Read Strobe time
                                                                    // of 4 Emif Clock
                                           EMIF_ASYNC_RSETUP_2    | // Read Setup time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WHOLD_2     | // Write Hold time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WSTROBE_2   | // Write Strobe time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WSETUP_2    | // Write Setup time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_EW_DISABLE  | // Extended Wait
                                                                    // Disable.
                                           EMIF_ASYNC_SS_DISABLE    // Strobe Select Mode
                                                                    // Disable.
                                          );

      /*Emif1Regs.ASYNC_CS4_CR.all =  (EMIF_ASYNC_ASIZE_16    | // 16Bit Memory
                                                                    // Interface
                                           EMIF_ASYNC_TA_3        | // Turn Around time
                                                                    // of 2 Emif Clock
                                           EMIF_ASYNC_RHOLD_2     | // Read Hold time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_RSTROBE_8   | // Read Strobe time
                                                                    // of 4 Emif Clock
                                           EMIF_ASYNC_RSETUP_2    | // Read Setup time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WHOLD_2     | // Write Hold time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WSTROBE_2   | // Write Strobe time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_WSETUP_2    | // Write Setup time
                                                                    // of 1 Emif Clock
                                           EMIF_ASYNC_EW_DISABLE  | // Extended Wait
                                                                    // Disable.
                                           EMIF_ASYNC_SS_DISABLE    // Strobe Select Mode
                                                                    // Disable.
                                          );*/


    }





//
// End of file
//
