/*
 * Host_Comm_v2.c
 *
 *  Created on: 3 Jan 2019
 *      Author: Ed
 *
 *  Serial Terminal Interface for the NG control board
 *
 *  Ethernet adaptor
 *
 */




#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837xD_Device.h"     // Device header File
#include "Board_Delfino28379D.h" // Custom Project Header File
#include "Host_Comm_v2.h"
#include "SCIB_code_V3.h"
#include "Parameters.h"
#include <stdlib.h>
#include <math.h>
#include "Data_Capture.h"
#include "ymodem.h"
#include "NG_Converter_support.h"

#define TIME_OUT 42940000  // 42940000 ~15s


void Host_Comms(void)
{
 //   Uint16 cmd_c[2];
 //   Uint16 ack_en = 0;

 //   Ini_cap_var_loc(); // Initialise array with capture variable memory addresses

    //Send_file_scib();
    cmd_ack(0x0031);
    if(Syncd==2)
        {

        if(SCIB_read_LF(&COM_B_CMD, COM_B_DATA,TIME_OUT))
        {

            switch(COM_B_CMD)
            {
            case 0x6165: //ae
                cmd_ack(0x6165);
                    ack_en=1;
                break;

            case 0x6c70: //lp
                if(ack_en) cmd_ack(0x6c70);
                list_parameters();
                break;

            case 0x6570: //ep
                if(ack_en) cmd_ack(0x6570);
                edit_para(COM_B_DATA);
                break;

            case 0x7270: //rp
                 if(ack_en) cmd_ack(0x7270);
                 read_para(COM_B_DATA);
                 break;

            case 0x7366: //sf
                 if(ack_en) cmd_ack(0x7366);
                 Send_file_scib();
                 break;

            case 0x6365: // Enable Converter
                  Enable_Converter();
                  break;

            case 0x6364: // Disable Converter
                  Disable_Converter();
                  break;

            //case 0x6373: //cs
             //    if(ack_en) cmd_ack(0x6373);
              //   capture_start();
              //   break;

       //     case 0x6365: //ce
       //          if(ack_en) cmd_ack("ce");
       //          capture_enable();
               //  setup memory location, No of capture variables
        //         // reset sampling counters
        //         break;

           // case 0x6376: //cv
            //     if(ack_en) cmd_ack(0x6376);
             //    capture_variables();
              //   break;

      //      case 0x6c76: //lv
     //            if(ack_en) cmd_ack("lv");
      //           list_variables();
       //          break;

          //  case 0x636c: //cl
           //      if(ack_en) cmd_ack(0x636c);
            //     capture_length();
              //   break;

            case 0:
                //if(ack_en) cmd_ack(0x7366);
                //Send_Byte(0x36);
                //Send_file_scib();
                break;

            default:
                if(ack_en) cmd_ack(0x6572);
                break;
            }
        }
     }
    else
    {
        Syncd = Host_Sync();

        ack_en = 0;
    }



}

void capture_variables(void)
{
    char data[2]={NULL};

    Uint16 data_val = 100;
    Uint16 end_setup = 0;
    Uint16 var_count=0;
    char* nxt;

    while(!end_setup)
    {
  //      SCIB_read_LF(0,data,1);

        if((data[0] == 0x63) || (data[0] == 0x43))
        {
            var_count = 0;
        }
        else if((data[0] == 0x45) || (data[0] == 0x65))
        {
            end_setup=1;
        }
        else
        {
           data_val = (Uint16)strtoul(data, &nxt, 10);
           if(data_val<NO_OF_VARS)
               Cap_Vars[var_count++] = Var_List_Loc[data_val];
        }
    }

    if(var_count)
    {
        NoSpINT=var_count;
    }
    SCIB_write_int16(NoSpINT);




  //  SCIB_read_LF(0,data,1);


  //  read_para_num(data);
 //   data_val = (Uint16)strtoul(data, &nxt, 10);

 //   if(data_val)
 //       Sampling_On=1;
 //   else
  //      Sampling_On=0;

}

void capture_start(void)
{
    char data[2]={NULL};
    Uint16 data_val = 100;
    char* nxt;

 //   SCIB_read_LF(0,data,1);

  //  read_para_num(data);
    data_val = (Uint16)strtoul(data, &nxt, 10);

    if(data_val)
        if((Tot_No_Of_INTS==0)||(NoSpINT==0))
                SCIB_write(0,"ERR - 02 \r\n");
        else
            {
                Curr_Samp_Inst = 0;
                cap_samp = 0;
                pData = (float *)ASRAM_CS3_START_ADDR;
                Sampling_On=1;
            }

    else
        Sampling_On=0;
}

void capture_length(void)
{
    char data[10]={NULL};
    Uint16 data_val = 1000;
    char* nxt;

//    SCIB_read_LF(0,data,3);

    data_val = (Uint16)strtoul(data, &nxt, 10);
   // data_val = strtof(data, &nxt);

    if(data_val != 1000)
      //  cap_length_time = data_val;
        Tot_No_Of_INTS = data_val;
    else
       // cap_length_time=0;
        Tot_No_Of_INTS = 0;

}



void cmd_ack(Uint16 buf)
{
    SCIB_write_int16(buf);
    SCIB_write_int16(0x0D0A);
}

void list_parameters(void)
{
    Uint16 para_num=0;
    char tmpch[15] = {NULL};

   for(para_num=0;para_num<100;para_num++)
   {
       if(para_num<50)
          {
               int i=0;
               tmpch[i++]='P';
               i += intToStr(para_num,tmpch+i,2);
               tmpch[i++]='=';
               if(Para_Int[para_num]<0) tmpch[i++] = '-';
               i += intToStr(Para_Int[para_num],tmpch+i,6);
               tmpch[i++]='\r';
               tmpch[i++]='\n';
               tmpch[i]='\0';
               SCIB_write(0,tmpch);
          }
          else if(para_num<100)
          {
             // para_num -= 50;
              int i=0;
             // int fpart=0;
              tmpch[i++]='P';
              i += intToStr(para_num,tmpch+i,2);
              tmpch[i++]='=';
            //  para_num -= 50;
              if(Para_Float[para_num-50]<0) tmpch[i++] = '-';
              i += intToStr((int)Para_Float[para_num-50],tmpch+i,2);
              tmpch[i++]='.';

              float fpart = Para_Float[para_num-50] - ((float)(int)Para_Float[para_num-50]);
              int afterpoint = 15-i-1;
              if(afterpoint>4)afterpoint=4;
              fpart = fpart * pow(10, afterpoint);
              if(fpart<0) fpart *= -1;
              i += intToStr((int)fpart, tmpch+i, afterpoint);
              //i += intToStr((Para_Float[para_num]-(int)Para_Float[para_num]*pow(10, 4)),tmpch+i,4);
              tmpch[i++]='\r';
              tmpch[i++]='\n';
              tmpch[i]='\0';
              SCIB_write(0,tmpch);
          }
   }

}

void edit_para(char* data)
{
   // char data[10]={NULL};

  //  char tmpch[15] = {NULL};

    Uint16 para_num = 100;
    int para_value_i = 0;
    float para_value_f = 0;
    //char * dataPtr = data;
    char* nxt;

   // read_data_i(data);

  //  para_num  = (((Uint16)data[0]-48)*10) + (Uint16)data[1]-48;

    para_num = (Uint16)strtoul(data, &nxt, 10);

    if(para_num<50)
    {
     //   data[8] = '0';
     //   data[9] = '0';
      //  para_value_i = atoi(data+2)/100;
        para_value_i = (int)strtol(nxt, NULL, 10);

        Para_Int[para_num]=para_value_i;

        //could respond here
   //     if(ack_en)
     //   {
      //      int i=0;
      //      tmpch[i++]='P';
      //      i += intToStr(para_num,tmpch+i,2);
      //      tmpch[i++]='-';
       //     i += intToStr(Para_Int[para_num],tmpch+i,6);
       //     tmpch[i]='\0';
       //     SCIB_write(0,tmpch);
       // }

    }
    else if(para_num<100)
    {
     //   para_value_f = strtof((data+2), dataPtr);
        para_value_f = strtof(nxt, NULL);
        para_num -= 50;

        Para_Float[para_num]=para_value_f;

        //could respond here
    }

    else
    {
        return;
    }

}

void read_para(char* data)
{
     // char data[2]={NULL};
      char tmpch[15] = {NULL};

      Uint16 para_num = 100;
      //char * dataPtr = data;
      char* nxt;

      //read_para_num(data);
      para_num = (Uint16)strtoul(data, &nxt, 10);

          if(para_num<50)
          {
               int i=0;
               tmpch[i++]='P';
               i += intToStr(para_num,tmpch+i,2);
               tmpch[i++]='=';
               if(Para_Int[para_num]<0) tmpch[i++] = '-';
               i += intToStr(Para_Int[para_num],tmpch+i,6);
               tmpch[i++]='\r';
               tmpch[i++]='\n';
               tmpch[i]='\0';
               SCIB_write(0,tmpch);
          }
          else if(para_num<100)
          {

              int i=0;
             // int fpart=0;
              tmpch[i++]='P';
              i += intToStr(para_num,tmpch+i,2);
              tmpch[i++]='=';
              para_num -= 50;
              if(Para_Float[para_num]<0) tmpch[i++] = '-';
              i += intToStr((int)Para_Float[para_num],tmpch+i,2);
              tmpch[i++]='.';

              float fpart = Para_Float[para_num] - ((float)(int)Para_Float[para_num]);
              int afterpoint = 15-i-1;
              if(afterpoint>4)afterpoint=4;
              fpart = fpart * pow(10, afterpoint);
              if(fpart<0) fpart *= -1;
              i += intToStr((int)fpart, tmpch+i, afterpoint);
              //i += intToStr((Para_Float[para_num]-(int)Para_Float[para_num]*pow(10, 4)),tmpch+i,4);
              tmpch[i++]='\r';
              tmpch[i++]='\n';
              tmpch[i]='\0';
              SCIB_write(0,tmpch);
          }

}

int read_data_i(char *data)
{
    int state = 0;

 //   state = SCIB_read_LF(0,data,10);

   return(state);
}

int read_para_num(char *data)
{
    int state = 0;

 //   state = SCIB_read_LF(0,data,2);

   return(state);
}


int read_data_f(char *data)
{
    int state = 0;

    return(state);

}






/*

char HOST_TITLE[] =  {"\nNational Grid Converter\n\0"};
char MENU0_TITLE[] = {"Main Menu\n\0"};
char MENU0_ITEM1[] = {"1) List Parameters\n\0"};
char MENU0_ITEM2[] = {"2) Modify Parameters\n\0"};
char MENU0_ITEM3[] = {"3) Data Capture\n\0"};
//char MENU0_ITEM4[] = {"Item 4\n"};

char MENU1_TITLE[] = {"\n\nList Parameters\n\n\0"};
char MENU1_USER_INPUT[] = {"\n1=refresh, m= Main Menu...\0"};

char MENU_USER_INPUT[] = {"\nInput Menu Selection, m=Main Menu... \0"};

int Host_Comms(void)
    {
    Uint16 state = 0;
    char temp1[20]=NULL, temp2[20]=NULL;
    Uint16 i=0, j=0, k=0;
    int ACT_MENU = 48;
   // int SUB_MENU = 0;
    char option = 48;
    while(Syncd==2)
        {

        switch(ACT_MENU)
        {
        case 48:
            SCIB_write(0,HOST_TITLE);
            SCIB_write(0,MENU0_TITLE);
            SCIB_write(0,MENU0_ITEM1);
            SCIB_write(0,MENU0_ITEM2);
            SCIB_write(0,MENU0_ITEM3);
     //       SCIB_write(0,MENU0_ITEM4,sizeof(MENU0_ITEM4));

            SCIB_write(0,MENU_USER_INPUT);
            state = Host_Read_Choice(1,&option,'1','3');
            if((int)option==109)
                ACT_MENU = 48;
            else ACT_MENU = (int)option;
            break;

        case 49:
         //   SCIB_write(0,HOST_TITLE,sizeof(HOST_TITLE));
            while((int)option!=109)
            {
                SCIB_write(0,MENU1_TITLE);
                //k=0;
                for(i=0;i<50;i++)
                {
                        if(i<10)
                        {
                            temp1[0] = '\0';
                            concatenate_string(temp1,"P0\0");
                            ltoa(i,temp2);
                            concatenate(temp1, temp2);
                            concatenate(temp1, ",");
                            ltoa(Para_Int[i],temp2);
                            concatenate(temp1, temp2);
                            concatenate(temp1, ",\n\0");
                            SCIB_write(0,temp1);
                            //SCIB_write(0,(char)k,(char)k);
                           // ltoa(Para_Int[k], temp);
                           // SCIB_write(0,temp,sizeof(temp));
                            k++;
                        }
                        else
                        {
                            temp1[0] = '\0';
                            concatenate_string(temp1,"P0\0");
                            ltoa(i,temp2);
                            concatenate(temp1, temp2);
                            concatenate(temp1, ",");
                            ltoa(Para_Int[i],temp2);
                            concatenate(temp1, temp2);
                            concatenate(temp1, ",\n\0");
                            SCIB_write(0,temp1);
                            k++;
                        }

                       // SCIB_write_char(0x0A);

                    //SCIB_write_char(0x0A);
                }
                SCIB_write(0,MENU1_USER_INPUT);
                state = Host_Read_Choice(1,&option,32,32);

                if((int)option==109)
                    ACT_MENU = 48;

            }
            break;

        default:
            state = Host_Read_Choice(1,&option,'1','3');
            if((int)option==109)
                ACT_MENU = 48;
            else ACT_MENU = (int)option;
            break;
        }
    //    state = Host_Read_Choice(1,&option);
   //     ACT_MENU = (int)option;

     //   SCIB_write(0,HOST_TITLE,length(HOST_TITLE));
     //   SCIB_write(0,MENU_TITLE,length(MENU_TITLE));

        //state = Host_Read_Choice(1,option);
        if(state == 3)
             return(3);
        }
    return(0);

    }

Uint16 Host_Read_Choice(int num, char * choice, char min, char max)
    {
 //   Uint16 choice[2] = 0;
    Uint16 state = 0;
    Uint16 selection=0,confirm=0;
  //  Uint16 leave=0;
    Uint16 conda=0,condb=0;
    char *ch;

    while(conda==0)
        {
            condb=0;
            state = (SCIB_read(0, ch, num));
            selection = *ch;
            if(state == 3)
                 return(3);
            if((selection==109)||((selection>=(int)min)&&(selection<=(int)max)))
            {
                SCIB_write_char(*ch);
            while(condb==0)
                {
                    state = (SCIB_read(0, ch, num));
                    if(state == 3)
                        return(3);
                    confirm = *ch;
                    if(confirm == 0x08)
                        {
                            SCIB_write_char(0x08);
                            condb=2;
                            conda=0;
                        }
                    else if (confirm == 0x0A)
                        {
                            *choice = selection;
                            condb=1;
                            conda=1;
                        }
                    else
                        {
                            condb=0;
                        }

                }
            }

       }

       return(1);
        
    }

*/
/*
Uint16 Host_Read_Int(int num, char *choice)
    {
  //  Uint16 choice = 0;
    Uint16 state = 0;
    Uint16 selection=0;
    Uint16 cursor = 0;
    while(state==0)
        {
        if (cursor^=1UL)
            SCIB_write_char(0x5f);
        else
            SCIB_write_char(0x5f);

        state = (SCIB_read(0, choice, 1));
        selection = *choice;
        if(selection==109)
            state=1;
        else if((selection<(int)min)||(selection>(int)max))
            state=0;

        if(state == 3)
             return(3);

        }


       return(1);

    }

*/
void Sync_Ack()
{
    SCIB_write_char(0x06);
}


int Host_Sync()
    {
  //  Uint16 sync_comp = 0;

    SCIB_read_LF(&COM_B_CMD, COM_B_DATA,TIME_OUT);

    if(COM_B_CMD == SYNC_CODE)
               {
                   Sync_Ack();
                 //  ScibRegs.SCIFFRX.bit.RXFFIENA = 1;
                   return(2);
               }
           else
               return(0);
    }


  //  SCIB_write_char(0x5f)

// reverses a string 'str' of length 'len'
void reverse(char *str, int len)
{
    int i=0, j=len-1, temp;
    while (i<j)
    {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
        i++; j--;
    }
}

/**
  * @brief  Convert an Integer to a string
  * @param  str: The string
  * @param  intnum: The intger to be converted
  * @retval None
  */
void Int2Str(Uint16* str, int32 intnum)
{
  Uint32 i, Div = 1000000000, j = 0, Status = 0;

  for (i = 0; i < 10; i++)
  {
    str[j++] = (intnum / Div) + 48;

    intnum = intnum % Div;
    Div /= 10;
    if ((str[j-1] == '0') & (Status == 0))
    {
      j = 0;
    }
    else
    {
      Status++;
    }
  }
}


 // Converts a given integer x to string str[].  d is the number
 // of digits required in output. If d is more than the number
 // of digits in x, then 0s are added at the beginning.
int intToStr(int x, char str[], int d)
{
    int i = 0;
    int x_st=x;

    if(x_st<0)
        x=x*-1;

    while (x)
        {
            str[i++] = (x%10) + '0';
            x = x/10;
        }

    // If number of digits required is more, then
    // add 0s at the beginning
 //   while (i < d)
    //    str[i++] = '0';
    if(x_st==0) str[i++]='0';

    reverse(str, i);

    str[i] = '\0';
    return i;
}

/*
 *
    if(x<0)
    {
        x=x*-1;
        str[i++]='-';
    while (x)
        {
            str[i++] = (x%10) + '0';
                x = x/10;
        }
    }
    else
    {
    while (x)
        {
            str[i++] = (x%10) + '0';
            x = x/10;
        }
    }


    // If number of digits required is more, then
    // add 0s at the beginning
    while (i < d)
        str[i++] = '0';

    reverse(str, i);
    str[i] = '\0';
    return i;
 */

// Converts a floating point number to string.
void ftoa(float n, char *res, int afterpoint)
{
    // Extract integer part
    int ipart = (int)n;

    // Extract floating part
    float fpart = n - (float)ipart;

    // convert integer part to string
    int i = intToStr(ipart, res, 0);

    // check for display option after point
    if (afterpoint != 0)
    {
        res[i] = '.';  // add dot

        // Get the value of fraction part upto given no.
        // of points after dot. The third parameter is needed
        // to handle cases like 233.007
        fpart = fpart * pow(10, afterpoint);

        intToStr((int)fpart, res + i + 1, afterpoint);
    }
}






void Send_file_scib(void)
{

    Uint32 status = 0;
    Uint32 data_stored_size = 50;
    int i =0;
    char File_Name[50] = "Data.txt";

    Uint16 DATA_TEST[50];

    for(i=0;i<50;i++){

        DATA_TEST[i] = 0x30+i;
    }

    cmd_ack(0x4954); //IF Initiate File

    if (GetKey() == CRC16)
    {
          // Transmit the flash image through ymodem protocol //
     //     TEST_FUNC(DATA_TEST, File_Name, data_stored_size);

          status = Ymodem_Transmit(DATA_TEST, File_Name, data_stored_size);
      //    status = Ymodem_Transmit((uint8_t*)ApplicationAddress, (const uint8_t*)"UploadedFlashImage.bin", FLASH_IMAGE_SIZE);


          if (status != 0)
          {
           // SerialPutString("\n\rError Occured while Transmitting File\n\r");
              ScibRegs.SCIFFTX.bit.TXFIFORESET = 0;

              cmd_ack(0x4552); //ER

              ScibRegs.SCIFFTX.bit.TXFIFORESET = 1;

          }
          else
          {
            //SerialPutString("\n\rFile Transmitted Successfully \n\r");
              cmd_ack(0x5453); //TS
          }
    }
    else
    {
          //SerialPutString("\r\n\nAborted by user.\n\r");
          cmd_ack(0x5541); //UA
    }

}


