/*
 * LCD_Comm_v1.c
 *
 *  Created on: 5 April 2019
 *      Author: Ed
 *
 * Edited on :20 Sept 2019
 * Davide
 *
 *  SerialInterface for the NG control board to LCD display
 *
 *  Through SCIC serial port
 *
 */
 
#include "LCD_Comm_v1.h"


extern float R,Q,S,Vdc;
extern float VaRMS,VbRMS,VcRMS;
extern float IaRMS,IbRMS,IcRMS,InRMS;
extern float Vaux1RMS,Iaux1RMS,Vaux2RMS,Iaux2RMS;

/*
#pragma CODE_SECTION(LCD_Comms, ".TI.ramfunc");
#pragma CODE_SECTION(LCD_Read_Para, ".TI.ramfunc");
#pragma CODE_SECTION(LCD_Write_Para, ".TI.ramfunc");
*/

void LCD_Comms(void)
{
   Uint16 Message_Temp[4] = {0,0,0,0};

        if(SCIC_read_LF(&COM_C_CMD, COM_C_DATA, TIME_OUT_LCD))
        {
            switch(COM_C_CMD)
            {
            case 0x2425: //Sync
                SCIC_write_char(':');
                break;

            case 0x6864: //Dial Data P, Q, Vdc, S
                Message_Temp[0] = (Uint16) (R/1000+25);         //active power
                Message_Temp[1] = (Uint16) (Q/1000+25);         //Q power
                Message_Temp[2] = (Uint16) (Vdc);               //Vdc
                Message_Temp[3] = (Uint16) (S/1000+25);         //S power
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
                break;

            case 0x6865: //Phase Voltage Vph1, Vph2, Vph3, xx
                Message_Temp[0] = (Uint16) (10.0 * VaRMS);  //Vph1
                Message_Temp[1] = (Uint16) (10.0 * VbRMS);  //Vph2
                Message_Temp[2] = (Uint16) (10.0 * VcRMS);  //Vph3
                Message_Temp[3] = 0;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
                break;

            case 0x6866: //Phase Currents Iph1, Iph2, Iph3, Iph4
                Message_Temp[0] = (Uint16) (10.0 * IaRMS);      //Iph1
                Message_Temp[1] = (Uint16) (10.0 * IbRMS);      //Iph2
                Message_Temp[2] = (Uint16) (10.0 * IcRMS);      //Iph3
                Message_Temp[3] = (Uint16) (10.0 * InRMS);      //Iphn
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
                break;

            case 0x6867: //Aux legs data V and I
                Message_Temp[0] = (Uint16) (10.0 * Vaux1RMS);       //Vaux 1
                Message_Temp[1] = (Uint16) (10.0 * Iaux1RMS);       //Iaux 1
                Message_Temp[2] = (Uint16) (10.0 * Vaux2RMS);       //Vaux 2
                Message_Temp[3] = (Uint16) (10.0 * Iaux2RMS);       //Iaux 2
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
                break;

            case 0x6868: // Status register information
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_32;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_08;
                Message_Temp[2] = (Uint16) (Para_Int[44]);
                Message_Temp[3] = (Uint16) (Para_Int[44]);
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6869: // Trip register information
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_60;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_61;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_62;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_63;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6870: // Trip Enables
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_12;  //
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_13;  //
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_14;  //
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_15;  //
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6871: // Temperatures A
                Message_Temp[0] = (Uint16) (Para_Int[44]);  //
                Message_Temp[1] = (Uint16) (Para_Int[45]);  //
                Message_Temp[2] = (Uint16) (Para_Int[46]);  //
                Message_Temp[3] = (Uint16) (Para_Int[47]);  //
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6872: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_34;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_35;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_36;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_37;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6873: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_38;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_39;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_40;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_41;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6874: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_42;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_43;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_44;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_45;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6875: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_46;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_47;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_48;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_49;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6876: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_50;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_51;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_52;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_53;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6877: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_54;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_55;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_56;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_57;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6878: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_58;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_59;
                Message_Temp[2] = (Uint16) 0;
                Message_Temp[3] = (Uint16) 0;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;

            case 0x6879: // REGS
                Message_Temp[0] = (Uint16) *(Uint16 *)FPGA_REG_00;
                Message_Temp[1] = (Uint16) *(Uint16 *)FPGA_REG_03;
                Message_Temp[2] = (Uint16) *(Uint16 *)FPGA_REG_06;
                Message_Temp[3] = (Uint16) *(Uint16 *)FPGA_REG_08;
                SCIC_write_int16_LCD(0x73, Message_Temp, 0,8);
            break;



            case 0x6365: // Enable Converter
                Enable_Converter();
            break;

            case 0x6364: // Disable Converter
                Disable_Converter();
            break;

            case 0x7472: // Reset trips
                Reset_Trips();
            break;

            case 0x8082: // Read Parameter
                LCD_Read_Para();
            break;

            case 0x8057: // Write Parameter
                LCD_Write_Para();
            break;


            case 0:
                break;

            default:

                break;
            }
        }

}

    void LCD_Read_Para(void)
    {
        Uint16 Message_Temp[4] = {0,0,0,0};
        Uint16 para_num = ((Uint16)COM_C_DATA[0]);
        float ftmp=0;
        int16 itmp=0;

        if(para_num<50)
        {
            Message_Temp[0] = (Uint16)Para_Int[para_num];
        }
        else if ((para_num>=50) && (para_num<100))
        {
            ftmp = (100.0 * Para_Float[para_num-50]);
            itmp = (int16)ftmp;
            Message_Temp[0] = (Uint16)itmp;
        }
        else
        {
            Message_Temp[0] = 0;
        }
        SCIC_write_int16_LCD(0x83, Message_Temp, 0, 1);
   }

    void LCD_Write_Para(void)
    {
        int itmp = 0;
        float ftmp = 0;
        Uint16 para_num = ((Uint16)COM_C_DATA[0]);

        if(para_num<50)
        {
            itmp = (int)(((COM_C_DATA[1]<<8)&0xff00)|COM_C_DATA[2]);
            Para_Int[para_num]= itmp;
        }
        else if ((para_num>=50) & (para_num<100))
        {
            itmp = (int)(((COM_C_DATA[1]<<8)&0xff00)|COM_C_DATA[2]);
            ftmp = (float)(itmp*0.01);
            Para_Float[para_num-50]= ftmp;
        }
        else
        {
            return;
        }


    }
