/*
 * NG_Converter_support.h
 *
 *  Created on: 12 May 2019
 *      Author: Ed, Davide
 */

#ifndef NG_CONVERTER_SUPPORT_H_
#define NG_CONVERTER_SUPPORT_H_

#define FPGA_PWM_CLK 50000000

#include "F28x_Project.h"     // Device Headerfile and Examples Include File
#include "F2837xD_Device.h"     // Device header File
#include "Board_Delfino28379D.h" // Custom Project Header File
//#include "Parameters.h"
#include <math.h>
#include <stdio.h>
#include <float.h>

extern int16 Para_Int[50];
extern float Para_Float[50];
extern volatile Uint16 PWM_En;

int Initialise_FPGA(void);
void Enable_Converter(void);
void Disable_Converter(void);
void Reset_Trips(void);
void Close_Precharge_Relay(void);
void Open_Precharge_Relay(void);
void Fan_Control(void);
void Relay_control(Uint16 relay, bool state);   //changes relay state by setting or clearing the corresponding bit in FPGA_REG_06

void writeFpgaReg(Uint16 value, Uint16 channel);

void CONFIG_TRIP_EN_DIS(void);
void RESET_FPGA(void);
void SET_SWITCHING_FREQUENCY (float FSW);
void SET_WATCH_DOG(Uint16 SWPER);
void Change_switching_frequency(void);

void Modulator(float DCYa,float DCYb,float DCYc,float DCYn,float DCYaux1,float DCYaux2);
void read_currents(float*I1, float*I2, float*I3, float*I4, float*I5, float*I6, float fsw);
//ADC
//void ADCprocess2(Uint16 ADC_RAW, float*OUT, Uint16 offset, float gain);
float ADCprocess3(Uint16 channel);      //read adc channel, subtracts offset and multiplies by gain
//void ADCprocess(void);      //subtracts offset and multiplies by gain
//void setTripsLimits(void);
void setTrip(Uint16 channel, float up, float low);  //sets upper and lower trips, taking care of the conversion, enables trip
void readTripsStatus(void);
void lowpass(float X, float*Y, float tau);

/*
 * ADC registers index
 */
#define    ADC_VA_VNX      0
#define    ADC_VB_VNX      1
#define    ADC_VC_VNX      2
#define    ADC_VHTP_VHTN   3
#define    ADC_VAUX1_VHTN  4
#define    ADC_VAUX2_VHTN  5
#define    ADC_VNX_VHTN    6
#define    ADC_VN_VNX      7
#define    ADC_IA          8
#define    ADC_IB          9
#define    ADC_IC          10
#define    ADC_IAUX1       11
#define    ADC_IAUX2       12
#define    ADC_IC1         13
#define    ADC_IC2         14
#define    ADC_IHTP        15
#define    ADC_IC2B        16
#define    ADC_IN          17
#define    ADC_TEMP1       18
#define    ADC_TEMP2       19
#define    ADC_x_110AC_A   20
#define    ADC_x_110AC_B   21
#define    ADC_x_110AC_C   22
#define    ADC_x_1A_A      23
#define    ADC_x_1A_B      24
#define    ADC_x_1A_C      25


/*
 * Macros for reading ADC values and writing limits
 *
 * Usage example:
 *
 * CurrentIa=ADC_READ(ADC_IA);  //CurrentIa defined as Uint16
 *
 */

#define WD_CTRL         *(Uint16 *) FPGA_REG_00
#define INT_PRD         *(Uint16 *) FPGA_REG_02  //Interrupt period in clk cycles (50MHz) - (0xFFFF - No of clk cycles)
#define FPGA_CTRL       *(Uint16 *) FPGA_REG_03
#define DT_PRD          *(Uint16 *) FPGA_REG_04
#define WD_PRD          *(Uint16 *) FPGA_REG_05
#define RELAY_CTRL      *(Uint16 *) FPGA_REG_06
// 7 unused
#define PWM_ENABLE      *(Uint16 *) FPGA_REG_08
#define TRIP_COUNTER    *(Uint16 *) FPGA_REG_09 //trip counter threshold - 0 to 7
// 10 unused
#define TRIP_SET_B      *(Uint16 *) FPGA_REG_11
#define TRIP_ENABLE_A   *(Uint16 *) FPGA_REG_12
#define TRIP_ENABLE_B   *(Uint16 *) FPGA_REG_13
#define TRIP_ENABLE_C   *(Uint16 *) FPGA_REG_14
#define TRIP_ENABLE_D   *(Uint16 *) FPGA_REG_15
#define PWM_A_ON        *(Uint16 *) FPGA_REG_16
#define PWM_A_OFF       *(Uint16 *) FPGA_REG_17
#define PWM_B_ON        *(Uint16 *) FPGA_REG_18
#define PWM_B_OFF       *(Uint16 *) FPGA_REG_19
#define PWM_C_ON        *(Uint16 *) FPGA_REG_20
#define PWM_C_OFF       *(Uint16 *) FPGA_REG_21
#define PWM_N_ON        *(Uint16 *) FPGA_REG_22
#define PWM_N_OFF       *(Uint16 *) FPGA_REG_23
#define PWM_AUX1_ON     *(Uint16 *) FPGA_REG_24
#define PWM_AUX1_OFF    *(Uint16 *) FPGA_REG_25
#define PWM_AUX2_ON     *(Uint16 *) FPGA_REG_26
#define PWM_AUX2_OFF    *(Uint16 *) FPGA_REG_27

// 28-31 unused
#define TRIP_STATUS     *(Uint16 *) FPGA_REG_32
// 33 unused
// 34 to 59 ADC READINGS
#define ADC_READ(X)           *(Uint16 *)(ASRAM_CS3_START_ADDR+34+X)
// 60 to 63 unused

// 64 to 89 ADC TRIPS UP LIMIT
#define ADC_UP_LIMIT_FPGA(X)  *(Uint16 *)(ASRAM_CS3_START_ADDR+64+X)
// 90 to 115 ADC TRIPS UP LIMIT
#define ADC_LOW_LIMIT_FPGA(X) *(Uint16 *)(ASRAM_CS3_START_ADDR+90+X)
// 116 to 127 unused

#define ADC_IA_TRIGGER   *(Uint16 *) FPGA_REG_116
#define ADC_IB_TRIGGER   *(Uint16 *) FPGA_REG_117
#define ADC_IC_TRIGGER   *(Uint16 *) FPGA_REG_118
#define ADC_IN_TRIGGER   *(Uint16 *) FPGA_REG_119
#define ADC_IAUX1_TRIGGER   *(Uint16 *) FPGA_REG_120
#define ADC_IAUX2_TRIGGER   *(Uint16 *) FPGA_REG_121

struct TRIPS_STRUCT{
    volatile Uint16 STATUS;
    volatile Uint16 TRIP_A;
    volatile Uint16 TRIP_B;
    volatile Uint16 TRIP_C;
    volatile Uint16 TRIP_D;
};

//
Uint16 converterStart(void);




#endif /* NG_CONVERTER_SUPPORT_H_ */









